/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.processor;

import java.time.Duration;
import java.util.List;
import software.amazon.kinesis.common.StreamIdentifier;

public interface FormerStreamsLeasesDeletionStrategy {
    public List<StreamIdentifier> streamIdentifiersForLeaseCleanup();

    public Duration waitPeriodToDeleteFormerStreams();

    public StreamsLeasesDeletionType leaseDeletionType();

    public static abstract class ProvidedStreamsDeferredDeletionStrategy
    implements FormerStreamsLeasesDeletionStrategy {
        @Override
        public final StreamsLeasesDeletionType leaseDeletionType() {
            return StreamsLeasesDeletionType.PROVIDED_STREAMS_DEFERRED_DELETION;
        }
    }

    public static abstract class AutoDetectionAndDeferredDeletionStrategy
    implements FormerStreamsLeasesDeletionStrategy {
        @Override
        public final List<StreamIdentifier> streamIdentifiersForLeaseCleanup() {
            throw new UnsupportedOperationException("StreamIdentifiers not required");
        }

        @Override
        public final StreamsLeasesDeletionType leaseDeletionType() {
            return StreamsLeasesDeletionType.FORMER_STREAMS_AUTO_DETECTION_DEFERRED_DELETION;
        }
    }

    public static final class NoLeaseDeletionStrategy
    implements FormerStreamsLeasesDeletionStrategy {
        @Override
        public final List<StreamIdentifier> streamIdentifiersForLeaseCleanup() {
            throw new UnsupportedOperationException("StreamIdentifiers not required");
        }

        @Override
        public final Duration waitPeriodToDeleteFormerStreams() {
            return Duration.ZERO;
        }

        @Override
        public final StreamsLeasesDeletionType leaseDeletionType() {
            return StreamsLeasesDeletionType.NO_STREAMS_LEASES_DELETION;
        }
    }

    public static enum StreamsLeasesDeletionType {
        NO_STREAMS_LEASES_DELETION,
        FORMER_STREAMS_AUTO_DETECTION_DEFERRED_DELETION,
        PROVIDED_STREAMS_DEFERRED_DELETION;

    }
}

