/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval;

import java.time.Duration;
import lombok.NonNull;
import software.amazon.kinesis.common.StreamIdentifier;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.retrieval.DataFetcherProviderConfig;

public class KinesisDataFetcherProviderConfig
implements DataFetcherProviderConfig {
    @NonNull
    private StreamIdentifier streamIdentifier;
    @NonNull
    private String shardId;
    @NonNull
    private MetricsFactory metricsFactory;
    @NonNull
    private Integer maxRecords;
    @NonNull
    private Duration kinesisRequestTimeout;

    public KinesisDataFetcherProviderConfig(@NonNull StreamIdentifier streamIdentifier, @NonNull String shardId, @NonNull MetricsFactory metricsFactory, @NonNull Integer maxRecords, @NonNull Duration kinesisRequestTimeout) {
        if (streamIdentifier == null) {
            throw new NullPointerException("streamIdentifier");
        }
        if (shardId == null) {
            throw new NullPointerException("shardId");
        }
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        if (maxRecords == null) {
            throw new NullPointerException("maxRecords");
        }
        if (kinesisRequestTimeout == null) {
            throw new NullPointerException("kinesisRequestTimeout");
        }
        this.streamIdentifier = streamIdentifier;
        this.shardId = shardId;
        this.metricsFactory = metricsFactory;
        this.maxRecords = maxRecords;
        this.kinesisRequestTimeout = kinesisRequestTimeout;
    }

    @Override
    @NonNull
    public StreamIdentifier getStreamIdentifier() {
        return this.streamIdentifier;
    }

    @Override
    @NonNull
    public String getShardId() {
        return this.shardId;
    }

    @Override
    @NonNull
    public MetricsFactory getMetricsFactory() {
        return this.metricsFactory;
    }

    @Override
    @NonNull
    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    @Override
    @NonNull
    public Duration getKinesisRequestTimeout() {
        return this.kinesisRequestTimeout;
    }

    public void setStreamIdentifier(@NonNull StreamIdentifier streamIdentifier) {
        if (streamIdentifier == null) {
            throw new NullPointerException("streamIdentifier");
        }
        this.streamIdentifier = streamIdentifier;
    }

    public void setShardId(@NonNull String shardId) {
        if (shardId == null) {
            throw new NullPointerException("shardId");
        }
        this.shardId = shardId;
    }

    public void setMetricsFactory(@NonNull MetricsFactory metricsFactory) {
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        this.metricsFactory = metricsFactory;
    }

    public void setMaxRecords(@NonNull Integer maxRecords) {
        if (maxRecords == null) {
            throw new NullPointerException("maxRecords");
        }
        this.maxRecords = maxRecords;
    }

    public void setKinesisRequestTimeout(@NonNull Duration kinesisRequestTimeout) {
        if (kinesisRequestTimeout == null) {
            throw new NullPointerException("kinesisRequestTimeout");
        }
        this.kinesisRequestTimeout = kinesisRequestTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KinesisDataFetcherProviderConfig)) {
            return false;
        }
        KinesisDataFetcherProviderConfig other = (KinesisDataFetcherProviderConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StreamIdentifier this$streamIdentifier = this.getStreamIdentifier();
        StreamIdentifier other$streamIdentifier = other.getStreamIdentifier();
        if (this$streamIdentifier == null ? other$streamIdentifier != null : !((Object)this$streamIdentifier).equals(other$streamIdentifier)) {
            return false;
        }
        String this$shardId = this.getShardId();
        String other$shardId = other.getShardId();
        if (this$shardId == null ? other$shardId != null : !this$shardId.equals(other$shardId)) {
            return false;
        }
        MetricsFactory this$metricsFactory = this.getMetricsFactory();
        MetricsFactory other$metricsFactory = other.getMetricsFactory();
        if (this$metricsFactory == null ? other$metricsFactory != null : !this$metricsFactory.equals(other$metricsFactory)) {
            return false;
        }
        Integer this$maxRecords = this.getMaxRecords();
        Integer other$maxRecords = other.getMaxRecords();
        if (this$maxRecords == null ? other$maxRecords != null : !((Object)this$maxRecords).equals(other$maxRecords)) {
            return false;
        }
        Duration this$kinesisRequestTimeout = this.getKinesisRequestTimeout();
        Duration other$kinesisRequestTimeout = other.getKinesisRequestTimeout();
        return !(this$kinesisRequestTimeout == null ? other$kinesisRequestTimeout != null : !((Object)this$kinesisRequestTimeout).equals(other$kinesisRequestTimeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KinesisDataFetcherProviderConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StreamIdentifier $streamIdentifier = this.getStreamIdentifier();
        result = result * 59 + ($streamIdentifier == null ? 43 : ((Object)$streamIdentifier).hashCode());
        String $shardId = this.getShardId();
        result = result * 59 + ($shardId == null ? 43 : $shardId.hashCode());
        MetricsFactory $metricsFactory = this.getMetricsFactory();
        result = result * 59 + ($metricsFactory == null ? 43 : $metricsFactory.hashCode());
        Integer $maxRecords = this.getMaxRecords();
        result = result * 59 + ($maxRecords == null ? 43 : ((Object)$maxRecords).hashCode());
        Duration $kinesisRequestTimeout = this.getKinesisRequestTimeout();
        result = result * 59 + ($kinesisRequestTimeout == null ? 43 : ((Object)$kinesisRequestTimeout).hashCode());
        return result;
    }

    public String toString() {
        return "KinesisDataFetcherProviderConfig(streamIdentifier=" + this.getStreamIdentifier() + ", shardId=" + this.getShardId() + ", metricsFactory=" + this.getMetricsFactory() + ", maxRecords=" + this.getMaxRecords() + ", kinesisRequestTimeout=" + this.getKinesisRequestTimeout() + ")";
    }
}

