/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.common;

import com.google.common.base.Joiner;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.NonNull;
import software.amazon.awssdk.utils.Validate;

public class StreamIdentifier {
    private final Optional<String> accountIdOptional;
    private final String streamName;
    private final Optional<Long> streamCreationEpochOptional;
    private static final String DELIMITER = ":";
    private static final Pattern PATTERN = Pattern.compile(".*:.*:[0-9]*");

    private StreamIdentifier(@NonNull String accountId, @NonNull String streamName, @NonNull Long streamCreationEpoch) {
        if (accountId == null) {
            throw new NullPointerException("accountId");
        }
        if (streamName == null) {
            throw new NullPointerException("streamName");
        }
        if (streamCreationEpoch == null) {
            throw new NullPointerException("streamCreationEpoch");
        }
        this.accountIdOptional = Optional.of(accountId);
        this.streamName = streamName;
        this.streamCreationEpochOptional = Optional.of(streamCreationEpoch);
    }

    private StreamIdentifier(@NonNull String streamName) {
        if (streamName == null) {
            throw new NullPointerException("streamName");
        }
        this.accountIdOptional = Optional.empty();
        this.streamName = streamName;
        this.streamCreationEpochOptional = Optional.empty();
    }

    public String serialize() {
        return this.accountIdOptional.isPresent() ? Joiner.on((String)DELIMITER).join((Object)this.accountIdOptional.get(), (Object)this.streamName, new Object[]{this.streamCreationEpochOptional.get()}) : this.streamName;
    }

    public String toString() {
        return this.serialize();
    }

    public static StreamIdentifier multiStreamInstance(String streamIdentifierSer) {
        if (PATTERN.matcher(streamIdentifierSer).matches()) {
            String[] split = streamIdentifierSer.split(DELIMITER);
            return new StreamIdentifier(split[0], split[1], Long.parseLong(split[2]));
        }
        throw new IllegalArgumentException("Unable to deserialize StreamIdentifier from " + streamIdentifierSer);
    }

    public static StreamIdentifier singleStreamInstance(String streamName) {
        Validate.notEmpty((CharSequence)streamName, (String)"StreamName should not be empty", (Object[])new Object[0]);
        return new StreamIdentifier(streamName);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamIdentifier)) {
            return false;
        }
        StreamIdentifier other = (StreamIdentifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<String> this$accountIdOptional = this.accountIdOptional();
        Optional<String> other$accountIdOptional = other.accountIdOptional();
        if (this$accountIdOptional == null ? other$accountIdOptional != null : !((Object)this$accountIdOptional).equals(other$accountIdOptional)) {
            return false;
        }
        String this$streamName = this.streamName();
        String other$streamName = other.streamName();
        if (this$streamName == null ? other$streamName != null : !this$streamName.equals(other$streamName)) {
            return false;
        }
        Optional<Long> this$streamCreationEpochOptional = this.streamCreationEpochOptional();
        Optional<Long> other$streamCreationEpochOptional = other.streamCreationEpochOptional();
        return !(this$streamCreationEpochOptional == null ? other$streamCreationEpochOptional != null : !((Object)this$streamCreationEpochOptional).equals(other$streamCreationEpochOptional));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamIdentifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $accountIdOptional = this.accountIdOptional();
        result = result * 59 + ($accountIdOptional == null ? 43 : ((Object)$accountIdOptional).hashCode());
        String $streamName = this.streamName();
        result = result * 59 + ($streamName == null ? 43 : $streamName.hashCode());
        Optional<Long> $streamCreationEpochOptional = this.streamCreationEpochOptional();
        result = result * 59 + ($streamCreationEpochOptional == null ? 43 : ((Object)$streamCreationEpochOptional).hashCode());
        return result;
    }

    public Optional<String> accountIdOptional() {
        return this.accountIdOptional;
    }

    public String streamName() {
        return this.streamName;
    }

    public Optional<Long> streamCreationEpochOptional() {
        return this.streamCreationEpochOptional;
    }
}

