/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.coordinator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.coordinator.DiagnosticEventHandler;
import software.amazon.kinesis.coordinator.ExecutorStateEvent;
import software.amazon.kinesis.coordinator.RejectedTaskEvent;

@KinesisClientInternalApi
class DiagnosticEventLogger
implements DiagnosticEventHandler {
    private static final Logger log = LoggerFactory.getLogger(DiagnosticEventLogger.class);
    private static final long EXECUTOR_LOG_INTERVAL_MILLIS = 30000L;
    private long nextExecutorLogTime = System.currentTimeMillis() + 30000L;

    @Override
    public void visit(ExecutorStateEvent event) {
        if (System.currentTimeMillis() >= this.nextExecutorLogTime) {
            log.info(event.message());
            this.nextExecutorLogTime = System.currentTimeMillis() + 30000L;
        } else {
            log.debug(event.message());
        }
    }

    @Override
    public void visit(RejectedTaskEvent event) {
        log.error(event.message(), event.getThrowable());
    }
}

