/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.model.ChildShard;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.services.kinesis.model.ShardFilter;
import software.amazon.awssdk.services.kinesis.model.ShardFilterType;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.common.HashKeyRangeForLease;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.common.StreamIdentifier;
import software.amazon.kinesis.exceptions.internal.KinesisClientLibIOException;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.LeaseRefresher;
import software.amazon.kinesis.leases.MultiStreamLease;
import software.amazon.kinesis.leases.ShardDetector;
import software.amazon.kinesis.leases.exceptions.DependencyException;
import software.amazon.kinesis.leases.exceptions.InvalidStateException;
import software.amazon.kinesis.leases.exceptions.ProvisionedThroughputException;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.metrics.MetricsScope;
import software.amazon.kinesis.metrics.MetricsUtil;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

@KinesisClientInternalApi
public class HierarchicalShardSyncer {
    private static final Logger log = LoggerFactory.getLogger(HierarchicalShardSyncer.class);
    private final boolean isMultiStreamMode;
    private final String streamIdentifier;
    private static final String MIN_HASH_KEY = BigInteger.ZERO.toString();
    private static final String MAX_HASH_KEY = new BigInteger("2").pow(128).subtract(BigInteger.ONE).toString();
    private static final int retriesForCompleteHashRange = 3;
    private static final long DELAY_BETWEEN_LIST_SHARDS_MILLIS = 1000L;
    private static final BiFunction<Lease, MultiStreamArgs, String> shardIdFromLeaseDeducer = (lease, multiStreamArgs) -> multiStreamArgs.isMultiStreamMode() != false ? ((MultiStreamLease)lease).shardId() : lease.leaseKey();

    public HierarchicalShardSyncer() {
        this.isMultiStreamMode = false;
        this.streamIdentifier = "SingleStreamMode";
    }

    public HierarchicalShardSyncer(boolean isMultiStreamMode, String streamIdentifier) {
        this.isMultiStreamMode = isMultiStreamMode;
        this.streamIdentifier = streamIdentifier;
    }

    public synchronized boolean checkAndCreateLeaseForNewShards(@NonNull ShardDetector shardDetector, LeaseRefresher leaseRefresher, InitialPositionInStreamExtended initialPosition, MetricsScope scope, boolean ignoreUnexpectedChildShards, boolean isLeaseTableEmpty) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException, InterruptedException {
        if (shardDetector == null) {
            throw new NullPointerException("shardDetector");
        }
        List<Shard> latestShards = isLeaseTableEmpty ? HierarchicalShardSyncer.getShardListAtInitialPosition(shardDetector, initialPosition) : HierarchicalShardSyncer.getShardList(shardDetector);
        return this.checkAndCreateLeaseForNewShards(shardDetector, leaseRefresher, initialPosition, latestShards, ignoreUnexpectedChildShards, scope, isLeaseTableEmpty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean checkAndCreateLeaseForNewShards(@NonNull ShardDetector shardDetector, LeaseRefresher leaseRefresher, InitialPositionInStreamExtended initialPosition, List<Shard> latestShards, boolean ignoreUnexpectedChildShards, MetricsScope scope, boolean isLeaseTableEmpty) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        if (shardDetector == null) {
            throw new NullPointerException("shardDetector");
        }
        if (CollectionUtils.isNullOrEmpty(latestShards)) {
            log.warn("Skipping shard sync for {} as no shards found from service.", (Object)this.streamIdentifier);
            return false;
        }
        log.debug("{} - Num shards: {}", (Object)this.streamIdentifier, (Object)latestShards.size());
        Map<String, Shard> shardIdToShardMap = HierarchicalShardSyncer.constructShardIdToShardMap(latestShards);
        Map<String, Set<String>> shardIdToChildShardIdsMap = HierarchicalShardSyncer.constructShardIdToChildShardIdsMap(shardIdToShardMap);
        Set<String> inconsistentShardIds = HierarchicalShardSyncer.findInconsistentShardIds(shardIdToChildShardIdsMap, shardIdToShardMap);
        if (!ignoreUnexpectedChildShards) {
            HierarchicalShardSyncer.assertAllParentShardsAreClosed(inconsistentShardIds);
        }
        List<Lease> currentLeases = this.isMultiStreamMode ? leaseRefresher.listLeasesForStream(shardDetector.streamIdentifier()) : leaseRefresher.listLeases();
        MultiStreamArgs multiStreamArgs = new MultiStreamArgs(this.isMultiStreamMode, shardDetector.streamIdentifier());
        LeaseSynchronizer leaseSynchronizer = isLeaseTableEmpty ? new EmptyLeaseTableSynchronizer() : new NonEmptyLeaseTableSynchronizer(shardDetector, shardIdToShardMap, shardIdToChildShardIdsMap);
        List<Lease> newLeasesToCreate = HierarchicalShardSyncer.determineNewLeasesToCreate(leaseSynchronizer, latestShards, currentLeases, initialPosition, inconsistentShardIds, multiStreamArgs);
        log.debug("{} - Num new leases to create: {}", (Object)this.streamIdentifier, (Object)newLeasesToCreate.size());
        for (Lease lease : newLeasesToCreate) {
            long startTime = System.currentTimeMillis();
            boolean success = false;
            try {
                leaseRefresher.createLeaseIfNotExists(lease);
                success = true;
            }
            finally {
                MetricsUtil.addSuccessAndLatency(scope, "CreateLease", success, startTime, MetricsLevel.DETAILED);
            }
        }
        ArrayList<Lease> trackedLeases = new ArrayList<Lease>(currentLeases);
        trackedLeases.addAll(newLeasesToCreate);
        return true;
    }

    private static void assertAllParentShardsAreClosed(Set<String> inconsistentShardIds) throws KinesisClientLibIOException {
        if (!CollectionUtils.isNullOrEmpty(inconsistentShardIds)) {
            String ids = StringUtils.join(inconsistentShardIds, (char)' ');
            throw new KinesisClientLibIOException(String.format("%d open child shards (%s) are inconsistent. This can happen due to a race condition between describeStream and a reshard operation.", inconsistentShardIds.size(), ids));
        }
    }

    private static Set<String> findInconsistentShardIds(Map<String, Set<String>> shardIdToChildShardIdsMap, Map<String, Shard> shardIdToShardMap) {
        return shardIdToChildShardIdsMap.entrySet().stream().filter(entry -> entry.getKey() == null || ((Shard)shardIdToShardMap.get(entry.getKey())).sequenceNumberRange().endingSequenceNumber() == null).flatMap(entry -> ((Set)shardIdToChildShardIdsMap.get(entry.getKey())).stream()).collect(Collectors.toSet());
    }

    private synchronized void assertHashRangeOfClosedShardIsCovered(Shard closedShard, Map<String, Shard> shardIdToShardMap, Set<String> childShardIds) throws KinesisClientLibIOException {
        BigInteger minStartingHashKeyOfChildren = null;
        BigInteger maxEndingHashKeyOfChildren = null;
        BigInteger startingHashKeyOfClosedShard = new BigInteger(closedShard.hashKeyRange().startingHashKey());
        BigInteger endingHashKeyOfClosedShard = new BigInteger(closedShard.hashKeyRange().endingHashKey());
        for (String childShardId : childShardIds) {
            Shard childShard = shardIdToShardMap.get(childShardId);
            BigInteger startingHashKey = new BigInteger(childShard.hashKeyRange().startingHashKey());
            if (minStartingHashKeyOfChildren == null || startingHashKey.compareTo(minStartingHashKeyOfChildren) < 0) {
                minStartingHashKeyOfChildren = startingHashKey;
            }
            BigInteger endingHashKey = new BigInteger(childShard.hashKeyRange().endingHashKey());
            if (maxEndingHashKeyOfChildren != null && endingHashKey.compareTo(maxEndingHashKeyOfChildren) <= 0) continue;
            maxEndingHashKeyOfChildren = endingHashKey;
        }
        if (minStartingHashKeyOfChildren == null || maxEndingHashKeyOfChildren == null || minStartingHashKeyOfChildren.compareTo(startingHashKeyOfClosedShard) > 0 || maxEndingHashKeyOfChildren.compareTo(endingHashKeyOfClosedShard) < 0) {
            throw new KinesisClientLibIOException(String.format("Incomplete shard list: hash key range of shard %s is not covered by its child shards.", closedShard.shardId()));
        }
    }

    static Map<String, Set<String>> constructShardIdToChildShardIdsMap(Map<String, Shard> shardIdToShardMap) {
        HashMap<String, Set<String>> shardIdToChildShardIdsMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Shard> entry : shardIdToShardMap.entrySet()) {
            String adjacentParentShardId;
            String shardId = entry.getKey();
            Shard shard = entry.getValue();
            String parentShardId = shard.parentShardId();
            if (parentShardId != null && shardIdToShardMap.containsKey(parentShardId)) {
                Set childShardIds = shardIdToChildShardIdsMap.computeIfAbsent(parentShardId, key -> new HashSet());
                childShardIds.add(shardId);
            }
            if ((adjacentParentShardId = shard.adjacentParentShardId()) == null || !shardIdToShardMap.containsKey(adjacentParentShardId)) continue;
            Set childShardIds = shardIdToChildShardIdsMap.computeIfAbsent(adjacentParentShardId, key -> new HashSet());
            childShardIds.add(shardId);
        }
        return shardIdToChildShardIdsMap;
    }

    private static ShardFilter getShardFilterFromInitialPosition(InitialPositionInStreamExtended initialPositionInStreamExtended) {
        ShardFilter.Builder builder = ShardFilter.builder();
        switch (initialPositionInStreamExtended.getInitialPositionInStream()) {
            case LATEST: {
                builder = builder.type(ShardFilterType.AT_LATEST);
                break;
            }
            case TRIM_HORIZON: {
                builder = builder.type(ShardFilterType.AT_TRIM_HORIZON);
                break;
            }
            case AT_TIMESTAMP: {
                builder = builder.type(ShardFilterType.AT_TIMESTAMP).timestamp(initialPositionInStreamExtended.getTimestamp().toInstant());
            }
        }
        return (ShardFilter)builder.build();
    }

    private static List<Shard> getShardListAtInitialPosition(@NonNull ShardDetector shardDetector, InitialPositionInStreamExtended initialPositionInStreamExtended) throws KinesisClientLibIOException, InterruptedException {
        if (shardDetector == null) {
            throw new NullPointerException("shardDetector");
        }
        ShardFilter shardFilter = HierarchicalShardSyncer.getShardFilterFromInitialPosition(initialPositionInStreamExtended);
        String streamName = shardDetector.streamIdentifier().streamName();
        for (int i = 0; i < 3; ++i) {
            List<Shard> shards = shardDetector.listShardsWithFilter(shardFilter);
            if (shards == null) {
                throw new KinesisClientLibIOException("Stream " + streamName + " is not in ACTIVE OR UPDATING state - will retry getting the shard list.");
            }
            if (HierarchicalShardSyncer.isHashRangeOfShardsComplete(shards)) {
                return shards;
            }
            Thread.sleep(1000L);
        }
        throw new KinesisClientLibIOException("Hash range of shards returned for " + streamName + " was incomplete after " + 3 + " retries.");
    }

    private static List<Shard> getShardList(@NonNull ShardDetector shardDetector) throws KinesisClientLibIOException {
        if (shardDetector == null) {
            throw new NullPointerException("shardDetector");
        }
        Optional<List<Shard>> shards = Optional.of(shardDetector.listShards());
        return shards.orElseThrow(() -> new KinesisClientLibIOException("Stream " + shardDetector.streamIdentifier().streamName() + " is not in ACTIVE OR UPDATING state - will retry getting the shard list."));
    }

    private static boolean isHashRangeOfShardsComplete(@NonNull List<Shard> shards) {
        if (shards == null) {
            throw new NullPointerException("shards");
        }
        if (shards.isEmpty()) {
            throw new IllegalStateException("No shards found when attempting to validate complete hash range.");
        }
        ShardStartingHashKeyBasedComparator shardStartingHashKeyBasedComparator = new ShardStartingHashKeyBasedComparator();
        shards.sort(shardStartingHashKeyBasedComparator);
        if (!shards.get(0).hashKeyRange().startingHashKey().equals(MIN_HASH_KEY) || !shards.get(shards.size() - 1).hashKeyRange().endingHashKey().equals(MAX_HASH_KEY)) {
            return false;
        }
        if (shards.size() > 1) {
            for (int i = 1; i < shards.size(); ++i) {
                Shard shardAtStartOfPossibleHole = shards.get(i - 1);
                Shard shardAtEndOfPossibleHole = shards.get(i);
                BigInteger startOfPossibleHole = new BigInteger(shardAtStartOfPossibleHole.hashKeyRange().endingHashKey());
                BigInteger endOfPossibleHole = new BigInteger(shardAtEndOfPossibleHole.hashKeyRange().startingHashKey());
                if (endOfPossibleHole.subtract(startOfPossibleHole).equals(BigInteger.ONE)) continue;
                log.error("Incomplete hash range found between {} and {}.", (Object)shardAtStartOfPossibleHole, (Object)shardAtEndOfPossibleHole);
                return false;
            }
        }
        return true;
    }

    static List<Lease> determineNewLeasesToCreate(LeaseSynchronizer leaseSynchronizer, List<Shard> shards, List<Lease> currentLeases, InitialPositionInStreamExtended initialPosition, Set<String> inconsistentShardIds, MultiStreamArgs multiStreamArgs) {
        return leaseSynchronizer.determineNewLeasesToCreate(shards, currentLeases, initialPosition, inconsistentShardIds, multiStreamArgs);
    }

    static List<Lease> determineNewLeasesToCreate(LeaseSynchronizer leaseSynchronizer, List<Shard> shards, List<Lease> currentLeases, InitialPositionInStreamExtended initialPosition, Set<String> inconsistentShardIds) {
        return HierarchicalShardSyncer.determineNewLeasesToCreate(leaseSynchronizer, shards, currentLeases, initialPosition, inconsistentShardIds, new MultiStreamArgs(false, null));
    }

    static List<Lease> determineNewLeasesToCreate(LeaseSynchronizer leaseSynchronizer, List<Shard> shards, List<Lease> currentLeases, InitialPositionInStreamExtended initialPosition) {
        HashSet<String> inconsistentShardIds = new HashSet<String>();
        return HierarchicalShardSyncer.determineNewLeasesToCreate(leaseSynchronizer, shards, currentLeases, initialPosition, inconsistentShardIds);
    }

    static boolean checkIfDescendantAndAddNewLeasesForAncestors(String shardId, InitialPositionInStreamExtended initialPosition, Set<String> shardIdsOfCurrentLeases, Map<String, Shard> shardIdToShardMapOfAllKinesisShards, Map<String, Lease> shardIdToLeaseMapOfNewShards, MemoizationContext memoizationContext, MultiStreamArgs multiStreamArgs) {
        String streamIdentifier = HierarchicalShardSyncer.getStreamIdentifier(multiStreamArgs);
        Boolean previousValue = memoizationContext.isDescendant(shardId);
        if (previousValue != null) {
            return previousValue;
        }
        boolean isDescendant = false;
        HashSet<String> descendantParentShardIds = new HashSet<String>();
        if (shardId != null && shardIdToShardMapOfAllKinesisShards.containsKey(shardId)) {
            if (shardIdsOfCurrentLeases.contains(shardId)) {
                isDescendant = true;
            } else {
                Shard shard = shardIdToShardMapOfAllKinesisShards.get(shardId);
                Set<String> parentShardIds = HierarchicalShardSyncer.getParentShardIds(shard, shardIdToShardMapOfAllKinesisShards);
                for (String parentShardId : parentShardIds) {
                    boolean isParentDescendant = HierarchicalShardSyncer.checkIfDescendantAndAddNewLeasesForAncestors(parentShardId, initialPosition, shardIdsOfCurrentLeases, shardIdToShardMapOfAllKinesisShards, shardIdToLeaseMapOfNewShards, memoizationContext, multiStreamArgs);
                    if (isParentDescendant || memoizationContext.shouldCreateLease(parentShardId).booleanValue()) {
                        isDescendant = true;
                        descendantParentShardIds.add(parentShardId);
                        log.debug("{} : Parent shard {} is a descendant.", (Object)streamIdentifier, (Object)parentShardId);
                        continue;
                    }
                    log.debug("{} : Parent shard {} is NOT a descendant.", (Object)streamIdentifier, (Object)parentShardId);
                }
                if (isDescendant) {
                    for (String parentShardId : parentShardIds) {
                        if (shardIdsOfCurrentLeases.contains(parentShardId)) continue;
                        Lease lease = shardIdToLeaseMapOfNewShards.get(parentShardId);
                        if (lease == null && (memoizationContext.shouldCreateLease(parentShardId).booleanValue() || !descendantParentShardIds.contains(parentShardId))) {
                            log.debug("{} : Need to create a lease for shardId {}", (Object)streamIdentifier, (Object)parentShardId);
                            lease = multiStreamArgs.isMultiStreamMode() != false ? HierarchicalShardSyncer.newKCLMultiStreamLease(shardIdToShardMapOfAllKinesisShards.get(parentShardId), multiStreamArgs.streamIdentifier()) : HierarchicalShardSyncer.newKCLLease(shardIdToShardMapOfAllKinesisShards.get(parentShardId));
                            shardIdToLeaseMapOfNewShards.put(parentShardId, lease);
                        }
                        if (lease == null) continue;
                        if (descendantParentShardIds.contains(parentShardId) && !initialPosition.getInitialPositionInStream().equals((Object)InitialPositionInStream.AT_TIMESTAMP)) {
                            lease.checkpoint(ExtendedSequenceNumber.TRIM_HORIZON);
                            continue;
                        }
                        lease.checkpoint(HierarchicalShardSyncer.convertToCheckpoint(initialPosition));
                    }
                } else if (initialPosition.getInitialPositionInStream().equals((Object)InitialPositionInStream.TRIM_HORIZON) || initialPosition.getInitialPositionInStream().equals((Object)InitialPositionInStream.AT_TIMESTAMP)) {
                    memoizationContext.setShouldCreateLease(shardId, true);
                }
            }
        }
        memoizationContext.setIsDescendant(shardId, isDescendant);
        return isDescendant;
    }

    static boolean checkIfDescendantAndAddNewLeasesForAncestors(String shardId, InitialPositionInStreamExtended initialPosition, Set<String> shardIdsOfCurrentLeases, Map<String, Shard> shardIdToShardMapOfAllKinesisShards, Map<String, Lease> shardIdToLeaseMapOfNewShards, MemoizationContext memoizationContext) {
        return HierarchicalShardSyncer.checkIfDescendantAndAddNewLeasesForAncestors(shardId, initialPosition, shardIdsOfCurrentLeases, shardIdToShardMapOfAllKinesisShards, shardIdToLeaseMapOfNewShards, memoizationContext, new MultiStreamArgs(false, null));
    }

    static Set<String> getParentShardIds(Shard shard, Map<String, Shard> shardIdToShardMapOfAllKinesisShards) {
        String adjacentParentShardId;
        HashSet<String> parentShardIds = new HashSet<String>(2);
        String parentShardId = shard.parentShardId();
        if (parentShardId != null && shardIdToShardMapOfAllKinesisShards.containsKey(parentShardId)) {
            parentShardIds.add(parentShardId);
        }
        if ((adjacentParentShardId = shard.adjacentParentShardId()) != null && shardIdToShardMapOfAllKinesisShards.containsKey(adjacentParentShardId)) {
            parentShardIds.add(adjacentParentShardId);
        }
        return parentShardIds;
    }

    public synchronized Lease createLeaseForChildShard(ChildShard childShard, StreamIdentifier streamIdentifier) throws InvalidStateException {
        MultiStreamArgs multiStreamArgs = new MultiStreamArgs(this.isMultiStreamMode, streamIdentifier);
        return multiStreamArgs.isMultiStreamMode() != false ? HierarchicalShardSyncer.newKCLMultiStreamLeaseForChildShard(childShard, streamIdentifier) : HierarchicalShardSyncer.newKCLLeaseForChildShard(childShard);
    }

    private static Lease newKCLLeaseForChildShard(ChildShard childShard) throws InvalidStateException {
        Lease newLease = new Lease();
        newLease.leaseKey(childShard.shardId());
        if (CollectionUtils.isNullOrEmpty((Collection)childShard.parentShards())) {
            throw new InvalidStateException("Unable to populate new lease for child shard " + childShard.shardId() + "because parent shards cannot be found.");
        }
        newLease.parentShardIds(childShard.parentShards());
        newLease.checkpoint(ExtendedSequenceNumber.TRIM_HORIZON);
        newLease.ownerSwitchesSinceCheckpoint(0L);
        newLease.hashKeyRange(HashKeyRangeForLease.fromHashKeyRange(childShard.hashKeyRange()));
        return newLease;
    }

    private static Lease newKCLMultiStreamLeaseForChildShard(ChildShard childShard, StreamIdentifier streamIdentifier) throws InvalidStateException {
        MultiStreamLease newLease = new MultiStreamLease();
        newLease.leaseKey(MultiStreamLease.getLeaseKey(streamIdentifier.serialize(), childShard.shardId()));
        if (CollectionUtils.isNullOrEmpty((Collection)childShard.parentShards())) {
            throw new InvalidStateException("Unable to populate new lease for child shard " + childShard.shardId() + "because parent shards cannot be found.");
        }
        newLease.parentShardIds(childShard.parentShards());
        newLease.checkpoint(ExtendedSequenceNumber.TRIM_HORIZON);
        newLease.ownerSwitchesSinceCheckpoint(0L);
        newLease.streamIdentifier(streamIdentifier.serialize());
        newLease.shardId(childShard.shardId());
        newLease.hashKeyRange(HashKeyRangeForLease.fromHashKeyRange(childShard.hashKeyRange()));
        return newLease;
    }

    private static Lease newKCLLease(Shard shard) {
        Lease newLease = new Lease();
        newLease.leaseKey(shard.shardId());
        ArrayList<String> parentShardIds = new ArrayList<String>(2);
        if (shard.parentShardId() != null) {
            parentShardIds.add(shard.parentShardId());
        }
        if (shard.adjacentParentShardId() != null) {
            parentShardIds.add(shard.adjacentParentShardId());
        }
        newLease.parentShardIds(parentShardIds);
        newLease.ownerSwitchesSinceCheckpoint(0L);
        newLease.hashKeyRange(HashKeyRangeForLease.fromHashKeyRange(shard.hashKeyRange()));
        return newLease;
    }

    private static Lease newKCLMultiStreamLease(Shard shard, StreamIdentifier streamIdentifier) {
        MultiStreamLease newLease = new MultiStreamLease();
        newLease.leaseKey(MultiStreamLease.getLeaseKey(streamIdentifier.serialize(), shard.shardId()));
        ArrayList<String> parentShardIds = new ArrayList<String>(2);
        if (shard.parentShardId() != null) {
            parentShardIds.add(shard.parentShardId());
        }
        if (shard.adjacentParentShardId() != null) {
            parentShardIds.add(shard.adjacentParentShardId());
        }
        newLease.parentShardIds(parentShardIds);
        newLease.ownerSwitchesSinceCheckpoint(0L);
        newLease.streamIdentifier(streamIdentifier.serialize());
        newLease.shardId(shard.shardId());
        newLease.hashKeyRange(HashKeyRangeForLease.fromHashKeyRange(shard.hashKeyRange()));
        return newLease;
    }

    static Map<String, Shard> constructShardIdToShardMap(List<Shard> shards) {
        return shards.stream().collect(Collectors.toMap(Shard::shardId, Function.identity()));
    }

    static List<Shard> getOpenShards(List<Shard> allShards, String streamIdentifier) {
        return allShards.stream().filter(shard -> shard.sequenceNumberRange().endingSequenceNumber() == null).peek(shard -> log.debug("{} : Found open shard: {}", (Object)streamIdentifier, (Object)shard.shardId())).collect(Collectors.toList());
    }

    private static ExtendedSequenceNumber convertToCheckpoint(InitialPositionInStreamExtended position) {
        ExtendedSequenceNumber checkpoint = null;
        if (position.getInitialPositionInStream().equals((Object)InitialPositionInStream.TRIM_HORIZON)) {
            checkpoint = ExtendedSequenceNumber.TRIM_HORIZON;
        } else if (position.getInitialPositionInStream().equals((Object)InitialPositionInStream.LATEST)) {
            checkpoint = ExtendedSequenceNumber.LATEST;
        } else if (position.getInitialPositionInStream().equals((Object)InitialPositionInStream.AT_TIMESTAMP)) {
            checkpoint = ExtendedSequenceNumber.AT_TIMESTAMP;
        }
        return checkpoint;
    }

    private static String getStreamIdentifier(MultiStreamArgs multiStreamArgs) {
        return Optional.ofNullable(multiStreamArgs.streamIdentifier()).map(streamId -> streamId.serialize()).orElse("single_stream_mode");
    }

    static class MemoizationContext {
        private Map<String, Boolean> isDescendantMap = new HashMap<String, Boolean>();
        private Map<String, Boolean> shouldCreateLeaseMap = new HashMap<String, Boolean>();

        Boolean isDescendant(String shardId) {
            return this.isDescendantMap.get(shardId);
        }

        void setIsDescendant(String shardId, Boolean isDescendant) {
            this.isDescendantMap.put(shardId, isDescendant);
        }

        Boolean shouldCreateLease(String shardId) {
            return this.shouldCreateLeaseMap.computeIfAbsent(shardId, x -> Boolean.FALSE);
        }

        void setShouldCreateLease(String shardId, Boolean shouldCreateLease) {
            this.shouldCreateLeaseMap.put(shardId, shouldCreateLease);
        }
    }

    static class NonEmptyLeaseTableSynchronizer
    implements LeaseSynchronizer {
        private static final Logger log = LoggerFactory.getLogger(NonEmptyLeaseTableSynchronizer.class);
        private final ShardDetector shardDetector;
        private final Map<String, Shard> shardIdToShardMap;
        private final Map<String, Set<String>> shardIdToChildShardIdsMap;

        @Override
        public synchronized List<Lease> determineNewLeasesToCreate(List<Shard> shards, List<Lease> currentLeases, InitialPositionInStreamExtended initialPosition, Set<String> inconsistentShardIds, MultiStreamArgs multiStreamArgs) {
            HashMap<String, Lease> shardIdToNewLeaseMap = new HashMap<String, Lease>();
            Map<String, Shard> shardIdToShardMapOfAllKinesisShards = HierarchicalShardSyncer.constructShardIdToShardMap(shards);
            String streamIdentifier = Optional.ofNullable(multiStreamArgs.streamIdentifier()).map(streamId -> streamId.serialize()).orElse("");
            Set<String> shardIdsOfCurrentLeases = currentLeases.stream().peek(lease -> log.debug("{} : Existing lease: {}", (Object)streamIdentifier, lease)).map(lease -> (String)shardIdFromLeaseDeducer.apply(lease, multiStreamArgs)).collect(Collectors.toSet());
            List<Shard> openShards = HierarchicalShardSyncer.getOpenShards(shards, streamIdentifier);
            MemoizationContext memoizationContext = new MemoizationContext();
            for (Shard shard : openShards) {
                String shardId = shard.shardId();
                log.debug("{} : Evaluating leases for open shard {} and its ancestors.", (Object)streamIdentifier, (Object)shardId);
                if (shardIdsOfCurrentLeases.contains(shardId)) {
                    log.debug("{} : Lease for shardId {} already exists. Not creating a lease", (Object)streamIdentifier, (Object)shardId);
                    continue;
                }
                if (inconsistentShardIds.contains(shardId)) {
                    log.info("{} : shardId {} is an inconsistent child.  Not creating a lease", (Object)streamIdentifier, (Object)shardId);
                    continue;
                }
                log.debug("{} : Beginning traversal of ancestry tree for shardId {}", (Object)streamIdentifier, (Object)shardId);
                boolean isDescendant = HierarchicalShardSyncer.checkIfDescendantAndAddNewLeasesForAncestors(shardId, initialPosition, shardIdsOfCurrentLeases, shardIdToShardMapOfAllKinesisShards, shardIdToNewLeaseMap, memoizationContext, multiStreamArgs);
                if (!isDescendant) {
                    log.debug("{} : shardId {} has no ancestors. Creating a lease.", (Object)streamIdentifier, (Object)shardId);
                    Lease newLease = multiStreamArgs.isMultiStreamMode() != false ? HierarchicalShardSyncer.newKCLMultiStreamLease(shard, multiStreamArgs.streamIdentifier()) : HierarchicalShardSyncer.newKCLLease(shard);
                    newLease.checkpoint(HierarchicalShardSyncer.convertToCheckpoint(initialPosition));
                    log.debug("{} : Set checkpoint of {} to {}", new Object[]{streamIdentifier, newLease.leaseKey(), newLease.checkpoint()});
                    shardIdToNewLeaseMap.put(shardId, newLease);
                    continue;
                }
                log.debug("{} : shardId {} is a descendant whose ancestors should already have leases. Not creating a lease.", (Object)streamIdentifier, (Object)shardId);
            }
            ArrayList<Lease> newLeasesToCreate = new ArrayList<Lease>(shardIdToNewLeaseMap.values());
            StartingSequenceNumberAndShardIdBasedComparator startingSequenceNumberComparator = new StartingSequenceNumberAndShardIdBasedComparator(shardIdToShardMapOfAllKinesisShards, multiStreamArgs);
            newLeasesToCreate.sort(startingSequenceNumberComparator);
            return newLeasesToCreate;
        }

        public NonEmptyLeaseTableSynchronizer(ShardDetector shardDetector, Map<String, Shard> shardIdToShardMap, Map<String, Set<String>> shardIdToChildShardIdsMap) {
            this.shardDetector = shardDetector;
            this.shardIdToShardMap = shardIdToShardMap;
            this.shardIdToChildShardIdsMap = shardIdToChildShardIdsMap;
        }
    }

    static class EmptyLeaseTableSynchronizer
    implements LeaseSynchronizer {
        private static final Logger log = LoggerFactory.getLogger(EmptyLeaseTableSynchronizer.class);

        @Override
        public List<Lease> determineNewLeasesToCreate(List<Shard> shards, List<Lease> currentLeases, InitialPositionInStreamExtended initialPosition, Set<String> inconsistentShardIds, MultiStreamArgs multiStreamArgs) {
            String streamIdentifier = Optional.ofNullable(multiStreamArgs.streamIdentifier()).map(streamId -> streamId.serialize()).orElse("");
            Map<String, Shard> shardIdToShardMapOfAllKinesisShards = HierarchicalShardSyncer.constructShardIdToShardMap(shards);
            currentLeases.stream().peek(lease -> log.debug("{} : Existing lease: {}", (Object)streamIdentifier, lease)).map(lease -> (String)shardIdFromLeaseDeducer.apply(lease, multiStreamArgs)).collect(Collectors.toSet());
            List<Lease> newLeasesToCreate = this.getLeasesToCreateForOpenAndClosedShards(initialPosition, shards, multiStreamArgs, streamIdentifier);
            StartingSequenceNumberAndShardIdBasedComparator startingSequenceNumberComparator = new StartingSequenceNumberAndShardIdBasedComparator(shardIdToShardMapOfAllKinesisShards, multiStreamArgs);
            newLeasesToCreate.sort(startingSequenceNumberComparator);
            return newLeasesToCreate;
        }

        private List<Lease> getLeasesToCreateForOpenAndClosedShards(InitialPositionInStreamExtended initialPosition, List<Shard> shards, MultiStreamArgs multiStreamArgs, String streamId) {
            HashMap<String, Lease> shardIdToNewLeaseMap = new HashMap<String, Lease>();
            for (Shard shard : shards) {
                String shardId = shard.shardId();
                Lease lease = multiStreamArgs.isMultiStreamMode() != false ? HierarchicalShardSyncer.newKCLMultiStreamLease(shard, multiStreamArgs.streamIdentifier) : HierarchicalShardSyncer.newKCLLease(shard);
                lease.checkpoint(HierarchicalShardSyncer.convertToCheckpoint(initialPosition));
                log.debug("{} : Need to create a lease for shard with shardId {}", (Object)streamId, (Object)shardId);
                shardIdToNewLeaseMap.put(shardId, lease);
            }
            return new ArrayList<Lease>(shardIdToNewLeaseMap.values());
        }
    }

    @VisibleForTesting
    static interface LeaseSynchronizer {
        public List<Lease> determineNewLeasesToCreate(List<Shard> var1, List<Lease> var2, InitialPositionInStreamExtended var3, Set<String> var4, MultiStreamArgs var5);
    }

    @VisibleForTesting
    static class MultiStreamArgs {
        private final Boolean isMultiStreamMode;
        private final StreamIdentifier streamIdentifier;

        public MultiStreamArgs(Boolean isMultiStreamMode, StreamIdentifier streamIdentifier) {
            this.isMultiStreamMode = isMultiStreamMode;
            this.streamIdentifier = streamIdentifier;
        }

        public Boolean isMultiStreamMode() {
            return this.isMultiStreamMode;
        }

        public StreamIdentifier streamIdentifier() {
            return this.streamIdentifier;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiStreamArgs)) {
                return false;
            }
            MultiStreamArgs other = (MultiStreamArgs)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isMultiStreamMode = this.isMultiStreamMode();
            Boolean other$isMultiStreamMode = other.isMultiStreamMode();
            if (this$isMultiStreamMode == null ? other$isMultiStreamMode != null : !((Object)this$isMultiStreamMode).equals(other$isMultiStreamMode)) {
                return false;
            }
            StreamIdentifier this$streamIdentifier = this.streamIdentifier();
            StreamIdentifier other$streamIdentifier = other.streamIdentifier();
            return !(this$streamIdentifier == null ? other$streamIdentifier != null : !((Object)this$streamIdentifier).equals(other$streamIdentifier));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MultiStreamArgs;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isMultiStreamMode = this.isMultiStreamMode();
            result = result * 59 + ($isMultiStreamMode == null ? 43 : ((Object)$isMultiStreamMode).hashCode());
            StreamIdentifier $streamIdentifier = this.streamIdentifier();
            result = result * 59 + ($streamIdentifier == null ? 43 : ((Object)$streamIdentifier).hashCode());
            return result;
        }

        public String toString() {
            return "HierarchicalShardSyncer.MultiStreamArgs(isMultiStreamMode=" + this.isMultiStreamMode() + ", streamIdentifier=" + this.streamIdentifier() + ")";
        }
    }

    private static class StartingSequenceNumberAndShardIdBasedComparator
    implements Comparator<Lease>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, Shard> shardIdToShardMap;
        private final MultiStreamArgs multiStreamArgs;

        @Override
        public int compare(Lease lease1, Lease lease2) {
            int result = 0;
            String shardId1 = (String)shardIdFromLeaseDeducer.apply(lease1, this.multiStreamArgs);
            String shardId2 = (String)shardIdFromLeaseDeducer.apply(lease2, this.multiStreamArgs);
            Shard shard1 = this.shardIdToShardMap.get(shardId1);
            Shard shard2 = this.shardIdToShardMap.get(shardId2);
            if (shard1 != null && shard2 != null) {
                BigInteger sequenceNumber1 = new BigInteger(shard1.sequenceNumberRange().startingSequenceNumber());
                BigInteger sequenceNumber2 = new BigInteger(shard2.sequenceNumberRange().startingSequenceNumber());
                result = sequenceNumber1.compareTo(sequenceNumber2);
            }
            if (result == 0) {
                result = shardId1.compareTo(shardId2);
            }
            return result;
        }

        public StartingSequenceNumberAndShardIdBasedComparator(Map<String, Shard> shardIdToShardMap, MultiStreamArgs multiStreamArgs) {
            this.shardIdToShardMap = shardIdToShardMap;
            this.multiStreamArgs = multiStreamArgs;
        }
    }

    private static class ShardStartingHashKeyBasedComparator
    implements Comparator<Shard>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Shard shard1, Shard shard2) {
            BigInteger hashKey1 = new BigInteger(shard1.hashKeyRange().startingHashKey());
            BigInteger hashKey2 = new BigInteger(shard2.hashKeyRange().startingHashKey());
            return hashKey1.compareTo(hashKey2);
        }
    }
}

