/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases.dynamodb;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import lombok.NonNull;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.common.LeaseCleanupConfig;
import software.amazon.kinesis.common.StreamConfig;
import software.amazon.kinesis.common.StreamIdentifier;
import software.amazon.kinesis.leases.HierarchicalShardSyncer;
import software.amazon.kinesis.leases.KinesisShardDetector;
import software.amazon.kinesis.leases.LeaseCleanupManager;
import software.amazon.kinesis.leases.LeaseCoordinator;
import software.amazon.kinesis.leases.LeaseManagementConfig;
import software.amazon.kinesis.leases.LeaseManagementFactory;
import software.amazon.kinesis.leases.LeaseSerializer;
import software.amazon.kinesis.leases.ShardDetector;
import software.amazon.kinesis.leases.ShardSyncTaskManager;
import software.amazon.kinesis.leases.dynamodb.DynamoDBLeaseCoordinator;
import software.amazon.kinesis.leases.dynamodb.DynamoDBLeaseRefresher;
import software.amazon.kinesis.leases.dynamodb.DynamoDBLeaseSerializer;
import software.amazon.kinesis.leases.dynamodb.TableCreatorCallback;
import software.amazon.kinesis.metrics.MetricsFactory;

@KinesisClientInternalApi
public class DynamoDBLeaseManagementFactory
implements LeaseManagementFactory {
    @NonNull
    private final KinesisAsyncClient kinesisClient;
    @NonNull
    private final DynamoDbAsyncClient dynamoDBClient;
    @NonNull
    private final String tableName;
    @NonNull
    private final String workerIdentifier;
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final HierarchicalShardSyncer deprecatedHierarchicalShardSyncer;
    @NonNull
    private final LeaseSerializer leaseSerializer;
    @NonNull
    private StreamConfig streamConfig;
    private Function<StreamConfig, ShardDetector> customShardDetectorProvider;
    private final long failoverTimeMillis;
    private final long epsilonMillis;
    private final int maxLeasesForWorker;
    private final int maxLeasesToStealAtOneTime;
    private final int maxLeaseRenewalThreads;
    private final boolean cleanupLeasesUponShardCompletion;
    private final boolean ignoreUnexpectedChildShards;
    private final long shardSyncIntervalMillis;
    private final boolean consistentReads;
    private final long listShardsBackoffTimeMillis;
    private final int maxListShardsRetryAttempts;
    private final int maxCacheMissesBeforeReload;
    private final long listShardsCacheAllowedAgeInSeconds;
    private final int cacheMissWarningModulus;
    private final long initialLeaseTableReadCapacity;
    private final long initialLeaseTableWriteCapacity;
    private final TableCreatorCallback tableCreatorCallback;
    private final Duration dynamoDbRequestTimeout;
    private final BillingMode billingMode;
    private final boolean isMultiStreamMode;
    private final LeaseCleanupConfig leaseCleanupConfig;

    @Deprecated
    public DynamoDBLeaseManagementFactory(KinesisAsyncClient kinesisClient, String streamName, DynamoDbAsyncClient dynamoDBClient, String tableName, String workerIdentifier, ExecutorService executorService, InitialPositionInStreamExtended initialPositionInStream, long failoverTimeMillis, long epsilonMillis, int maxLeasesForWorker, int maxLeasesToStealAtOneTime, int maxLeaseRenewalThreads, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncIntervalMillis, boolean consistentReads, long listShardsBackoffTimeMillis, int maxListShardsRetryAttempts, int maxCacheMissesBeforeReload, long listShardsCacheAllowedAgeInSeconds, int cacheMissWarningModulus) {
        this(kinesisClient, streamName, dynamoDBClient, tableName, workerIdentifier, executorService, initialPositionInStream, failoverTimeMillis, epsilonMillis, maxLeasesForWorker, maxLeasesToStealAtOneTime, maxLeaseRenewalThreads, cleanupLeasesUponShardCompletion, ignoreUnexpectedChildShards, shardSyncIntervalMillis, consistentReads, listShardsBackoffTimeMillis, maxListShardsRetryAttempts, maxCacheMissesBeforeReload, listShardsCacheAllowedAgeInSeconds, cacheMissWarningModulus, 10L, 10L);
    }

    @Deprecated
    public DynamoDBLeaseManagementFactory(KinesisAsyncClient kinesisClient, String streamName, DynamoDbAsyncClient dynamoDBClient, String tableName, String workerIdentifier, ExecutorService executorService, InitialPositionInStreamExtended initialPositionInStream, long failoverTimeMillis, long epsilonMillis, int maxLeasesForWorker, int maxLeasesToStealAtOneTime, int maxLeaseRenewalThreads, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncIntervalMillis, boolean consistentReads, long listShardsBackoffTimeMillis, int maxListShardsRetryAttempts, int maxCacheMissesBeforeReload, long listShardsCacheAllowedAgeInSeconds, int cacheMissWarningModulus, long initialLeaseTableReadCapacity, long initialLeaseTableWriteCapacity) {
        this(kinesisClient, streamName, dynamoDBClient, tableName, workerIdentifier, executorService, initialPositionInStream, failoverTimeMillis, epsilonMillis, maxLeasesForWorker, maxLeasesToStealAtOneTime, maxLeaseRenewalThreads, cleanupLeasesUponShardCompletion, ignoreUnexpectedChildShards, shardSyncIntervalMillis, consistentReads, listShardsBackoffTimeMillis, maxListShardsRetryAttempts, maxCacheMissesBeforeReload, listShardsCacheAllowedAgeInSeconds, cacheMissWarningModulus, initialLeaseTableReadCapacity, initialLeaseTableWriteCapacity, new HierarchicalShardSyncer(), TableCreatorCallback.NOOP_TABLE_CREATOR_CALLBACK, LeaseManagementConfig.DEFAULT_REQUEST_TIMEOUT);
    }

    @Deprecated
    public DynamoDBLeaseManagementFactory(KinesisAsyncClient kinesisClient, String streamName, DynamoDbAsyncClient dynamoDBClient, String tableName, String workerIdentifier, ExecutorService executorService, InitialPositionInStreamExtended initialPositionInStream, long failoverTimeMillis, long epsilonMillis, int maxLeasesForWorker, int maxLeasesToStealAtOneTime, int maxLeaseRenewalThreads, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncIntervalMillis, boolean consistentReads, long listShardsBackoffTimeMillis, int maxListShardsRetryAttempts, int maxCacheMissesBeforeReload, long listShardsCacheAllowedAgeInSeconds, int cacheMissWarningModulus, long initialLeaseTableReadCapacity, long initialLeaseTableWriteCapacity, HierarchicalShardSyncer hierarchicalShardSyncer, TableCreatorCallback tableCreatorCallback) {
        this(kinesisClient, streamName, dynamoDBClient, tableName, workerIdentifier, executorService, initialPositionInStream, failoverTimeMillis, epsilonMillis, maxLeasesForWorker, maxLeasesToStealAtOneTime, maxLeaseRenewalThreads, cleanupLeasesUponShardCompletion, ignoreUnexpectedChildShards, shardSyncIntervalMillis, consistentReads, listShardsBackoffTimeMillis, maxListShardsRetryAttempts, maxCacheMissesBeforeReload, listShardsCacheAllowedAgeInSeconds, cacheMissWarningModulus, initialLeaseTableReadCapacity, initialLeaseTableWriteCapacity, hierarchicalShardSyncer, tableCreatorCallback, LeaseManagementConfig.DEFAULT_REQUEST_TIMEOUT);
    }

    @Deprecated
    public DynamoDBLeaseManagementFactory(KinesisAsyncClient kinesisClient, String streamName, DynamoDbAsyncClient dynamoDBClient, String tableName, String workerIdentifier, ExecutorService executorService, InitialPositionInStreamExtended initialPositionInStream, long failoverTimeMillis, long epsilonMillis, int maxLeasesForWorker, int maxLeasesToStealAtOneTime, int maxLeaseRenewalThreads, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncIntervalMillis, boolean consistentReads, long listShardsBackoffTimeMillis, int maxListShardsRetryAttempts, int maxCacheMissesBeforeReload, long listShardsCacheAllowedAgeInSeconds, int cacheMissWarningModulus, long initialLeaseTableReadCapacity, long initialLeaseTableWriteCapacity, HierarchicalShardSyncer hierarchicalShardSyncer, TableCreatorCallback tableCreatorCallback, Duration dynamoDbRequestTimeout) {
        this(kinesisClient, streamName, dynamoDBClient, tableName, workerIdentifier, executorService, initialPositionInStream, failoverTimeMillis, epsilonMillis, maxLeasesForWorker, maxLeasesToStealAtOneTime, maxLeaseRenewalThreads, cleanupLeasesUponShardCompletion, ignoreUnexpectedChildShards, shardSyncIntervalMillis, consistentReads, listShardsBackoffTimeMillis, maxListShardsRetryAttempts, maxCacheMissesBeforeReload, listShardsCacheAllowedAgeInSeconds, cacheMissWarningModulus, initialLeaseTableReadCapacity, initialLeaseTableWriteCapacity, hierarchicalShardSyncer, tableCreatorCallback, dynamoDbRequestTimeout, BillingMode.PROVISIONED);
    }

    @Deprecated
    public DynamoDBLeaseManagementFactory(KinesisAsyncClient kinesisClient, String streamName, DynamoDbAsyncClient dynamoDBClient, String tableName, String workerIdentifier, ExecutorService executorService, InitialPositionInStreamExtended initialPositionInStream, long failoverTimeMillis, long epsilonMillis, int maxLeasesForWorker, int maxLeasesToStealAtOneTime, int maxLeaseRenewalThreads, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncIntervalMillis, boolean consistentReads, long listShardsBackoffTimeMillis, int maxListShardsRetryAttempts, int maxCacheMissesBeforeReload, long listShardsCacheAllowedAgeInSeconds, int cacheMissWarningModulus, long initialLeaseTableReadCapacity, long initialLeaseTableWriteCapacity, HierarchicalShardSyncer hierarchicalShardSyncer, TableCreatorCallback tableCreatorCallback, Duration dynamoDbRequestTimeout, BillingMode billingMode) {
        this(kinesisClient, new StreamConfig(StreamIdentifier.singleStreamInstance(streamName), initialPositionInStream), dynamoDBClient, tableName, workerIdentifier, executorService, failoverTimeMillis, epsilonMillis, maxLeasesForWorker, maxLeasesToStealAtOneTime, maxLeaseRenewalThreads, cleanupLeasesUponShardCompletion, ignoreUnexpectedChildShards, shardSyncIntervalMillis, consistentReads, listShardsBackoffTimeMillis, maxListShardsRetryAttempts, maxCacheMissesBeforeReload, listShardsCacheAllowedAgeInSeconds, cacheMissWarningModulus, initialLeaseTableReadCapacity, initialLeaseTableWriteCapacity, hierarchicalShardSyncer, tableCreatorCallback, dynamoDbRequestTimeout, billingMode, new DynamoDBLeaseSerializer());
    }

    private DynamoDBLeaseManagementFactory(KinesisAsyncClient kinesisClient, StreamConfig streamConfig, DynamoDbAsyncClient dynamoDBClient, String tableName, String workerIdentifier, ExecutorService executorService, long failoverTimeMillis, long epsilonMillis, int maxLeasesForWorker, int maxLeasesToStealAtOneTime, int maxLeaseRenewalThreads, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncIntervalMillis, boolean consistentReads, long listShardsBackoffTimeMillis, int maxListShardsRetryAttempts, int maxCacheMissesBeforeReload, long listShardsCacheAllowedAgeInSeconds, int cacheMissWarningModulus, long initialLeaseTableReadCapacity, long initialLeaseTableWriteCapacity, HierarchicalShardSyncer deprecatedHierarchicalShardSyncer, TableCreatorCallback tableCreatorCallback, Duration dynamoDbRequestTimeout, BillingMode billingMode, LeaseSerializer leaseSerializer) {
        this(kinesisClient, dynamoDBClient, tableName, workerIdentifier, executorService, failoverTimeMillis, epsilonMillis, maxLeasesForWorker, maxLeasesToStealAtOneTime, maxLeaseRenewalThreads, cleanupLeasesUponShardCompletion, ignoreUnexpectedChildShards, shardSyncIntervalMillis, consistentReads, listShardsBackoffTimeMillis, maxListShardsRetryAttempts, maxCacheMissesBeforeReload, listShardsCacheAllowedAgeInSeconds, cacheMissWarningModulus, initialLeaseTableReadCapacity, initialLeaseTableWriteCapacity, deprecatedHierarchicalShardSyncer, tableCreatorCallback, dynamoDbRequestTimeout, billingMode, leaseSerializer, null, false, LeaseManagementConfig.DEFAULT_LEASE_CLEANUP_CONFIG);
        this.streamConfig = streamConfig;
    }

    public DynamoDBLeaseManagementFactory(KinesisAsyncClient kinesisClient, DynamoDbAsyncClient dynamoDBClient, String tableName, String workerIdentifier, ExecutorService executorService, long failoverTimeMillis, long epsilonMillis, int maxLeasesForWorker, int maxLeasesToStealAtOneTime, int maxLeaseRenewalThreads, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncIntervalMillis, boolean consistentReads, long listShardsBackoffTimeMillis, int maxListShardsRetryAttempts, int maxCacheMissesBeforeReload, long listShardsCacheAllowedAgeInSeconds, int cacheMissWarningModulus, long initialLeaseTableReadCapacity, long initialLeaseTableWriteCapacity, HierarchicalShardSyncer deprecatedHierarchicalShardSyncer, TableCreatorCallback tableCreatorCallback, Duration dynamoDbRequestTimeout, BillingMode billingMode, LeaseSerializer leaseSerializer, Function<StreamConfig, ShardDetector> customShardDetectorProvider, boolean isMultiStreamMode, LeaseCleanupConfig leaseCleanupConfig) {
        this.kinesisClient = kinesisClient;
        this.dynamoDBClient = dynamoDBClient;
        this.tableName = tableName;
        this.workerIdentifier = workerIdentifier;
        this.executorService = executorService;
        this.failoverTimeMillis = failoverTimeMillis;
        this.epsilonMillis = epsilonMillis;
        this.maxLeasesForWorker = maxLeasesForWorker;
        this.maxLeasesToStealAtOneTime = maxLeasesToStealAtOneTime;
        this.maxLeaseRenewalThreads = maxLeaseRenewalThreads;
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        this.shardSyncIntervalMillis = shardSyncIntervalMillis;
        this.consistentReads = consistentReads;
        this.listShardsBackoffTimeMillis = listShardsBackoffTimeMillis;
        this.maxListShardsRetryAttempts = maxListShardsRetryAttempts;
        this.maxCacheMissesBeforeReload = maxCacheMissesBeforeReload;
        this.listShardsCacheAllowedAgeInSeconds = listShardsCacheAllowedAgeInSeconds;
        this.cacheMissWarningModulus = cacheMissWarningModulus;
        this.initialLeaseTableReadCapacity = initialLeaseTableReadCapacity;
        this.initialLeaseTableWriteCapacity = initialLeaseTableWriteCapacity;
        this.deprecatedHierarchicalShardSyncer = deprecatedHierarchicalShardSyncer;
        this.tableCreatorCallback = tableCreatorCallback;
        this.dynamoDbRequestTimeout = dynamoDbRequestTimeout;
        this.billingMode = billingMode;
        this.leaseSerializer = leaseSerializer;
        this.customShardDetectorProvider = customShardDetectorProvider;
        this.isMultiStreamMode = isMultiStreamMode;
        this.leaseCleanupConfig = leaseCleanupConfig;
    }

    @Override
    public LeaseCoordinator createLeaseCoordinator(@NonNull MetricsFactory metricsFactory) {
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        return new DynamoDBLeaseCoordinator(this.createLeaseRefresher(), this.workerIdentifier, this.failoverTimeMillis, this.epsilonMillis, this.maxLeasesForWorker, this.maxLeasesToStealAtOneTime, this.maxLeaseRenewalThreads, this.initialLeaseTableReadCapacity, this.initialLeaseTableWriteCapacity, metricsFactory);
    }

    @Override
    @Deprecated
    public ShardSyncTaskManager createShardSyncTaskManager(@NonNull MetricsFactory metricsFactory) {
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        return new ShardSyncTaskManager(this.createShardDetector(), this.createLeaseRefresher(), this.streamConfig.initialPositionInStreamExtended(), this.cleanupLeasesUponShardCompletion, this.ignoreUnexpectedChildShards, this.shardSyncIntervalMillis, this.executorService, this.deprecatedHierarchicalShardSyncer, metricsFactory);
    }

    @Override
    public ShardSyncTaskManager createShardSyncTaskManager(MetricsFactory metricsFactory, StreamConfig streamConfig) {
        return new ShardSyncTaskManager(this.createShardDetector(streamConfig), this.createLeaseRefresher(), streamConfig.initialPositionInStreamExtended(), this.cleanupLeasesUponShardCompletion, this.ignoreUnexpectedChildShards, this.shardSyncIntervalMillis, this.executorService, new HierarchicalShardSyncer(this.isMultiStreamMode, streamConfig.streamIdentifier().toString()), metricsFactory);
    }

    @Override
    public DynamoDBLeaseRefresher createLeaseRefresher() {
        return new DynamoDBLeaseRefresher(this.tableName, this.dynamoDBClient, this.leaseSerializer, this.consistentReads, this.tableCreatorCallback, this.dynamoDbRequestTimeout, this.billingMode);
    }

    @Override
    @Deprecated
    public ShardDetector createShardDetector() {
        return new KinesisShardDetector(this.kinesisClient, this.streamConfig.streamIdentifier(), this.listShardsBackoffTimeMillis, this.maxListShardsRetryAttempts, this.listShardsCacheAllowedAgeInSeconds, this.maxCacheMissesBeforeReload, this.cacheMissWarningModulus, this.dynamoDbRequestTimeout);
    }

    @Override
    public ShardDetector createShardDetector(StreamConfig streamConfig) {
        return this.customShardDetectorProvider != null ? this.customShardDetectorProvider.apply(streamConfig) : new KinesisShardDetector(this.kinesisClient, streamConfig.streamIdentifier(), this.listShardsBackoffTimeMillis, this.maxListShardsRetryAttempts, this.listShardsCacheAllowedAgeInSeconds, this.maxCacheMissesBeforeReload, this.cacheMissWarningModulus, this.dynamoDbRequestTimeout);
    }

    @Override
    public LeaseCleanupManager createLeaseCleanupManager(MetricsFactory metricsFactory) {
        return new LeaseCleanupManager(this.createLeaseCoordinator(metricsFactory), metricsFactory, Executors.newSingleThreadScheduledExecutor(), this.cleanupLeasesUponShardCompletion, this.leaseCleanupConfig.leaseCleanupIntervalMillis(), this.leaseCleanupConfig.completedLeaseCleanupIntervalMillis(), this.leaseCleanupConfig.garbageLeaseCleanupIntervalMillis());
    }

    @NonNull
    public KinesisAsyncClient getKinesisClient() {
        return this.kinesisClient;
    }

    @NonNull
    public DynamoDbAsyncClient getDynamoDBClient() {
        return this.dynamoDBClient;
    }

    @NonNull
    public String getTableName() {
        return this.tableName;
    }

    @NonNull
    public String getWorkerIdentifier() {
        return this.workerIdentifier;
    }

    @NonNull
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @NonNull
    public HierarchicalShardSyncer getDeprecatedHierarchicalShardSyncer() {
        return this.deprecatedHierarchicalShardSyncer;
    }

    @NonNull
    public LeaseSerializer getLeaseSerializer() {
        return this.leaseSerializer;
    }

    @NonNull
    public StreamConfig getStreamConfig() {
        return this.streamConfig;
    }

    public Function<StreamConfig, ShardDetector> getCustomShardDetectorProvider() {
        return this.customShardDetectorProvider;
    }

    public long getFailoverTimeMillis() {
        return this.failoverTimeMillis;
    }

    public long getEpsilonMillis() {
        return this.epsilonMillis;
    }

    public int getMaxLeasesForWorker() {
        return this.maxLeasesForWorker;
    }

    public int getMaxLeasesToStealAtOneTime() {
        return this.maxLeasesToStealAtOneTime;
    }

    public int getMaxLeaseRenewalThreads() {
        return this.maxLeaseRenewalThreads;
    }

    public boolean isCleanupLeasesUponShardCompletion() {
        return this.cleanupLeasesUponShardCompletion;
    }

    public boolean isIgnoreUnexpectedChildShards() {
        return this.ignoreUnexpectedChildShards;
    }

    public long getShardSyncIntervalMillis() {
        return this.shardSyncIntervalMillis;
    }

    public boolean isConsistentReads() {
        return this.consistentReads;
    }

    public long getListShardsBackoffTimeMillis() {
        return this.listShardsBackoffTimeMillis;
    }

    public int getMaxListShardsRetryAttempts() {
        return this.maxListShardsRetryAttempts;
    }

    public int getMaxCacheMissesBeforeReload() {
        return this.maxCacheMissesBeforeReload;
    }

    public long getListShardsCacheAllowedAgeInSeconds() {
        return this.listShardsCacheAllowedAgeInSeconds;
    }

    public int getCacheMissWarningModulus() {
        return this.cacheMissWarningModulus;
    }

    public long getInitialLeaseTableReadCapacity() {
        return this.initialLeaseTableReadCapacity;
    }

    public long getInitialLeaseTableWriteCapacity() {
        return this.initialLeaseTableWriteCapacity;
    }

    public TableCreatorCallback getTableCreatorCallback() {
        return this.tableCreatorCallback;
    }

    public Duration getDynamoDbRequestTimeout() {
        return this.dynamoDbRequestTimeout;
    }

    public BillingMode getBillingMode() {
        return this.billingMode;
    }

    public boolean isMultiStreamMode() {
        return this.isMultiStreamMode;
    }

    public LeaseCleanupConfig getLeaseCleanupConfig() {
        return this.leaseCleanupConfig;
    }

    public void setStreamConfig(@NonNull StreamConfig streamConfig) {
        if (streamConfig == null) {
            throw new NullPointerException("streamConfig");
        }
        this.streamConfig = streamConfig;
    }

    public void setCustomShardDetectorProvider(Function<StreamConfig, ShardDetector> customShardDetectorProvider) {
        this.customShardDetectorProvider = customShardDetectorProvider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamoDBLeaseManagementFactory)) {
            return false;
        }
        DynamoDBLeaseManagementFactory other = (DynamoDBLeaseManagementFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KinesisAsyncClient this$kinesisClient = this.getKinesisClient();
        KinesisAsyncClient other$kinesisClient = other.getKinesisClient();
        if (this$kinesisClient == null ? other$kinesisClient != null : !this$kinesisClient.equals(other$kinesisClient)) {
            return false;
        }
        DynamoDbAsyncClient this$dynamoDBClient = this.getDynamoDBClient();
        DynamoDbAsyncClient other$dynamoDBClient = other.getDynamoDBClient();
        if (this$dynamoDBClient == null ? other$dynamoDBClient != null : !this$dynamoDBClient.equals(other$dynamoDBClient)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$workerIdentifier = this.getWorkerIdentifier();
        String other$workerIdentifier = other.getWorkerIdentifier();
        if (this$workerIdentifier == null ? other$workerIdentifier != null : !this$workerIdentifier.equals(other$workerIdentifier)) {
            return false;
        }
        ExecutorService this$executorService = this.getExecutorService();
        ExecutorService other$executorService = other.getExecutorService();
        if (this$executorService == null ? other$executorService != null : !this$executorService.equals(other$executorService)) {
            return false;
        }
        HierarchicalShardSyncer this$deprecatedHierarchicalShardSyncer = this.getDeprecatedHierarchicalShardSyncer();
        HierarchicalShardSyncer other$deprecatedHierarchicalShardSyncer = other.getDeprecatedHierarchicalShardSyncer();
        if (this$deprecatedHierarchicalShardSyncer == null ? other$deprecatedHierarchicalShardSyncer != null : !this$deprecatedHierarchicalShardSyncer.equals(other$deprecatedHierarchicalShardSyncer)) {
            return false;
        }
        LeaseSerializer this$leaseSerializer = this.getLeaseSerializer();
        LeaseSerializer other$leaseSerializer = other.getLeaseSerializer();
        if (this$leaseSerializer == null ? other$leaseSerializer != null : !this$leaseSerializer.equals(other$leaseSerializer)) {
            return false;
        }
        StreamConfig this$streamConfig = this.getStreamConfig();
        StreamConfig other$streamConfig = other.getStreamConfig();
        if (this$streamConfig == null ? other$streamConfig != null : !((Object)this$streamConfig).equals(other$streamConfig)) {
            return false;
        }
        Function<StreamConfig, ShardDetector> this$customShardDetectorProvider = this.getCustomShardDetectorProvider();
        Function<StreamConfig, ShardDetector> other$customShardDetectorProvider = other.getCustomShardDetectorProvider();
        if (this$customShardDetectorProvider == null ? other$customShardDetectorProvider != null : !this$customShardDetectorProvider.equals(other$customShardDetectorProvider)) {
            return false;
        }
        if (this.getFailoverTimeMillis() != other.getFailoverTimeMillis()) {
            return false;
        }
        if (this.getEpsilonMillis() != other.getEpsilonMillis()) {
            return false;
        }
        if (this.getMaxLeasesForWorker() != other.getMaxLeasesForWorker()) {
            return false;
        }
        if (this.getMaxLeasesToStealAtOneTime() != other.getMaxLeasesToStealAtOneTime()) {
            return false;
        }
        if (this.getMaxLeaseRenewalThreads() != other.getMaxLeaseRenewalThreads()) {
            return false;
        }
        if (this.isCleanupLeasesUponShardCompletion() != other.isCleanupLeasesUponShardCompletion()) {
            return false;
        }
        if (this.isIgnoreUnexpectedChildShards() != other.isIgnoreUnexpectedChildShards()) {
            return false;
        }
        if (this.getShardSyncIntervalMillis() != other.getShardSyncIntervalMillis()) {
            return false;
        }
        if (this.isConsistentReads() != other.isConsistentReads()) {
            return false;
        }
        if (this.getListShardsBackoffTimeMillis() != other.getListShardsBackoffTimeMillis()) {
            return false;
        }
        if (this.getMaxListShardsRetryAttempts() != other.getMaxListShardsRetryAttempts()) {
            return false;
        }
        if (this.getMaxCacheMissesBeforeReload() != other.getMaxCacheMissesBeforeReload()) {
            return false;
        }
        if (this.getListShardsCacheAllowedAgeInSeconds() != other.getListShardsCacheAllowedAgeInSeconds()) {
            return false;
        }
        if (this.getCacheMissWarningModulus() != other.getCacheMissWarningModulus()) {
            return false;
        }
        if (this.getInitialLeaseTableReadCapacity() != other.getInitialLeaseTableReadCapacity()) {
            return false;
        }
        if (this.getInitialLeaseTableWriteCapacity() != other.getInitialLeaseTableWriteCapacity()) {
            return false;
        }
        TableCreatorCallback this$tableCreatorCallback = this.getTableCreatorCallback();
        TableCreatorCallback other$tableCreatorCallback = other.getTableCreatorCallback();
        if (this$tableCreatorCallback == null ? other$tableCreatorCallback != null : !this$tableCreatorCallback.equals(other$tableCreatorCallback)) {
            return false;
        }
        Duration this$dynamoDbRequestTimeout = this.getDynamoDbRequestTimeout();
        Duration other$dynamoDbRequestTimeout = other.getDynamoDbRequestTimeout();
        if (this$dynamoDbRequestTimeout == null ? other$dynamoDbRequestTimeout != null : !((Object)this$dynamoDbRequestTimeout).equals(other$dynamoDbRequestTimeout)) {
            return false;
        }
        BillingMode this$billingMode = this.getBillingMode();
        BillingMode other$billingMode = other.getBillingMode();
        if (this$billingMode == null ? other$billingMode != null : !this$billingMode.equals(other$billingMode)) {
            return false;
        }
        if (this.isMultiStreamMode() != other.isMultiStreamMode()) {
            return false;
        }
        LeaseCleanupConfig this$leaseCleanupConfig = this.getLeaseCleanupConfig();
        LeaseCleanupConfig other$leaseCleanupConfig = other.getLeaseCleanupConfig();
        return !(this$leaseCleanupConfig == null ? other$leaseCleanupConfig != null : !this$leaseCleanupConfig.equals(other$leaseCleanupConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamoDBLeaseManagementFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KinesisAsyncClient $kinesisClient = this.getKinesisClient();
        result = result * 59 + ($kinesisClient == null ? 43 : $kinesisClient.hashCode());
        DynamoDbAsyncClient $dynamoDBClient = this.getDynamoDBClient();
        result = result * 59 + ($dynamoDBClient == null ? 43 : $dynamoDBClient.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $workerIdentifier = this.getWorkerIdentifier();
        result = result * 59 + ($workerIdentifier == null ? 43 : $workerIdentifier.hashCode());
        ExecutorService $executorService = this.getExecutorService();
        result = result * 59 + ($executorService == null ? 43 : $executorService.hashCode());
        HierarchicalShardSyncer $deprecatedHierarchicalShardSyncer = this.getDeprecatedHierarchicalShardSyncer();
        result = result * 59 + ($deprecatedHierarchicalShardSyncer == null ? 43 : $deprecatedHierarchicalShardSyncer.hashCode());
        LeaseSerializer $leaseSerializer = this.getLeaseSerializer();
        result = result * 59 + ($leaseSerializer == null ? 43 : $leaseSerializer.hashCode());
        StreamConfig $streamConfig = this.getStreamConfig();
        result = result * 59 + ($streamConfig == null ? 43 : ((Object)$streamConfig).hashCode());
        Function<StreamConfig, ShardDetector> $customShardDetectorProvider = this.getCustomShardDetectorProvider();
        result = result * 59 + ($customShardDetectorProvider == null ? 43 : $customShardDetectorProvider.hashCode());
        long $failoverTimeMillis = this.getFailoverTimeMillis();
        result = result * 59 + (int)($failoverTimeMillis >>> 32 ^ $failoverTimeMillis);
        long $epsilonMillis = this.getEpsilonMillis();
        result = result * 59 + (int)($epsilonMillis >>> 32 ^ $epsilonMillis);
        result = result * 59 + this.getMaxLeasesForWorker();
        result = result * 59 + this.getMaxLeasesToStealAtOneTime();
        result = result * 59 + this.getMaxLeaseRenewalThreads();
        result = result * 59 + (this.isCleanupLeasesUponShardCompletion() ? 79 : 97);
        result = result * 59 + (this.isIgnoreUnexpectedChildShards() ? 79 : 97);
        long $shardSyncIntervalMillis = this.getShardSyncIntervalMillis();
        result = result * 59 + (int)($shardSyncIntervalMillis >>> 32 ^ $shardSyncIntervalMillis);
        result = result * 59 + (this.isConsistentReads() ? 79 : 97);
        long $listShardsBackoffTimeMillis = this.getListShardsBackoffTimeMillis();
        result = result * 59 + (int)($listShardsBackoffTimeMillis >>> 32 ^ $listShardsBackoffTimeMillis);
        result = result * 59 + this.getMaxListShardsRetryAttempts();
        result = result * 59 + this.getMaxCacheMissesBeforeReload();
        long $listShardsCacheAllowedAgeInSeconds = this.getListShardsCacheAllowedAgeInSeconds();
        result = result * 59 + (int)($listShardsCacheAllowedAgeInSeconds >>> 32 ^ $listShardsCacheAllowedAgeInSeconds);
        result = result * 59 + this.getCacheMissWarningModulus();
        long $initialLeaseTableReadCapacity = this.getInitialLeaseTableReadCapacity();
        result = result * 59 + (int)($initialLeaseTableReadCapacity >>> 32 ^ $initialLeaseTableReadCapacity);
        long $initialLeaseTableWriteCapacity = this.getInitialLeaseTableWriteCapacity();
        result = result * 59 + (int)($initialLeaseTableWriteCapacity >>> 32 ^ $initialLeaseTableWriteCapacity);
        TableCreatorCallback $tableCreatorCallback = this.getTableCreatorCallback();
        result = result * 59 + ($tableCreatorCallback == null ? 43 : $tableCreatorCallback.hashCode());
        Duration $dynamoDbRequestTimeout = this.getDynamoDbRequestTimeout();
        result = result * 59 + ($dynamoDbRequestTimeout == null ? 43 : ((Object)$dynamoDbRequestTimeout).hashCode());
        BillingMode $billingMode = this.getBillingMode();
        result = result * 59 + ($billingMode == null ? 43 : $billingMode.hashCode());
        result = result * 59 + (this.isMultiStreamMode() ? 79 : 97);
        LeaseCleanupConfig $leaseCleanupConfig = this.getLeaseCleanupConfig();
        result = result * 59 + ($leaseCleanupConfig == null ? 43 : $leaseCleanupConfig.hashCode());
        return result;
    }

    public String toString() {
        return "DynamoDBLeaseManagementFactory(kinesisClient=" + this.getKinesisClient() + ", dynamoDBClient=" + this.getDynamoDBClient() + ", tableName=" + this.getTableName() + ", workerIdentifier=" + this.getWorkerIdentifier() + ", executorService=" + this.getExecutorService() + ", deprecatedHierarchicalShardSyncer=" + this.getDeprecatedHierarchicalShardSyncer() + ", leaseSerializer=" + this.getLeaseSerializer() + ", streamConfig=" + this.getStreamConfig() + ", customShardDetectorProvider=" + this.getCustomShardDetectorProvider() + ", failoverTimeMillis=" + this.getFailoverTimeMillis() + ", epsilonMillis=" + this.getEpsilonMillis() + ", maxLeasesForWorker=" + this.getMaxLeasesForWorker() + ", maxLeasesToStealAtOneTime=" + this.getMaxLeasesToStealAtOneTime() + ", maxLeaseRenewalThreads=" + this.getMaxLeaseRenewalThreads() + ", cleanupLeasesUponShardCompletion=" + this.isCleanupLeasesUponShardCompletion() + ", ignoreUnexpectedChildShards=" + this.isIgnoreUnexpectedChildShards() + ", shardSyncIntervalMillis=" + this.getShardSyncIntervalMillis() + ", consistentReads=" + this.isConsistentReads() + ", listShardsBackoffTimeMillis=" + this.getListShardsBackoffTimeMillis() + ", maxListShardsRetryAttempts=" + this.getMaxListShardsRetryAttempts() + ", maxCacheMissesBeforeReload=" + this.getMaxCacheMissesBeforeReload() + ", listShardsCacheAllowedAgeInSeconds=" + this.getListShardsCacheAllowedAgeInSeconds() + ", cacheMissWarningModulus=" + this.getCacheMissWarningModulus() + ", initialLeaseTableReadCapacity=" + this.getInitialLeaseTableReadCapacity() + ", initialLeaseTableWriteCapacity=" + this.getInitialLeaseTableWriteCapacity() + ", tableCreatorCallback=" + this.getTableCreatorCallback() + ", dynamoDbRequestTimeout=" + this.getDynamoDbRequestTimeout() + ", billingMode=" + this.getBillingMode() + ", isMultiStreamMode=" + this.isMultiStreamMode() + ", leaseCleanupConfig=" + this.getLeaseCleanupConfig() + ")";
    }
}

