/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases.dynamodb;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.common.HashKeyRangeForLease;
import software.amazon.kinesis.leases.DynamoUtils;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.LeaseSerializer;
import software.amazon.kinesis.leases.UpdateField;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

@KinesisClientInternalApi
public class DynamoDBLeaseSerializer
implements LeaseSerializer {
    private static final String LEASE_KEY_KEY = "leaseKey";
    private static final String LEASE_OWNER_KEY = "leaseOwner";
    private static final String LEASE_COUNTER_KEY = "leaseCounter";
    private static final String OWNER_SWITCHES_KEY = "ownerSwitchesSinceCheckpoint";
    private static final String CHECKPOINT_SEQUENCE_NUMBER_KEY = "checkpoint";
    private static final String CHECKPOINT_SUBSEQUENCE_NUMBER_KEY = "checkpointSubSequenceNumber";
    private static final String PENDING_CHECKPOINT_SEQUENCE_KEY = "pendingCheckpoint";
    private static final String PENDING_CHECKPOINT_SUBSEQUENCE_KEY = "pendingCheckpointSubSequenceNumber";
    private static final String PENDING_CHECKPOINT_STATE_KEY = "pendingCheckpointState";
    private static final String PARENT_SHARD_ID_KEY = "parentShardId";
    private static final String CHILD_SHARD_IDS_KEY = "childShardIds";
    private static final String STARTING_HASH_KEY = "startingHashKey";
    private static final String ENDING_HASH_KEY = "endingHashKey";

    @Override
    public Map<String, AttributeValue> toDynamoRecord(Lease lease) {
        HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
        result.put(LEASE_KEY_KEY, DynamoUtils.createAttributeValue(lease.leaseKey()));
        result.put(LEASE_COUNTER_KEY, DynamoUtils.createAttributeValue(lease.leaseCounter()));
        if (lease.leaseOwner() != null) {
            result.put(LEASE_OWNER_KEY, DynamoUtils.createAttributeValue(lease.leaseOwner()));
        }
        result.put(OWNER_SWITCHES_KEY, DynamoUtils.createAttributeValue(lease.ownerSwitchesSinceCheckpoint()));
        result.put(CHECKPOINT_SEQUENCE_NUMBER_KEY, DynamoUtils.createAttributeValue(lease.checkpoint().sequenceNumber()));
        result.put(CHECKPOINT_SUBSEQUENCE_NUMBER_KEY, DynamoUtils.createAttributeValue(lease.checkpoint().subSequenceNumber()));
        if (lease.parentShardIds() != null && !lease.parentShardIds().isEmpty()) {
            result.put(PARENT_SHARD_ID_KEY, DynamoUtils.createAttributeValue(lease.parentShardIds()));
        }
        if (!CollectionUtils.isNullOrEmpty(lease.childShardIds())) {
            result.put(CHILD_SHARD_IDS_KEY, DynamoUtils.createAttributeValue(lease.childShardIds()));
        }
        if (lease.pendingCheckpoint() != null && !lease.pendingCheckpoint().sequenceNumber().isEmpty()) {
            result.put(PENDING_CHECKPOINT_SEQUENCE_KEY, DynamoUtils.createAttributeValue(lease.pendingCheckpoint().sequenceNumber()));
            result.put(PENDING_CHECKPOINT_SUBSEQUENCE_KEY, DynamoUtils.createAttributeValue(lease.pendingCheckpoint().subSequenceNumber()));
        }
        if (lease.pendingCheckpointState() != null) {
            result.put(PENDING_CHECKPOINT_STATE_KEY, DynamoUtils.createAttributeValue(lease.checkpoint().subSequenceNumber()));
        }
        if (lease.hashKeyRangeForLease() != null) {
            result.put(STARTING_HASH_KEY, DynamoUtils.createAttributeValue(lease.hashKeyRangeForLease().serializedStartingHashKey()));
            result.put(ENDING_HASH_KEY, DynamoUtils.createAttributeValue(lease.hashKeyRangeForLease().serializedEndingHashKey()));
        }
        return result;
    }

    @Override
    public Lease fromDynamoRecord(Map<String, AttributeValue> dynamoRecord) {
        Lease result = new Lease();
        return this.fromDynamoRecord(dynamoRecord, result);
    }

    @Override
    public Lease fromDynamoRecord(Map<String, AttributeValue> dynamoRecord, Lease leaseToUpdate) {
        String endingHashKey;
        leaseToUpdate.leaseKey(DynamoUtils.safeGetString(dynamoRecord, LEASE_KEY_KEY));
        leaseToUpdate.leaseOwner(DynamoUtils.safeGetString(dynamoRecord, LEASE_OWNER_KEY));
        leaseToUpdate.leaseCounter(DynamoUtils.safeGetLong(dynamoRecord, LEASE_COUNTER_KEY));
        leaseToUpdate.ownerSwitchesSinceCheckpoint(DynamoUtils.safeGetLong(dynamoRecord, OWNER_SWITCHES_KEY));
        leaseToUpdate.checkpoint(new ExtendedSequenceNumber(DynamoUtils.safeGetString(dynamoRecord, CHECKPOINT_SEQUENCE_NUMBER_KEY), DynamoUtils.safeGetLong(dynamoRecord, CHECKPOINT_SUBSEQUENCE_NUMBER_KEY)));
        leaseToUpdate.parentShardIds(DynamoUtils.safeGetSS(dynamoRecord, PARENT_SHARD_ID_KEY));
        leaseToUpdate.childShardIds(DynamoUtils.safeGetSS(dynamoRecord, CHILD_SHARD_IDS_KEY));
        if (!Strings.isNullOrEmpty((String)DynamoUtils.safeGetString(dynamoRecord, PENDING_CHECKPOINT_SEQUENCE_KEY))) {
            leaseToUpdate.pendingCheckpoint(new ExtendedSequenceNumber(DynamoUtils.safeGetString(dynamoRecord, PENDING_CHECKPOINT_SEQUENCE_KEY), DynamoUtils.safeGetLong(dynamoRecord, PENDING_CHECKPOINT_SUBSEQUENCE_KEY)));
        }
        leaseToUpdate.pendingCheckpointState(DynamoUtils.safeGetByteArray(dynamoRecord, PENDING_CHECKPOINT_STATE_KEY));
        String startingHashKey = DynamoUtils.safeGetString(dynamoRecord, STARTING_HASH_KEY);
        if (!Strings.isNullOrEmpty((String)startingHashKey) && !Strings.isNullOrEmpty((String)(endingHashKey = DynamoUtils.safeGetString(dynamoRecord, ENDING_HASH_KEY)))) {
            leaseToUpdate.hashKeyRange(HashKeyRangeForLease.deserialize(startingHashKey, endingHashKey));
        }
        return leaseToUpdate;
    }

    @Override
    public Map<String, AttributeValue> getDynamoHashKey(String leaseKey) {
        HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
        result.put(LEASE_KEY_KEY, DynamoUtils.createAttributeValue(leaseKey));
        return result;
    }

    @Override
    public Map<String, AttributeValue> getDynamoHashKey(Lease lease) {
        return this.getDynamoHashKey(lease.leaseKey());
    }

    @Override
    public Map<String, ExpectedAttributeValue> getDynamoLeaseCounterExpectation(Lease lease) {
        return this.getDynamoLeaseCounterExpectation(lease.leaseCounter());
    }

    public Map<String, ExpectedAttributeValue> getDynamoLeaseCounterExpectation(Long leaseCounter) {
        HashMap<String, ExpectedAttributeValue> result = new HashMap<String, ExpectedAttributeValue>();
        ExpectedAttributeValue eav = (ExpectedAttributeValue)ExpectedAttributeValue.builder().value(DynamoUtils.createAttributeValue(leaseCounter)).build();
        result.put(LEASE_COUNTER_KEY, eav);
        return result;
    }

    @Override
    public Map<String, ExpectedAttributeValue> getDynamoLeaseOwnerExpectation(Lease lease) {
        HashMap<String, ExpectedAttributeValue> result = new HashMap<String, ExpectedAttributeValue>();
        ExpectedAttributeValue.Builder eavBuilder = ExpectedAttributeValue.builder();
        eavBuilder = lease.leaseOwner() == null ? eavBuilder.exists(Boolean.valueOf(false)) : eavBuilder.value(DynamoUtils.createAttributeValue(lease.leaseOwner()));
        result.put(LEASE_OWNER_KEY, (ExpectedAttributeValue)eavBuilder.build());
        return result;
    }

    @Override
    public Map<String, ExpectedAttributeValue> getDynamoNonexistantExpectation() {
        HashMap<String, ExpectedAttributeValue> result = new HashMap<String, ExpectedAttributeValue>();
        ExpectedAttributeValue expectedAV = (ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(Boolean.valueOf(false)).build();
        result.put(LEASE_KEY_KEY, expectedAV);
        return result;
    }

    @Override
    public Map<String, ExpectedAttributeValue> getDynamoExistentExpectation(String leaseKey) {
        HashMap<String, ExpectedAttributeValue> result = new HashMap<String, ExpectedAttributeValue>();
        ExpectedAttributeValue expectedAV = (ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(Boolean.valueOf(true)).value(DynamoUtils.createAttributeValue(leaseKey)).build();
        result.put(LEASE_KEY_KEY, expectedAV);
        return result;
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoLeaseCounterUpdate(Lease lease) {
        return this.getDynamoLeaseCounterUpdate(lease.leaseCounter());
    }

    public Map<String, AttributeValueUpdate> getDynamoLeaseCounterUpdate(Long leaseCounter) {
        HashMap<String, AttributeValueUpdate> result = new HashMap<String, AttributeValueUpdate>();
        AttributeValueUpdate avu = (AttributeValueUpdate)AttributeValueUpdate.builder().value(DynamoUtils.createAttributeValue(leaseCounter + 1L)).action(AttributeAction.PUT).build();
        result.put(LEASE_COUNTER_KEY, avu);
        return result;
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoTakeLeaseUpdate(Lease lease, String owner) {
        HashMap<String, AttributeValueUpdate> result = new HashMap<String, AttributeValueUpdate>();
        result.put(LEASE_OWNER_KEY, (AttributeValueUpdate)AttributeValueUpdate.builder().value(DynamoUtils.createAttributeValue(owner)).action(AttributeAction.PUT).build());
        String oldOwner = lease.leaseOwner();
        if (oldOwner != null && !oldOwner.equals(owner)) {
            result.put(OWNER_SWITCHES_KEY, (AttributeValueUpdate)AttributeValueUpdate.builder().value(DynamoUtils.createAttributeValue(1L)).action(AttributeAction.ADD).build());
        }
        return result;
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoEvictLeaseUpdate(Lease lease) {
        HashMap<String, AttributeValueUpdate> result = new HashMap<String, AttributeValueUpdate>();
        AttributeValue value = null;
        result.put(LEASE_OWNER_KEY, (AttributeValueUpdate)AttributeValueUpdate.builder().value(value).action(AttributeAction.DELETE).build());
        return result;
    }

    protected AttributeValueUpdate putUpdate(AttributeValue attributeValue) {
        return (AttributeValueUpdate)AttributeValueUpdate.builder().value(attributeValue).action(AttributeAction.PUT).build();
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoUpdateLeaseUpdate(Lease lease) {
        HashMap<String, AttributeValueUpdate> result = new HashMap<String, AttributeValueUpdate>();
        result.put(CHECKPOINT_SEQUENCE_NUMBER_KEY, this.putUpdate(DynamoUtils.createAttributeValue(lease.checkpoint().sequenceNumber())));
        result.put(CHECKPOINT_SUBSEQUENCE_NUMBER_KEY, this.putUpdate(DynamoUtils.createAttributeValue(lease.checkpoint().subSequenceNumber())));
        result.put(OWNER_SWITCHES_KEY, this.putUpdate(DynamoUtils.createAttributeValue(lease.ownerSwitchesSinceCheckpoint())));
        if (lease.pendingCheckpoint() != null && !lease.pendingCheckpoint().sequenceNumber().isEmpty()) {
            result.put(PENDING_CHECKPOINT_SEQUENCE_KEY, this.putUpdate(DynamoUtils.createAttributeValue(lease.pendingCheckpoint().sequenceNumber())));
            result.put(PENDING_CHECKPOINT_SUBSEQUENCE_KEY, this.putUpdate(DynamoUtils.createAttributeValue(lease.pendingCheckpoint().subSequenceNumber())));
        } else {
            result.put(PENDING_CHECKPOINT_SEQUENCE_KEY, (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.DELETE).build());
            result.put(PENDING_CHECKPOINT_SUBSEQUENCE_KEY, (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.DELETE).build());
        }
        if (lease.pendingCheckpointState() != null) {
            result.put(PENDING_CHECKPOINT_STATE_KEY, this.putUpdate(DynamoUtils.createAttributeValue(lease.pendingCheckpointState())));
        } else {
            result.put(PENDING_CHECKPOINT_STATE_KEY, (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.DELETE).build());
        }
        if (!CollectionUtils.isNullOrEmpty(lease.childShardIds())) {
            result.put(CHILD_SHARD_IDS_KEY, this.putUpdate(DynamoUtils.createAttributeValue(lease.childShardIds())));
        }
        if (lease.hashKeyRangeForLease() != null) {
            result.put(STARTING_HASH_KEY, this.putUpdate(DynamoUtils.createAttributeValue(lease.hashKeyRangeForLease().serializedStartingHashKey())));
            result.put(ENDING_HASH_KEY, this.putUpdate(DynamoUtils.createAttributeValue(lease.hashKeyRangeForLease().serializedEndingHashKey())));
        }
        return result;
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoUpdateLeaseUpdate(Lease lease, UpdateField updateField) {
        HashMap<String, AttributeValueUpdate> result = new HashMap<String, AttributeValueUpdate>();
        switch (updateField) {
            case CHILD_SHARDS: {
                if (CollectionUtils.isNullOrEmpty(lease.childShardIds())) break;
                result.put(CHILD_SHARD_IDS_KEY, this.putUpdate(DynamoUtils.createAttributeValue(lease.childShardIds())));
                break;
            }
            case HASH_KEY_RANGE: {
                if (lease.hashKeyRangeForLease() == null) break;
                result.put(STARTING_HASH_KEY, this.putUpdate(DynamoUtils.createAttributeValue(lease.hashKeyRangeForLease().serializedStartingHashKey())));
                result.put(ENDING_HASH_KEY, this.putUpdate(DynamoUtils.createAttributeValue(lease.hashKeyRangeForLease().serializedEndingHashKey())));
            }
        }
        return result;
    }

    @Override
    public Collection<KeySchemaElement> getKeySchema() {
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        keySchema.add((KeySchemaElement)KeySchemaElement.builder().attributeName(LEASE_KEY_KEY).keyType(KeyType.HASH).build());
        return keySchema;
    }

    @Override
    public Collection<AttributeDefinition> getAttributeDefinitions() {
        ArrayList<AttributeDefinition> definitions = new ArrayList<AttributeDefinition>();
        definitions.add((AttributeDefinition)AttributeDefinition.builder().attributeName(LEASE_KEY_KEY).attributeType(ScalarAttributeType.S).build());
        return definitions;
    }
}

