/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.metrics;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.cloudwatch.model.StatisticSet;
import software.amazon.kinesis.metrics.EndingMetricsScope;
import software.amazon.kinesis.metrics.MetricsLevel;

public abstract class AccumulatingMetricsScope<KeyType>
extends EndingMetricsScope {
    protected Map<KeyType, MetricDatum> data = new HashMap<KeyType, MetricDatum>();

    @Override
    public void addData(String name, double value, StandardUnit unit) {
        this.addData(this.getKey(name), name, value, unit);
    }

    @Override
    public void addData(String name, double value, StandardUnit unit, MetricsLevel level) {
        this.addData(this.getKey(name), name, value, unit);
    }

    protected abstract KeyType getKey(String var1);

    public void addData(KeyType key, String name, double value, StandardUnit unit) {
        MetricDatum metricDatum;
        super.addData(name, value, unit);
        MetricDatum datum = this.data.get(key);
        if (datum == null) {
            metricDatum = (MetricDatum)MetricDatum.builder().metricName(name).unit(unit).statisticValues((StatisticSet)StatisticSet.builder().maximum(Double.valueOf(value)).minimum(Double.valueOf(value)).sampleCount(Double.valueOf(1.0)).sum(Double.valueOf(value)).build()).build();
        } else {
            if (!datum.unit().equals((Object)unit)) {
                throw new IllegalArgumentException("Cannot add to existing metric with different unit");
            }
            StatisticSet oldStatisticSet = datum.statisticValues();
            StatisticSet statisticSet = (StatisticSet)oldStatisticSet.toBuilder().maximum(Double.valueOf(Math.max(value, oldStatisticSet.maximum()))).minimum(Double.valueOf(Math.min(value, oldStatisticSet.minimum()))).sampleCount(Double.valueOf(oldStatisticSet.sampleCount() + 1.0)).sum(Double.valueOf(oldStatisticSet.sum() + value)).build();
            metricDatum = (MetricDatum)datum.toBuilder().statisticValues(statisticSet).build();
        }
        this.data.put(key, metricDatum);
    }
}

