/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.metrics;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.kinesis.metrics.CloudWatchMetricsFactory;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.MetricsLevel;

public class MetricsConfig {
    public static final Set<String> METRICS_ALWAYS_ENABLED_DIMENSIONS = ImmutableSet.of((Object)"Operation");
    public static final Set<String> METRICS_ALWAYS_ENABLED_DIMENSIONS_WITH_SHARD_ID = ImmutableSet.builder().addAll(METRICS_ALWAYS_ENABLED_DIMENSIONS).add((Object)"ShardId").build();
    public static final Set<String> METRICS_DIMENSIONS_ALL = ImmutableSet.of((Object)"ALL");
    private final CloudWatchAsyncClient cloudWatchClient;
    private final String namespace;
    private long metricsBufferTimeMillis = 10000L;
    private int metricsMaxQueueSize = 10000;
    private MetricsLevel metricsLevel = MetricsLevel.DETAILED;
    private Set<String> metricsEnabledDimensions = METRICS_DIMENSIONS_ALL;
    private int publisherFlushBuffer = 200;
    private MetricsFactory metricsFactory;

    public MetricsFactory metricsFactory() {
        if (this.metricsFactory == null) {
            this.metricsFactory = new CloudWatchMetricsFactory(this.cloudWatchClient(), this.namespace(), this.metricsBufferTimeMillis(), this.metricsMaxQueueSize(), this.metricsLevel(), this.metricsEnabledDimensions(), this.publisherFlushBuffer());
        }
        return this.metricsFactory;
    }

    public MetricsConfig(CloudWatchAsyncClient cloudWatchClient, String namespace) {
        this.cloudWatchClient = cloudWatchClient;
        this.namespace = namespace;
    }

    public CloudWatchAsyncClient cloudWatchClient() {
        return this.cloudWatchClient;
    }

    public String namespace() {
        return this.namespace;
    }

    public long metricsBufferTimeMillis() {
        return this.metricsBufferTimeMillis;
    }

    public int metricsMaxQueueSize() {
        return this.metricsMaxQueueSize;
    }

    public MetricsLevel metricsLevel() {
        return this.metricsLevel;
    }

    public Set<String> metricsEnabledDimensions() {
        return this.metricsEnabledDimensions;
    }

    public int publisherFlushBuffer() {
        return this.publisherFlushBuffer;
    }

    public MetricsConfig metricsBufferTimeMillis(long metricsBufferTimeMillis) {
        this.metricsBufferTimeMillis = metricsBufferTimeMillis;
        return this;
    }

    public MetricsConfig metricsMaxQueueSize(int metricsMaxQueueSize) {
        this.metricsMaxQueueSize = metricsMaxQueueSize;
        return this;
    }

    public MetricsConfig metricsLevel(MetricsLevel metricsLevel) {
        this.metricsLevel = metricsLevel;
        return this;
    }

    public MetricsConfig metricsEnabledDimensions(Set<String> metricsEnabledDimensions) {
        this.metricsEnabledDimensions = metricsEnabledDimensions;
        return this;
    }

    public MetricsConfig publisherFlushBuffer(int publisherFlushBuffer) {
        this.publisherFlushBuffer = publisherFlushBuffer;
        return this;
    }

    public MetricsConfig metricsFactory(MetricsFactory metricsFactory) {
        this.metricsFactory = metricsFactory;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsConfig)) {
            return false;
        }
        MetricsConfig other = (MetricsConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CloudWatchAsyncClient this$cloudWatchClient = this.cloudWatchClient();
        CloudWatchAsyncClient other$cloudWatchClient = other.cloudWatchClient();
        if (this$cloudWatchClient == null ? other$cloudWatchClient != null : !this$cloudWatchClient.equals(other$cloudWatchClient)) {
            return false;
        }
        String this$namespace = this.namespace();
        String other$namespace = other.namespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        if (this.metricsBufferTimeMillis() != other.metricsBufferTimeMillis()) {
            return false;
        }
        if (this.metricsMaxQueueSize() != other.metricsMaxQueueSize()) {
            return false;
        }
        MetricsLevel this$metricsLevel = this.metricsLevel();
        MetricsLevel other$metricsLevel = other.metricsLevel();
        if (this$metricsLevel == null ? other$metricsLevel != null : !((Object)((Object)this$metricsLevel)).equals((Object)other$metricsLevel)) {
            return false;
        }
        Set<String> this$metricsEnabledDimensions = this.metricsEnabledDimensions();
        Set<String> other$metricsEnabledDimensions = other.metricsEnabledDimensions();
        if (this$metricsEnabledDimensions == null ? other$metricsEnabledDimensions != null : !((Object)this$metricsEnabledDimensions).equals(other$metricsEnabledDimensions)) {
            return false;
        }
        if (this.publisherFlushBuffer() != other.publisherFlushBuffer()) {
            return false;
        }
        MetricsFactory this$metricsFactory = this.metricsFactory();
        MetricsFactory other$metricsFactory = other.metricsFactory();
        return !(this$metricsFactory == null ? other$metricsFactory != null : !this$metricsFactory.equals(other$metricsFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetricsConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CloudWatchAsyncClient $cloudWatchClient = this.cloudWatchClient();
        result = result * 59 + ($cloudWatchClient == null ? 43 : $cloudWatchClient.hashCode());
        String $namespace = this.namespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        long $metricsBufferTimeMillis = this.metricsBufferTimeMillis();
        result = result * 59 + (int)($metricsBufferTimeMillis >>> 32 ^ $metricsBufferTimeMillis);
        result = result * 59 + this.metricsMaxQueueSize();
        MetricsLevel $metricsLevel = this.metricsLevel();
        result = result * 59 + ($metricsLevel == null ? 43 : ((Object)((Object)$metricsLevel)).hashCode());
        Set<String> $metricsEnabledDimensions = this.metricsEnabledDimensions();
        result = result * 59 + ($metricsEnabledDimensions == null ? 43 : ((Object)$metricsEnabledDimensions).hashCode());
        result = result * 59 + this.publisherFlushBuffer();
        MetricsFactory $metricsFactory = this.metricsFactory();
        result = result * 59 + ($metricsFactory == null ? 43 : $metricsFactory.hashCode());
        return result;
    }

    public String toString() {
        return "MetricsConfig(cloudWatchClient=" + this.cloudWatchClient() + ", namespace=" + this.namespace() + ", metricsBufferTimeMillis=" + this.metricsBufferTimeMillis() + ", metricsMaxQueueSize=" + this.metricsMaxQueueSize() + ", metricsLevel=" + (Object)((Object)this.metricsLevel()) + ", metricsEnabledDimensions=" + this.metricsEnabledDimensions() + ", publisherFlushBuffer=" + this.publisherFlushBuffer() + ", metricsFactory=" + this.metricsFactory() + ")";
    }
}

