/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.checkpoint;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SequenceNumberValidator {
    private static final List<SequenceNumberReader> SEQUENCE_NUMBER_READERS = Collections.singletonList(new V2SequenceNumberReader());

    private Optional<SequenceNumberComponents> retrieveComponentsFor(String sequenceNumber) {
        return SEQUENCE_NUMBER_READERS.stream().map(r -> r.read(sequenceNumber)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Optional<Integer> versionFor(String sequenceNumber) {
        return this.retrieveComponentsFor(sequenceNumber).map(SequenceNumberComponents::version);
    }

    public Optional<String> shardIdFor(String sequenceNumber) {
        return this.retrieveComponentsFor(sequenceNumber).map(s -> String.format("shardId-%012d", s.shardId()));
    }

    public Optional<Boolean> validateSequenceNumberForShard(String sequenceNumber, String shardId) {
        return this.shardIdFor(sequenceNumber).map(s -> StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)shardId));
    }

    private static class V2SequenceNumberReader
    implements SequenceNumberReader {
        private static final int VERSION = 2;
        private static final int EXPECTED_BIT_LENGTH = 186;
        private static final int VERSION_OFFSET = 184;
        private static final long VERSION_MASK = 15L;
        private static final int SHARD_ID_OFFSET = 4;
        private static final long SHARD_ID_MASK = 0xFFFFFFFFL;

        private V2SequenceNumberReader() {
        }

        @Override
        public Optional<SequenceNumberComponents> read(String sequenceNumberString) {
            BigInteger sequenceNumber = new BigInteger(sequenceNumberString, 10);
            if (sequenceNumber.bitLength() != 186) {
                return Optional.empty();
            }
            int version = this.readOffset(sequenceNumber, 184, 15L);
            if (version != 2) {
                return Optional.empty();
            }
            int shardId = this.readOffset(sequenceNumber, 4, 0xFFFFFFFFL);
            return Optional.of(new SequenceNumberComponents(version, shardId));
        }

        private int readOffset(BigInteger sequenceNumber, int offset, long mask) {
            long value = sequenceNumber.shiftRight(offset).longValue() & mask;
            return (int)value;
        }
    }

    private static interface SequenceNumberReader {
        public Optional<SequenceNumberComponents> read(String var1);
    }

    private static class SequenceNumberComponents {
        final int version;
        final int shardId;

        public SequenceNumberComponents(int version, int shardId) {
            this.version = version;
            this.shardId = shardId;
        }

        public int version() {
            return this.version;
        }

        public int shardId() {
            return this.shardId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SequenceNumberComponents)) {
                return false;
            }
            SequenceNumberComponents other = (SequenceNumberComponents)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.version() != other.version()) {
                return false;
            }
            return this.shardId() == other.shardId();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SequenceNumberComponents;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.version();
            result = result * 59 + this.shardId();
            return result;
        }

        public String toString() {
            return "SequenceNumberValidator.SequenceNumberComponents(version=" + this.version() + ", shardId=" + this.shardId() + ")";
        }
    }
}

