/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.common;

import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.utils.Either;
import software.amazon.kinesis.checkpoint.CheckpointConfig;
import software.amazon.kinesis.coordinator.CoordinatorConfig;
import software.amazon.kinesis.leases.LeaseManagementConfig;
import software.amazon.kinesis.lifecycle.LifecycleConfig;
import software.amazon.kinesis.metrics.MetricsConfig;
import software.amazon.kinesis.processor.MultiStreamTracker;
import software.amazon.kinesis.processor.ProcessorConfig;
import software.amazon.kinesis.processor.ShardRecordProcessorFactory;
import software.amazon.kinesis.retrieval.RetrievalConfig;

public class ConfigsBuilder {
    private Either<MultiStreamTracker, String> appStreamTracker;
    @NonNull
    private final String applicationName;
    @NonNull
    private final KinesisAsyncClient kinesisClient;
    @NonNull
    private final DynamoDbAsyncClient dynamoDBClient;
    @NonNull
    private final CloudWatchAsyncClient cloudWatchClient;
    @NonNull
    private final String workerIdentifier;
    @NonNull
    private final ShardRecordProcessorFactory shardRecordProcessorFactory;
    private String tableName;
    private String namespace;

    public String tableName() {
        if (StringUtils.isEmpty((CharSequence)this.tableName)) {
            this.tableName = this.applicationName();
        }
        return this.tableName;
    }

    public String namespace() {
        if (StringUtils.isEmpty((CharSequence)this.namespace)) {
            this.namespace = this.applicationName();
        }
        return this.namespace;
    }

    public ConfigsBuilder(@NonNull String streamName, @NonNull String applicationName, @NonNull KinesisAsyncClient kinesisClient, @NonNull DynamoDbAsyncClient dynamoDBClient, @NonNull CloudWatchAsyncClient cloudWatchClient, @NonNull String workerIdentifier, @NonNull ShardRecordProcessorFactory shardRecordProcessorFactory) {
        if (streamName == null) {
            throw new NullPointerException("streamName");
        }
        if (applicationName == null) {
            throw new NullPointerException("applicationName");
        }
        if (kinesisClient == null) {
            throw new NullPointerException("kinesisClient");
        }
        if (dynamoDBClient == null) {
            throw new NullPointerException("dynamoDBClient");
        }
        if (cloudWatchClient == null) {
            throw new NullPointerException("cloudWatchClient");
        }
        if (workerIdentifier == null) {
            throw new NullPointerException("workerIdentifier");
        }
        if (shardRecordProcessorFactory == null) {
            throw new NullPointerException("shardRecordProcessorFactory");
        }
        this.appStreamTracker = Either.right((Object)streamName);
        this.applicationName = applicationName;
        this.kinesisClient = kinesisClient;
        this.dynamoDBClient = dynamoDBClient;
        this.cloudWatchClient = cloudWatchClient;
        this.workerIdentifier = workerIdentifier;
        this.shardRecordProcessorFactory = shardRecordProcessorFactory;
    }

    public ConfigsBuilder(@NonNull MultiStreamTracker multiStreamTracker, @NonNull String applicationName, @NonNull KinesisAsyncClient kinesisClient, @NonNull DynamoDbAsyncClient dynamoDBClient, @NonNull CloudWatchAsyncClient cloudWatchClient, @NonNull String workerIdentifier, @NonNull ShardRecordProcessorFactory shardRecordProcessorFactory) {
        if (multiStreamTracker == null) {
            throw new NullPointerException("multiStreamTracker");
        }
        if (applicationName == null) {
            throw new NullPointerException("applicationName");
        }
        if (kinesisClient == null) {
            throw new NullPointerException("kinesisClient");
        }
        if (dynamoDBClient == null) {
            throw new NullPointerException("dynamoDBClient");
        }
        if (cloudWatchClient == null) {
            throw new NullPointerException("cloudWatchClient");
        }
        if (workerIdentifier == null) {
            throw new NullPointerException("workerIdentifier");
        }
        if (shardRecordProcessorFactory == null) {
            throw new NullPointerException("shardRecordProcessorFactory");
        }
        this.appStreamTracker = Either.left((Object)multiStreamTracker);
        this.applicationName = applicationName;
        this.kinesisClient = kinesisClient;
        this.dynamoDBClient = dynamoDBClient;
        this.cloudWatchClient = cloudWatchClient;
        this.workerIdentifier = workerIdentifier;
        this.shardRecordProcessorFactory = shardRecordProcessorFactory;
    }

    public CheckpointConfig checkpointConfig() {
        return new CheckpointConfig();
    }

    public CoordinatorConfig coordinatorConfig() {
        return new CoordinatorConfig(this.applicationName());
    }

    public LeaseManagementConfig leaseManagementConfig() {
        return new LeaseManagementConfig(this.tableName(), this.dynamoDBClient(), this.kinesisClient(), this.workerIdentifier());
    }

    public LifecycleConfig lifecycleConfig() {
        return new LifecycleConfig();
    }

    public MetricsConfig metricsConfig() {
        return new MetricsConfig(this.cloudWatchClient(), this.namespace());
    }

    public ProcessorConfig processorConfig() {
        return new ProcessorConfig(this.shardRecordProcessorFactory());
    }

    public RetrievalConfig retrievalConfig() {
        RetrievalConfig retrievalConfig = (RetrievalConfig)this.appStreamTracker.map(multiStreamTracker -> new RetrievalConfig(this.kinesisClient(), (MultiStreamTracker)multiStreamTracker, this.applicationName()), streamName -> new RetrievalConfig(this.kinesisClient(), (String)streamName, this.applicationName()));
        return retrievalConfig;
    }

    public Either<MultiStreamTracker, String> appStreamTracker() {
        return this.appStreamTracker;
    }

    @NonNull
    public String applicationName() {
        return this.applicationName;
    }

    @NonNull
    public KinesisAsyncClient kinesisClient() {
        return this.kinesisClient;
    }

    @NonNull
    public DynamoDbAsyncClient dynamoDBClient() {
        return this.dynamoDBClient;
    }

    @NonNull
    public CloudWatchAsyncClient cloudWatchClient() {
        return this.cloudWatchClient;
    }

    @NonNull
    public String workerIdentifier() {
        return this.workerIdentifier;
    }

    @NonNull
    public ShardRecordProcessorFactory shardRecordProcessorFactory() {
        return this.shardRecordProcessorFactory;
    }

    public ConfigsBuilder appStreamTracker(Either<MultiStreamTracker, String> appStreamTracker) {
        this.appStreamTracker = appStreamTracker;
        return this;
    }

    public ConfigsBuilder tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public ConfigsBuilder namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String toString() {
        return "ConfigsBuilder(appStreamTracker=" + this.appStreamTracker() + ", applicationName=" + this.applicationName() + ", kinesisClient=" + this.kinesisClient() + ", dynamoDBClient=" + this.dynamoDBClient() + ", cloudWatchClient=" + this.cloudWatchClient() + ", workerIdentifier=" + this.workerIdentifier() + ", shardRecordProcessorFactory=" + this.shardRecordProcessorFactory() + ", tableName=" + this.tableName() + ", namespace=" + this.namespace() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigsBuilder)) {
            return false;
        }
        ConfigsBuilder other = (ConfigsBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Either<MultiStreamTracker, String> this$appStreamTracker = this.appStreamTracker();
        Either<MultiStreamTracker, String> other$appStreamTracker = other.appStreamTracker();
        if (this$appStreamTracker == null ? other$appStreamTracker != null : !this$appStreamTracker.equals(other$appStreamTracker)) {
            return false;
        }
        String this$applicationName = this.applicationName();
        String other$applicationName = other.applicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        KinesisAsyncClient this$kinesisClient = this.kinesisClient();
        KinesisAsyncClient other$kinesisClient = other.kinesisClient();
        if (this$kinesisClient == null ? other$kinesisClient != null : !this$kinesisClient.equals(other$kinesisClient)) {
            return false;
        }
        DynamoDbAsyncClient this$dynamoDBClient = this.dynamoDBClient();
        DynamoDbAsyncClient other$dynamoDBClient = other.dynamoDBClient();
        if (this$dynamoDBClient == null ? other$dynamoDBClient != null : !this$dynamoDBClient.equals(other$dynamoDBClient)) {
            return false;
        }
        CloudWatchAsyncClient this$cloudWatchClient = this.cloudWatchClient();
        CloudWatchAsyncClient other$cloudWatchClient = other.cloudWatchClient();
        if (this$cloudWatchClient == null ? other$cloudWatchClient != null : !this$cloudWatchClient.equals(other$cloudWatchClient)) {
            return false;
        }
        String this$workerIdentifier = this.workerIdentifier();
        String other$workerIdentifier = other.workerIdentifier();
        if (this$workerIdentifier == null ? other$workerIdentifier != null : !this$workerIdentifier.equals(other$workerIdentifier)) {
            return false;
        }
        ShardRecordProcessorFactory this$shardRecordProcessorFactory = this.shardRecordProcessorFactory();
        ShardRecordProcessorFactory other$shardRecordProcessorFactory = other.shardRecordProcessorFactory();
        if (this$shardRecordProcessorFactory == null ? other$shardRecordProcessorFactory != null : !this$shardRecordProcessorFactory.equals(other$shardRecordProcessorFactory)) {
            return false;
        }
        String this$tableName = this.tableName();
        String other$tableName = other.tableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$namespace = this.namespace();
        String other$namespace = other.namespace();
        return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigsBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Either<MultiStreamTracker, String> $appStreamTracker = this.appStreamTracker();
        result = result * 59 + ($appStreamTracker == null ? 43 : $appStreamTracker.hashCode());
        String $applicationName = this.applicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        KinesisAsyncClient $kinesisClient = this.kinesisClient();
        result = result * 59 + ($kinesisClient == null ? 43 : $kinesisClient.hashCode());
        DynamoDbAsyncClient $dynamoDBClient = this.dynamoDBClient();
        result = result * 59 + ($dynamoDBClient == null ? 43 : $dynamoDBClient.hashCode());
        CloudWatchAsyncClient $cloudWatchClient = this.cloudWatchClient();
        result = result * 59 + ($cloudWatchClient == null ? 43 : $cloudWatchClient.hashCode());
        String $workerIdentifier = this.workerIdentifier();
        result = result * 59 + ($workerIdentifier == null ? 43 : $workerIdentifier.hashCode());
        ShardRecordProcessorFactory $shardRecordProcessorFactory = this.shardRecordProcessorFactory();
        result = result * 59 + ($shardRecordProcessorFactory == null ? 43 : $shardRecordProcessorFactory.hashCode());
        String $tableName = this.tableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $namespace = this.namespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        return result;
    }
}

