/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.common;

import java.util.Date;
import software.amazon.kinesis.common.InitialPositionInStream;

public class InitialPositionInStreamExtended {
    private final InitialPositionInStream position;
    private final Date timestamp;

    private InitialPositionInStreamExtended(InitialPositionInStream position, Date timestamp) {
        this.position = position;
        this.timestamp = timestamp;
    }

    public InitialPositionInStream getInitialPositionInStream() {
        return this.position;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public static InitialPositionInStreamExtended newInitialPosition(InitialPositionInStream position) {
        switch (position) {
            case LATEST: {
                return new InitialPositionInStreamExtended(InitialPositionInStream.LATEST, null);
            }
            case TRIM_HORIZON: {
                return new InitialPositionInStreamExtended(InitialPositionInStream.TRIM_HORIZON, null);
            }
        }
        throw new IllegalArgumentException("Invalid InitialPosition: " + (Object)((Object)position));
    }

    public static InitialPositionInStreamExtended newInitialPositionAtTimestamp(Date timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException("Timestamp must be specified for InitialPosition AT_TIMESTAMP");
        }
        return new InitialPositionInStreamExtended(InitialPositionInStream.AT_TIMESTAMP, timestamp);
    }

    public String toString() {
        return "InitialPositionInStreamExtended(position=" + (Object)((Object)this.position) + ", timestamp=" + this.getTimestamp() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InitialPositionInStreamExtended)) {
            return false;
        }
        InitialPositionInStreamExtended other = (InitialPositionInStreamExtended)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InitialPositionInStream this$position = this.position;
        InitialPositionInStream other$position = other.position;
        if (this$position == null ? other$position != null : !((Object)((Object)this$position)).equals((Object)other$position)) {
            return false;
        }
        Date this$timestamp = this.getTimestamp();
        Date other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InitialPositionInStreamExtended;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InitialPositionInStream $position = this.position;
        result = result * 59 + ($position == null ? 43 : ((Object)((Object)$position)).hashCode());
        Date $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }
}

