/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.coordinator;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.coordinator.DiagnosticEvent;
import software.amazon.kinesis.coordinator.DiagnosticEventHandler;
import software.amazon.kinesis.leases.LeaseCoordinator;

@KinesisClientInternalApi
public class ExecutorStateEvent
implements DiagnosticEvent {
    private static final Logger log = LoggerFactory.getLogger(ExecutorStateEvent.class);
    private static final String MESSAGE = "Current thread pool executor state: ";
    private boolean isThreadPoolExecutor;
    private String executorName;
    private int currentQueueSize;
    private int activeThreads;
    private int coreThreads;
    private int leasesOwned;
    private int largestPoolSize;
    private int maximumPoolSize;

    ExecutorStateEvent(ExecutorService executor, LeaseCoordinator leaseCoordinator) {
        this(executor);
        this.leasesOwned = leaseCoordinator.getAssignments().size();
    }

    public ExecutorStateEvent(ExecutorService executor) {
        if (executor instanceof ThreadPoolExecutor) {
            this.isThreadPoolExecutor = true;
            ThreadPoolExecutor ex = (ThreadPoolExecutor)executor;
            this.executorName = ex.getClass().getSimpleName();
            this.currentQueueSize = ex.getQueue().size();
            this.activeThreads = ex.getActiveCount();
            this.coreThreads = ex.getCorePoolSize();
            this.largestPoolSize = ex.getLargestPoolSize();
            this.maximumPoolSize = ex.getMaximumPoolSize();
        }
    }

    @Override
    public void accept(DiagnosticEventHandler visitor) {
        if (this.isThreadPoolExecutor) {
            visitor.visit(this);
        }
    }

    @Override
    public String message() {
        return MESSAGE + this.toString();
    }

    public boolean isThreadPoolExecutor() {
        return this.isThreadPoolExecutor;
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public int getCurrentQueueSize() {
        return this.currentQueueSize;
    }

    public int getActiveThreads() {
        return this.activeThreads;
    }

    public int getCoreThreads() {
        return this.coreThreads;
    }

    public int getLeasesOwned() {
        return this.leasesOwned;
    }

    public int getLargestPoolSize() {
        return this.largestPoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public String toString() {
        return "ExecutorStateEvent(executorName=" + this.getExecutorName() + ", currentQueueSize=" + this.getCurrentQueueSize() + ", activeThreads=" + this.getActiveThreads() + ", coreThreads=" + this.getCoreThreads() + ", leasesOwned=" + this.getLeasesOwned() + ", largestPoolSize=" + this.getLargestPoolSize() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ")";
    }
}

