/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.coordinator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.kinesis.common.HashKeyRangeForLease;
import software.amazon.kinesis.common.StreamConfig;
import software.amazon.kinesis.common.StreamIdentifier;
import software.amazon.kinesis.coordinator.LeaderDecider;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.LeaseRefresher;
import software.amazon.kinesis.leases.MultiStreamLease;
import software.amazon.kinesis.leases.ShardDetector;
import software.amazon.kinesis.leases.ShardSyncTaskManager;
import software.amazon.kinesis.leases.UpdateField;
import software.amazon.kinesis.leases.exceptions.DependencyException;
import software.amazon.kinesis.leases.exceptions.InvalidStateException;
import software.amazon.kinesis.leases.exceptions.ProvisionedThroughputException;
import software.amazon.kinesis.lifecycle.TaskResult;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.metrics.MetricsScope;
import software.amazon.kinesis.metrics.MetricsUtil;

class PeriodicShardSyncManager {
    private static final Logger log = LoggerFactory.getLogger(PeriodicShardSyncManager.class);
    private static final long INITIAL_DELAY = 60000L;
    @VisibleForTesting
    static final BigInteger MIN_HASH_KEY = BigInteger.ZERO;
    @VisibleForTesting
    static final BigInteger MAX_HASH_KEY = new BigInteger("2").pow(128).subtract(BigInteger.ONE);
    static final String PERIODIC_SHARD_SYNC_MANAGER = "PeriodicShardSyncManager";
    private Map<StreamIdentifier, HashRangeHoleTracker> hashRangeHoleTrackerMap = new HashMap<StreamIdentifier, HashRangeHoleTracker>();
    private final String workerId;
    private final LeaderDecider leaderDecider;
    private final LeaseRefresher leaseRefresher;
    private final Map<StreamIdentifier, StreamConfig> currentStreamConfigMap;
    private final Function<StreamConfig, ShardSyncTaskManager> shardSyncTaskManagerProvider;
    private final ScheduledExecutorService shardSyncThreadPool;
    private final boolean isMultiStreamingMode;
    private final MetricsFactory metricsFactory;
    private final long leasesRecoveryAuditorExecutionFrequencyMillis;
    private final int leasesRecoveryAuditorInconsistencyConfidenceThreshold;
    private boolean isRunning;

    PeriodicShardSyncManager(String workerId, LeaderDecider leaderDecider, LeaseRefresher leaseRefresher, Map<StreamIdentifier, StreamConfig> currentStreamConfigMap, Function<StreamConfig, ShardSyncTaskManager> shardSyncTaskManagerProvider, boolean isMultiStreamingMode, MetricsFactory metricsFactory, long leasesRecoveryAuditorExecutionFrequencyMillis, int leasesRecoveryAuditorInconsistencyConfidenceThreshold) {
        this(workerId, leaderDecider, leaseRefresher, currentStreamConfigMap, shardSyncTaskManagerProvider, Executors.newSingleThreadScheduledExecutor(), isMultiStreamingMode, metricsFactory, leasesRecoveryAuditorExecutionFrequencyMillis, leasesRecoveryAuditorInconsistencyConfidenceThreshold);
    }

    PeriodicShardSyncManager(String workerId, LeaderDecider leaderDecider, LeaseRefresher leaseRefresher, Map<StreamIdentifier, StreamConfig> currentStreamConfigMap, Function<StreamConfig, ShardSyncTaskManager> shardSyncTaskManagerProvider, ScheduledExecutorService shardSyncThreadPool, boolean isMultiStreamingMode, MetricsFactory metricsFactory, long leasesRecoveryAuditorExecutionFrequencyMillis, int leasesRecoveryAuditorInconsistencyConfidenceThreshold) {
        Validate.notBlank((CharSequence)workerId, (String)"WorkerID is required to initialize PeriodicShardSyncManager.", (Object[])new Object[0]);
        Validate.notNull((Object)leaderDecider, (String)"LeaderDecider is required to initialize PeriodicShardSyncManager.", (Object[])new Object[0]);
        this.workerId = workerId;
        this.leaderDecider = leaderDecider;
        this.leaseRefresher = leaseRefresher;
        this.currentStreamConfigMap = currentStreamConfigMap;
        this.shardSyncTaskManagerProvider = shardSyncTaskManagerProvider;
        this.shardSyncThreadPool = shardSyncThreadPool;
        this.isMultiStreamingMode = isMultiStreamingMode;
        this.metricsFactory = metricsFactory;
        this.leasesRecoveryAuditorExecutionFrequencyMillis = leasesRecoveryAuditorExecutionFrequencyMillis;
        this.leasesRecoveryAuditorInconsistencyConfidenceThreshold = leasesRecoveryAuditorInconsistencyConfidenceThreshold;
    }

    public synchronized TaskResult start() {
        if (!this.isRunning) {
            Runnable periodicShardSyncer = () -> {
                try {
                    this.runShardSync();
                }
                catch (Throwable t) {
                    log.error("Error during runShardSync.", t);
                }
            };
            this.shardSyncThreadPool.scheduleWithFixedDelay(periodicShardSyncer, 60000L, this.leasesRecoveryAuditorExecutionFrequencyMillis, TimeUnit.MILLISECONDS);
            this.isRunning = true;
        }
        return new TaskResult(null);
    }

    public synchronized void syncShardsOnce() throws Exception {
        for (Map.Entry<StreamIdentifier, StreamConfig> streamConfigEntry : this.currentStreamConfigMap.entrySet()) {
            StreamIdentifier streamIdentifier = streamConfigEntry.getKey();
            log.info("Syncing Kinesis shard info for " + streamIdentifier);
            StreamConfig streamConfig = streamConfigEntry.getValue();
            ShardSyncTaskManager shardSyncTaskManager = this.shardSyncTaskManagerProvider.apply(streamConfig);
            TaskResult taskResult = shardSyncTaskManager.callShardSyncTask();
            if (taskResult.getException() == null) continue;
            throw taskResult.getException();
        }
    }

    public void stop() {
        if (this.isRunning) {
            log.info(String.format("Shutting down leader decider on worker %s", this.workerId));
            this.leaderDecider.shutdown();
            log.info(String.format("Shutting down periodic shard sync task scheduler on worker %s", this.workerId));
            this.shardSyncThreadPool.shutdown();
            this.isRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runShardSync() {
        if (this.leaderDecider.isLeader(this.workerId).booleanValue()) {
            log.info(String.format("WorkerId %s is leader, running the periodic shard sync task", this.workerId));
            MetricsScope scope = MetricsUtil.createMetricsWithOperation(this.metricsFactory, PERIODIC_SHARD_SYNC_MANAGER);
            int numStreamsWithPartialLeases = 0;
            int numStreamsToSync = 0;
            boolean isRunSuccess = false;
            long runStartMillis = System.currentTimeMillis();
            try {
                Map<StreamIdentifier, List<Lease>> streamToLeasesMap = this.getStreamToLeasesMap(this.currentStreamConfigMap.keySet());
                for (Map.Entry<StreamIdentifier, StreamConfig> streamConfigEntry : this.currentStreamConfigMap.entrySet()) {
                    ShardSyncResponse shardSyncResponse = this.checkForShardSync(streamConfigEntry.getKey(), streamToLeasesMap.get(streamConfigEntry.getKey()));
                    numStreamsWithPartialLeases += shardSyncResponse.isHoleDetected() ? 1 : 0;
                    numStreamsToSync += shardSyncResponse.shouldDoShardSync ? 1 : 0;
                    if (shardSyncResponse.shouldDoShardSync()) {
                        log.info("Periodic shard syncer initiating shard sync for {} due to the reason - {} ", (Object)streamConfigEntry.getKey(), (Object)shardSyncResponse.reasonForDecision());
                        ShardSyncTaskManager shardSyncTaskManager = this.shardSyncTaskManagerProvider.apply(streamConfigEntry.getValue());
                        if (shardSyncTaskManager.submitShardSyncTask()) continue;
                        log.warn("Failed to submit shard sync task for stream {}. This could be due to the previous pending shard sync task.", (Object)shardSyncTaskManager.shardDetector().streamIdentifier().streamName());
                        continue;
                    }
                    log.info("Skipping shard sync for {} due to the reason - {}", (Object)streamConfigEntry.getKey(), (Object)shardSyncResponse.reasonForDecision());
                }
                isRunSuccess = true;
            }
            catch (Exception e) {
                log.error("Caught exception while running periodic shard syncer.", (Throwable)e);
            }
            finally {
                scope.addData("NumStreamsWithPartialLeases", numStreamsWithPartialLeases, StandardUnit.COUNT, MetricsLevel.SUMMARY);
                scope.addData("NumStreamsToSync", numStreamsToSync, StandardUnit.COUNT, MetricsLevel.SUMMARY);
                MetricsUtil.addSuccessAndLatency(scope, isRunSuccess, runStartMillis, MetricsLevel.SUMMARY);
                scope.end();
            }
        } else {
            log.debug("WorkerId {} is not a leader, not running the shard sync task", (Object)this.workerId);
        }
    }

    private Map<StreamIdentifier, List<Lease>> getStreamToLeasesMap(Set<StreamIdentifier> streamIdentifiersToFilter) throws DependencyException, ProvisionedThroughputException, InvalidStateException {
        List<Lease> leases = this.leaseRefresher.listLeases();
        if (!this.isMultiStreamingMode) {
            Validate.isTrue((streamIdentifiersToFilter.size() == 1 ? 1 : 0) != 0);
            return Collections.singletonMap(streamIdentifiersToFilter.iterator().next(), leases);
        }
        HashMap<StreamIdentifier, List<Lease>> streamToLeasesMap = new HashMap<StreamIdentifier, List<Lease>>();
        for (Lease lease : leases) {
            StreamIdentifier streamIdentifier = StreamIdentifier.multiStreamInstance(((MultiStreamLease)lease).streamIdentifier());
            if (!streamIdentifiersToFilter.contains(streamIdentifier)) continue;
            streamToLeasesMap.computeIfAbsent(streamIdentifier, s -> new ArrayList()).add(lease);
        }
        return streamToLeasesMap;
    }

    @VisibleForTesting
    ShardSyncResponse checkForShardSync(StreamIdentifier streamIdentifier, List<Lease> leases) {
        if (CollectionUtils.isNullOrEmpty(leases)) {
            log.info("No leases found for {}. Will be triggering shard sync", (Object)streamIdentifier);
            return new ShardSyncResponse(true, false, "No leases found for " + streamIdentifier);
        }
        Optional<HashRangeHole> hashRangeHoleOpt = this.hasHoleInLeases(streamIdentifier, leases);
        if (hashRangeHoleOpt.isPresent()) {
            HashRangeHoleTracker hashRangeHoleTracker = this.hashRangeHoleTrackerMap.computeIfAbsent(streamIdentifier, s -> new HashRangeHoleTracker());
            boolean hasHoleWithHighConfidence = hashRangeHoleTracker.hasHighConfidenceOfHoleWith(hashRangeHoleOpt.get());
            return new ShardSyncResponse(hasHoleWithHighConfidence, true, "Detected same hole for " + hashRangeHoleTracker.getNumConsecutiveHoles() + " times. Shard sync will be initiated when threshold reaches " + this.leasesRecoveryAuditorInconsistencyConfidenceThreshold);
        }
        this.hashRangeHoleTrackerMap.remove(streamIdentifier);
        return new ShardSyncResponse(false, false, "Hash Ranges are complete for " + streamIdentifier);
    }

    @VisibleForTesting
    Optional<HashRangeHole> hasHoleInLeases(StreamIdentifier streamIdentifier, List<Lease> leases) {
        List<Lease> activeLeases = leases.stream().filter(lease -> lease.checkpoint() != null && !lease.checkpoint().isShardEnd()).collect(Collectors.toList());
        List<Lease> activeLeasesWithHashRanges = this.fillWithHashRangesIfRequired(streamIdentifier, activeLeases);
        return PeriodicShardSyncManager.checkForHoleInHashKeyRanges(streamIdentifier, activeLeasesWithHashRanges);
    }

    private List<Lease> fillWithHashRangesIfRequired(StreamIdentifier streamIdentifier, List<Lease> activeLeases) {
        List activeLeasesWithNoHashRanges = activeLeases.stream().filter(lease -> lease.hashKeyRangeForLease() == null).collect(Collectors.toList());
        Optional<Lease> minLeaseOpt = activeLeasesWithNoHashRanges.stream().min(Comparator.comparing(Lease::leaseKey));
        if (minLeaseOpt.isPresent()) {
            Lease minLease = minLeaseOpt.get();
            ShardDetector shardDetector = this.shardSyncTaskManagerProvider.apply(this.currentStreamConfigMap.get(streamIdentifier)).shardDetector();
            Map<String, Shard> kinesisShards = shardDetector.listShards().stream().collect(Collectors.toMap(Shard::shardId, shard -> shard));
            return activeLeases.stream().map(lease -> {
                if (lease.hashKeyRangeForLease() == null) {
                    String shardId = lease instanceof MultiStreamLease ? ((MultiStreamLease)lease).shardId() : lease.leaseKey();
                    Shard shard = (Shard)kinesisShards.get(shardId);
                    if (shard == null) {
                        return lease;
                    }
                    lease.hashKeyRange(HashKeyRangeForLease.fromHashKeyRange(shard.hashKeyRange()));
                    try {
                        this.leaseRefresher.updateLeaseWithMetaInfo((Lease)lease, UpdateField.HASH_KEY_RANGE);
                    }
                    catch (Exception e) {
                        log.warn("Unable to update hash range key information for lease {} of stream {}. This may result in explicit lease sync.", (Object)lease.leaseKey(), (Object)streamIdentifier);
                    }
                }
                return lease;
            }).filter(lease -> lease.hashKeyRangeForLease() != null).collect(Collectors.toList());
        }
        return activeLeases;
    }

    @VisibleForTesting
    static Optional<HashRangeHole> checkForHoleInHashKeyRanges(StreamIdentifier streamIdentifier, List<Lease> leasesWithHashKeyRanges) {
        List<Lease> sortedLeasesWithHashKeyRanges = PeriodicShardSyncManager.sortLeasesByHashRange(leasesWithHashKeyRanges);
        if (sortedLeasesWithHashKeyRanges.isEmpty()) {
            log.error("No leases with valid hashranges found for stream {}", (Object)streamIdentifier);
            return Optional.of(new HashRangeHole());
        }
        if (!sortedLeasesWithHashKeyRanges.get(0).hashKeyRangeForLease().startingHashKey().equals(MIN_HASH_KEY) || !sortedLeasesWithHashKeyRanges.get(sortedLeasesWithHashKeyRanges.size() - 1).hashKeyRangeForLease().endingHashKey().equals(MAX_HASH_KEY)) {
            log.error("Incomplete hash range found for stream {} between {} and {}.", new Object[]{streamIdentifier, sortedLeasesWithHashKeyRanges.get(0), sortedLeasesWithHashKeyRanges.get(sortedLeasesWithHashKeyRanges.size() - 1)});
            return Optional.of(new HashRangeHole(sortedLeasesWithHashKeyRanges.get(0).hashKeyRangeForLease(), sortedLeasesWithHashKeyRanges.get(sortedLeasesWithHashKeyRanges.size() - 1).hashKeyRangeForLease()));
        }
        if (sortedLeasesWithHashKeyRanges.size() > 1) {
            Lease leftMostLeaseToReportInCaseOfHole = sortedLeasesWithHashKeyRanges.get(0);
            HashKeyRangeForLease leftLeaseHashRange = leftMostLeaseToReportInCaseOfHole.hashKeyRangeForLease();
            for (int i = 1; i < sortedLeasesWithHashKeyRanges.size(); ++i) {
                HashKeyRangeForLease rightLeaseHashRange = sortedLeasesWithHashKeyRanges.get(i).hashKeyRangeForLease();
                BigInteger rangeDiff = rightLeaseHashRange.startingHashKey().subtract(leftLeaseHashRange.endingHashKey());
                if (rangeDiff.signum() <= 0) {
                    leftLeaseHashRange = new HashKeyRangeForLease(leftLeaseHashRange.startingHashKey(), leftLeaseHashRange.endingHashKey().max(rightLeaseHashRange.endingHashKey()));
                    continue;
                }
                if (!rangeDiff.equals(BigInteger.ONE)) {
                    log.error("Incomplete hash range found for {} between {} and {}.", new Object[]{streamIdentifier, leftMostLeaseToReportInCaseOfHole, sortedLeasesWithHashKeyRanges.get(i)});
                    return Optional.of(new HashRangeHole(leftMostLeaseToReportInCaseOfHole.hashKeyRangeForLease(), sortedLeasesWithHashKeyRanges.get(i).hashKeyRangeForLease()));
                }
                leftMostLeaseToReportInCaseOfHole = sortedLeasesWithHashKeyRanges.get(i);
                leftLeaseHashRange = rightLeaseHashRange;
            }
        }
        return Optional.empty();
    }

    @VisibleForTesting
    static List<Lease> sortLeasesByHashRange(List<Lease> leasesWithHashKeyRanges) {
        if (leasesWithHashKeyRanges.size() == 0 || leasesWithHashKeyRanges.size() == 1) {
            return leasesWithHashKeyRanges;
        }
        Collections.sort(leasesWithHashKeyRanges, new HashKeyRangeComparator());
        return leasesWithHashKeyRanges;
    }

    public Map<StreamIdentifier, HashRangeHoleTracker> getHashRangeHoleTrackerMap() {
        return this.hashRangeHoleTrackerMap;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public LeaderDecider getLeaderDecider() {
        return this.leaderDecider;
    }

    public LeaseRefresher getLeaseRefresher() {
        return this.leaseRefresher;
    }

    public Map<StreamIdentifier, StreamConfig> getCurrentStreamConfigMap() {
        return this.currentStreamConfigMap;
    }

    public Function<StreamConfig, ShardSyncTaskManager> getShardSyncTaskManagerProvider() {
        return this.shardSyncTaskManagerProvider;
    }

    public ScheduledExecutorService getShardSyncThreadPool() {
        return this.shardSyncThreadPool;
    }

    public boolean isMultiStreamingMode() {
        return this.isMultiStreamingMode;
    }

    public MetricsFactory getMetricsFactory() {
        return this.metricsFactory;
    }

    public long getLeasesRecoveryAuditorExecutionFrequencyMillis() {
        return this.leasesRecoveryAuditorExecutionFrequencyMillis;
    }

    public int getLeasesRecoveryAuditorInconsistencyConfidenceThreshold() {
        return this.leasesRecoveryAuditorInconsistencyConfidenceThreshold;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PeriodicShardSyncManager)) {
            return false;
        }
        PeriodicShardSyncManager other = (PeriodicShardSyncManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<StreamIdentifier, HashRangeHoleTracker> this$hashRangeHoleTrackerMap = this.getHashRangeHoleTrackerMap();
        Map<StreamIdentifier, HashRangeHoleTracker> other$hashRangeHoleTrackerMap = other.getHashRangeHoleTrackerMap();
        if (this$hashRangeHoleTrackerMap == null ? other$hashRangeHoleTrackerMap != null : !((Object)this$hashRangeHoleTrackerMap).equals(other$hashRangeHoleTrackerMap)) {
            return false;
        }
        String this$workerId = this.getWorkerId();
        String other$workerId = other.getWorkerId();
        if (this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId)) {
            return false;
        }
        LeaderDecider this$leaderDecider = this.getLeaderDecider();
        LeaderDecider other$leaderDecider = other.getLeaderDecider();
        if (this$leaderDecider == null ? other$leaderDecider != null : !this$leaderDecider.equals(other$leaderDecider)) {
            return false;
        }
        LeaseRefresher this$leaseRefresher = this.getLeaseRefresher();
        LeaseRefresher other$leaseRefresher = other.getLeaseRefresher();
        if (this$leaseRefresher == null ? other$leaseRefresher != null : !this$leaseRefresher.equals(other$leaseRefresher)) {
            return false;
        }
        Map<StreamIdentifier, StreamConfig> this$currentStreamConfigMap = this.getCurrentStreamConfigMap();
        Map<StreamIdentifier, StreamConfig> other$currentStreamConfigMap = other.getCurrentStreamConfigMap();
        if (this$currentStreamConfigMap == null ? other$currentStreamConfigMap != null : !((Object)this$currentStreamConfigMap).equals(other$currentStreamConfigMap)) {
            return false;
        }
        Function<StreamConfig, ShardSyncTaskManager> this$shardSyncTaskManagerProvider = this.getShardSyncTaskManagerProvider();
        Function<StreamConfig, ShardSyncTaskManager> other$shardSyncTaskManagerProvider = other.getShardSyncTaskManagerProvider();
        if (this$shardSyncTaskManagerProvider == null ? other$shardSyncTaskManagerProvider != null : !this$shardSyncTaskManagerProvider.equals(other$shardSyncTaskManagerProvider)) {
            return false;
        }
        ScheduledExecutorService this$shardSyncThreadPool = this.getShardSyncThreadPool();
        ScheduledExecutorService other$shardSyncThreadPool = other.getShardSyncThreadPool();
        if (this$shardSyncThreadPool == null ? other$shardSyncThreadPool != null : !this$shardSyncThreadPool.equals(other$shardSyncThreadPool)) {
            return false;
        }
        if (this.isMultiStreamingMode() != other.isMultiStreamingMode()) {
            return false;
        }
        MetricsFactory this$metricsFactory = this.getMetricsFactory();
        MetricsFactory other$metricsFactory = other.getMetricsFactory();
        if (this$metricsFactory == null ? other$metricsFactory != null : !this$metricsFactory.equals(other$metricsFactory)) {
            return false;
        }
        if (this.getLeasesRecoveryAuditorExecutionFrequencyMillis() != other.getLeasesRecoveryAuditorExecutionFrequencyMillis()) {
            return false;
        }
        if (this.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold() != other.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold()) {
            return false;
        }
        return this.isRunning() == other.isRunning();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PeriodicShardSyncManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<StreamIdentifier, HashRangeHoleTracker> $hashRangeHoleTrackerMap = this.getHashRangeHoleTrackerMap();
        result = result * 59 + ($hashRangeHoleTrackerMap == null ? 43 : ((Object)$hashRangeHoleTrackerMap).hashCode());
        String $workerId = this.getWorkerId();
        result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
        LeaderDecider $leaderDecider = this.getLeaderDecider();
        result = result * 59 + ($leaderDecider == null ? 43 : $leaderDecider.hashCode());
        LeaseRefresher $leaseRefresher = this.getLeaseRefresher();
        result = result * 59 + ($leaseRefresher == null ? 43 : $leaseRefresher.hashCode());
        Map<StreamIdentifier, StreamConfig> $currentStreamConfigMap = this.getCurrentStreamConfigMap();
        result = result * 59 + ($currentStreamConfigMap == null ? 43 : ((Object)$currentStreamConfigMap).hashCode());
        Function<StreamConfig, ShardSyncTaskManager> $shardSyncTaskManagerProvider = this.getShardSyncTaskManagerProvider();
        result = result * 59 + ($shardSyncTaskManagerProvider == null ? 43 : $shardSyncTaskManagerProvider.hashCode());
        ScheduledExecutorService $shardSyncThreadPool = this.getShardSyncThreadPool();
        result = result * 59 + ($shardSyncThreadPool == null ? 43 : $shardSyncThreadPool.hashCode());
        result = result * 59 + (this.isMultiStreamingMode() ? 79 : 97);
        MetricsFactory $metricsFactory = this.getMetricsFactory();
        result = result * 59 + ($metricsFactory == null ? 43 : $metricsFactory.hashCode());
        long $leasesRecoveryAuditorExecutionFrequencyMillis = this.getLeasesRecoveryAuditorExecutionFrequencyMillis();
        result = result * 59 + (int)($leasesRecoveryAuditorExecutionFrequencyMillis >>> 32 ^ $leasesRecoveryAuditorExecutionFrequencyMillis);
        result = result * 59 + this.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold();
        result = result * 59 + (this.isRunning() ? 79 : 97);
        return result;
    }

    private static class HashKeyRangeComparator
    implements Comparator<Lease>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private HashKeyRangeComparator() {
        }

        @Override
        public int compare(Lease lease, Lease otherLease) {
            Validate.notNull((Object)lease);
            Validate.notNull((Object)otherLease);
            Validate.notNull((Object)lease.hashKeyRangeForLease());
            Validate.notNull((Object)otherLease.hashKeyRangeForLease());
            return ComparisonChain.start().compare((Comparable)lease.hashKeyRangeForLease().startingHashKey(), (Comparable)otherLease.hashKeyRangeForLease().startingHashKey()).compare((Comparable)lease.hashKeyRangeForLease().endingHashKey(), (Comparable)otherLease.hashKeyRangeForLease().endingHashKey()).result();
        }
    }

    private class HashRangeHoleTracker {
        private HashRangeHole hashRangeHole;
        private Integer numConsecutiveHoles;

        private HashRangeHoleTracker() {
        }

        public boolean hasHighConfidenceOfHoleWith(@NonNull HashRangeHole hashRangeHole) {
            if (hashRangeHole == null) {
                throw new NullPointerException("hashRangeHole");
            }
            if (hashRangeHole.equals(this.hashRangeHole)) {
                HashRangeHoleTracker hashRangeHoleTracker = this;
                hashRangeHoleTracker.numConsecutiveHoles = hashRangeHoleTracker.numConsecutiveHoles + 1;
            } else {
                this.hashRangeHole = hashRangeHole;
                this.numConsecutiveHoles = 1;
            }
            return this.numConsecutiveHoles >= PeriodicShardSyncManager.this.leasesRecoveryAuditorInconsistencyConfidenceThreshold;
        }

        public Integer getNumConsecutiveHoles() {
            return this.numConsecutiveHoles;
        }
    }

    private static final class HashRangeHole {
        private final HashKeyRangeForLease hashRangeAtStartOfPossibleHole;
        private final HashKeyRangeForLease hashRangeAtEndOfPossibleHole;

        HashRangeHole() {
            this.hashRangeAtEndOfPossibleHole = null;
            this.hashRangeAtStartOfPossibleHole = null;
        }

        HashRangeHole(HashKeyRangeForLease hashRangeAtStartOfPossibleHole, HashKeyRangeForLease hashRangeAtEndOfPossibleHole) {
            this.hashRangeAtStartOfPossibleHole = hashRangeAtStartOfPossibleHole;
            this.hashRangeAtEndOfPossibleHole = hashRangeAtEndOfPossibleHole;
        }

        public HashKeyRangeForLease getHashRangeAtStartOfPossibleHole() {
            return this.hashRangeAtStartOfPossibleHole;
        }

        public HashKeyRangeForLease getHashRangeAtEndOfPossibleHole() {
            return this.hashRangeAtEndOfPossibleHole;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HashRangeHole)) {
                return false;
            }
            HashRangeHole other = (HashRangeHole)o;
            HashKeyRangeForLease this$hashRangeAtStartOfPossibleHole = this.getHashRangeAtStartOfPossibleHole();
            HashKeyRangeForLease other$hashRangeAtStartOfPossibleHole = other.getHashRangeAtStartOfPossibleHole();
            if (this$hashRangeAtStartOfPossibleHole == null ? other$hashRangeAtStartOfPossibleHole != null : !((Object)this$hashRangeAtStartOfPossibleHole).equals(other$hashRangeAtStartOfPossibleHole)) {
                return false;
            }
            HashKeyRangeForLease this$hashRangeAtEndOfPossibleHole = this.getHashRangeAtEndOfPossibleHole();
            HashKeyRangeForLease other$hashRangeAtEndOfPossibleHole = other.getHashRangeAtEndOfPossibleHole();
            return !(this$hashRangeAtEndOfPossibleHole == null ? other$hashRangeAtEndOfPossibleHole != null : !((Object)this$hashRangeAtEndOfPossibleHole).equals(other$hashRangeAtEndOfPossibleHole));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            HashKeyRangeForLease $hashRangeAtStartOfPossibleHole = this.getHashRangeAtStartOfPossibleHole();
            result = result * 59 + ($hashRangeAtStartOfPossibleHole == null ? 43 : ((Object)$hashRangeAtStartOfPossibleHole).hashCode());
            HashKeyRangeForLease $hashRangeAtEndOfPossibleHole = this.getHashRangeAtEndOfPossibleHole();
            result = result * 59 + ($hashRangeAtEndOfPossibleHole == null ? 43 : ((Object)$hashRangeAtEndOfPossibleHole).hashCode());
            return result;
        }

        public String toString() {
            return "PeriodicShardSyncManager.HashRangeHole(hashRangeAtStartOfPossibleHole=" + this.getHashRangeAtStartOfPossibleHole() + ", hashRangeAtEndOfPossibleHole=" + this.getHashRangeAtEndOfPossibleHole() + ")";
        }
    }

    @VisibleForTesting
    static final class ShardSyncResponse {
        private final boolean shouldDoShardSync;
        private final boolean isHoleDetected;
        private final String reasonForDecision;

        public ShardSyncResponse(boolean shouldDoShardSync, boolean isHoleDetected, String reasonForDecision) {
            this.shouldDoShardSync = shouldDoShardSync;
            this.isHoleDetected = isHoleDetected;
            this.reasonForDecision = reasonForDecision;
        }

        public boolean shouldDoShardSync() {
            return this.shouldDoShardSync;
        }

        public boolean isHoleDetected() {
            return this.isHoleDetected;
        }

        public String reasonForDecision() {
            return this.reasonForDecision;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShardSyncResponse)) {
                return false;
            }
            ShardSyncResponse other = (ShardSyncResponse)o;
            if (this.shouldDoShardSync() != other.shouldDoShardSync()) {
                return false;
            }
            if (this.isHoleDetected() != other.isHoleDetected()) {
                return false;
            }
            String this$reasonForDecision = this.reasonForDecision();
            String other$reasonForDecision = other.reasonForDecision();
            return !(this$reasonForDecision == null ? other$reasonForDecision != null : !this$reasonForDecision.equals(other$reasonForDecision));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.shouldDoShardSync() ? 79 : 97);
            result = result * 59 + (this.isHoleDetected() ? 79 : 97);
            String $reasonForDecision = this.reasonForDecision();
            result = result * 59 + ($reasonForDecision == null ? 43 : $reasonForDecision.hashCode());
            return result;
        }

        public String toString() {
            return "PeriodicShardSyncManager.ShardSyncResponse(shouldDoShardSync=" + this.shouldDoShardSync() + ", isHoleDetected=" + this.isHoleDetected() + ", reasonForDecision=" + this.reasonForDecision() + ")";
        }
    }
}

