/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases.dynamodb;

import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.kinesis.leases.DynamoUtils;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.MultiStreamLease;
import software.amazon.kinesis.leases.dynamodb.DynamoDBLeaseSerializer;

public class DynamoDBMultiStreamLeaseSerializer
extends DynamoDBLeaseSerializer {
    private static final String STREAM_ID_KEY = "streamName";
    private static final String SHARD_ID_KEY = "shardId";

    @Override
    public Map<String, AttributeValue> toDynamoRecord(Lease lease) {
        MultiStreamLease multiStreamLease = MultiStreamLease.validateAndCast(lease);
        Map<String, AttributeValue> result = super.toDynamoRecord(multiStreamLease);
        result.put(STREAM_ID_KEY, DynamoUtils.createAttributeValue(multiStreamLease.streamIdentifier()));
        result.put(SHARD_ID_KEY, DynamoUtils.createAttributeValue(multiStreamLease.shardId()));
        return result;
    }

    @Override
    public MultiStreamLease fromDynamoRecord(Map<String, AttributeValue> dynamoRecord) {
        MultiStreamLease multiStreamLease = (MultiStreamLease)super.fromDynamoRecord(dynamoRecord, new MultiStreamLease());
        multiStreamLease.streamIdentifier(DynamoUtils.safeGetString(dynamoRecord, STREAM_ID_KEY));
        multiStreamLease.shardId(DynamoUtils.safeGetString(dynamoRecord, SHARD_ID_KEY));
        return multiStreamLease;
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoUpdateLeaseUpdate(Lease lease) {
        MultiStreamLease multiStreamLease = MultiStreamLease.validateAndCast(lease);
        Map<String, AttributeValueUpdate> result = super.getDynamoUpdateLeaseUpdate(multiStreamLease);
        result.put(STREAM_ID_KEY, this.putUpdate(DynamoUtils.createAttributeValue(multiStreamLease.streamIdentifier())));
        result.put(SHARD_ID_KEY, this.putUpdate(DynamoUtils.createAttributeValue(multiStreamLease.shardId())));
        return result;
    }
}

