/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases.dynamodb;

import lombok.NonNull;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;

public class TableCreatorCallbackInput {
    @NonNull
    private final DynamoDbAsyncClient dynamoDbClient;
    @NonNull
    private final String tableName;

    TableCreatorCallbackInput(@NonNull DynamoDbAsyncClient dynamoDbClient, @NonNull String tableName) {
        if (dynamoDbClient == null) {
            throw new NullPointerException("dynamoDbClient");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName");
        }
        this.dynamoDbClient = dynamoDbClient;
        this.tableName = tableName;
    }

    public static TableCreatorCallbackInputBuilder builder() {
        return new TableCreatorCallbackInputBuilder();
    }

    public TableCreatorCallbackInputBuilder toBuilder() {
        return new TableCreatorCallbackInputBuilder().dynamoDbClient(this.dynamoDbClient).tableName(this.tableName);
    }

    @NonNull
    public DynamoDbAsyncClient dynamoDbClient() {
        return this.dynamoDbClient;
    }

    @NonNull
    public String tableName() {
        return this.tableName;
    }

    public String toString() {
        return "TableCreatorCallbackInput(dynamoDbClient=" + this.dynamoDbClient() + ", tableName=" + this.tableName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableCreatorCallbackInput)) {
            return false;
        }
        TableCreatorCallbackInput other = (TableCreatorCallbackInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DynamoDbAsyncClient this$dynamoDbClient = this.dynamoDbClient();
        DynamoDbAsyncClient other$dynamoDbClient = other.dynamoDbClient();
        if (this$dynamoDbClient == null ? other$dynamoDbClient != null : !this$dynamoDbClient.equals(other$dynamoDbClient)) {
            return false;
        }
        String this$tableName = this.tableName();
        String other$tableName = other.tableName();
        return !(this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableCreatorCallbackInput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DynamoDbAsyncClient $dynamoDbClient = this.dynamoDbClient();
        result = result * 59 + ($dynamoDbClient == null ? 43 : $dynamoDbClient.hashCode());
        String $tableName = this.tableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        return result;
    }

    public static class TableCreatorCallbackInputBuilder {
        private DynamoDbAsyncClient dynamoDbClient;
        private String tableName;

        TableCreatorCallbackInputBuilder() {
        }

        public TableCreatorCallbackInputBuilder dynamoDbClient(DynamoDbAsyncClient dynamoDbClient) {
            this.dynamoDbClient = dynamoDbClient;
            return this;
        }

        public TableCreatorCallbackInputBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public TableCreatorCallbackInput build() {
            return new TableCreatorCallbackInput(this.dynamoDbClient, this.tableName);
        }

        public String toString() {
            return "TableCreatorCallbackInput.TableCreatorCallbackInputBuilder(dynamoDbClient=" + this.dynamoDbClient + ", tableName=" + this.tableName + ")";
        }
    }
}

