/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.lifecycle.events;

import software.amazon.kinesis.leases.ShardInfo;
import software.amazon.kinesis.lifecycle.TaskOutcome;
import software.amazon.kinesis.lifecycle.TaskType;

public class TaskExecutionListenerInput {
    private final ShardInfo shardInfo;
    private final TaskType taskType;
    private final TaskOutcome taskOutcome;

    TaskExecutionListenerInput(ShardInfo shardInfo, TaskType taskType, TaskOutcome taskOutcome) {
        this.shardInfo = shardInfo;
        this.taskType = taskType;
        this.taskOutcome = taskOutcome;
    }

    public static TaskExecutionListenerInputBuilder builder() {
        return new TaskExecutionListenerInputBuilder();
    }

    public TaskExecutionListenerInputBuilder toBuilder() {
        return new TaskExecutionListenerInputBuilder().shardInfo(this.shardInfo).taskType(this.taskType).taskOutcome(this.taskOutcome);
    }

    public ShardInfo shardInfo() {
        return this.shardInfo;
    }

    public TaskType taskType() {
        return this.taskType;
    }

    public TaskOutcome taskOutcome() {
        return this.taskOutcome;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskExecutionListenerInput)) {
            return false;
        }
        TaskExecutionListenerInput other = (TaskExecutionListenerInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ShardInfo this$shardInfo = this.shardInfo();
        ShardInfo other$shardInfo = other.shardInfo();
        if (this$shardInfo == null ? other$shardInfo != null : !((Object)this$shardInfo).equals(other$shardInfo)) {
            return false;
        }
        TaskType this$taskType = this.taskType();
        TaskType other$taskType = other.taskType();
        if (this$taskType == null ? other$taskType != null : !((Object)((Object)this$taskType)).equals((Object)other$taskType)) {
            return false;
        }
        TaskOutcome this$taskOutcome = this.taskOutcome();
        TaskOutcome other$taskOutcome = other.taskOutcome();
        return !(this$taskOutcome == null ? other$taskOutcome != null : !((Object)((Object)this$taskOutcome)).equals((Object)other$taskOutcome));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskExecutionListenerInput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ShardInfo $shardInfo = this.shardInfo();
        result = result * 59 + ($shardInfo == null ? 43 : ((Object)$shardInfo).hashCode());
        TaskType $taskType = this.taskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)((Object)$taskType)).hashCode());
        TaskOutcome $taskOutcome = this.taskOutcome();
        result = result * 59 + ($taskOutcome == null ? 43 : ((Object)((Object)$taskOutcome)).hashCode());
        return result;
    }

    public String toString() {
        return "TaskExecutionListenerInput(shardInfo=" + this.shardInfo() + ", taskType=" + (Object)((Object)this.taskType()) + ", taskOutcome=" + (Object)((Object)this.taskOutcome()) + ")";
    }

    public static class TaskExecutionListenerInputBuilder {
        private ShardInfo shardInfo;
        private TaskType taskType;
        private TaskOutcome taskOutcome;

        TaskExecutionListenerInputBuilder() {
        }

        public TaskExecutionListenerInputBuilder shardInfo(ShardInfo shardInfo) {
            this.shardInfo = shardInfo;
            return this;
        }

        public TaskExecutionListenerInputBuilder taskType(TaskType taskType) {
            this.taskType = taskType;
            return this;
        }

        public TaskExecutionListenerInputBuilder taskOutcome(TaskOutcome taskOutcome) {
            this.taskOutcome = taskOutcome;
            return this;
        }

        public TaskExecutionListenerInput build() {
            return new TaskExecutionListenerInput(this.shardInfo, this.taskType, this.taskOutcome);
        }

        public String toString() {
            return "TaskExecutionListenerInput.TaskExecutionListenerInputBuilder(shardInfo=" + this.shardInfo + ", taskType=" + (Object)((Object)this.taskType) + ", taskOutcome=" + (Object)((Object)this.taskOutcome) + ")";
        }
    }
}

