/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchException;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.kinesis.metrics.CloudWatchMetricKey;
import software.amazon.kinesis.metrics.MetricDatumWithKey;
import software.amazon.kinesis.retrieval.AWSExceptionManager;

public class CloudWatchMetricsPublisher {
    private static final Logger log = LoggerFactory.getLogger(CloudWatchMetricsPublisher.class);
    private static final int BATCH_SIZE = 20;
    private static final int PUT_TIMEOUT_MILLIS = 5000;
    private static final AWSExceptionManager CW_EXCEPTION_MANAGER = new AWSExceptionManager();
    private final String namespace;
    private final CloudWatchAsyncClient cloudWatchAsyncClient;

    public CloudWatchMetricsPublisher(CloudWatchAsyncClient cloudWatchClient, String namespace) {
        this.cloudWatchAsyncClient = cloudWatchClient;
        this.namespace = namespace;
    }

    public void publishMetrics(List<MetricDatumWithKey<CloudWatchMetricKey>> dataToPublish) {
        for (int startIndex = 0; startIndex < dataToPublish.size(); startIndex += 20) {
            int endIndex = Math.min(dataToPublish.size(), startIndex + 20);
            PutMetricDataRequest.Builder request = PutMetricDataRequest.builder();
            request = request.namespace(this.namespace);
            ArrayList<MetricDatum> metricData = new ArrayList<MetricDatum>();
            for (int i = startIndex; i < endIndex; ++i) {
                metricData.add(dataToPublish.get((int)i).datum);
            }
            request = request.metricData(metricData);
            try {
                PutMetricDataRequest.Builder finalRequest = request;
                CloudWatchMetricsPublisher.blockingExecute(this.cloudWatchAsyncClient.putMetricData((PutMetricDataRequest)finalRequest.build()), 5000L, CW_EXCEPTION_MANAGER);
                continue;
            }
            catch (TimeoutException | CloudWatchException e) {
                log.warn("Could not publish {} datums to CloudWatch", (Object)(endIndex - startIndex), (Object)e);
                continue;
            }
            catch (Exception e) {
                log.error("Unknown exception while publishing {} datums to CloudWatch", (Object)(endIndex - startIndex), (Object)e);
            }
        }
    }

    private static <T> void blockingExecute(CompletableFuture<T> future, long timeOutMillis, AWSExceptionManager exceptionManager) throws TimeoutException {
        try {
            future.get(timeOutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw exceptionManager.apply(e.getCause());
        }
        catch (InterruptedException e) {
            log.info("Thread interrupted.");
        }
    }

    static {
        CW_EXCEPTION_MANAGER.add(CloudWatchException.class, t -> t);
    }
}

