/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ProtocolStringList;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.retrieval.KinesisClientRecord;
import software.amazon.kinesis.retrieval.kpl.Messages;

public class AggregatorUtil {
    private static final Logger log = LoggerFactory.getLogger(AggregatorUtil.class);
    public static final byte[] AGGREGATED_RECORD_MAGIC = new byte[]{-13, -119, -102, -62};
    private static final int DIGEST_SIZE = 16;
    private static final BigInteger STARTING_HASH_KEY = new BigInteger("0");
    private static final BigInteger ENDING_HASH_KEY = new BigInteger(StringUtils.repeat((String)"FF", (int)16), 16);

    public List<KinesisClientRecord> deaggregate(List<KinesisClientRecord> records) {
        return this.deaggregate(records, STARTING_HASH_KEY, ENDING_HASH_KEY);
    }

    public List<KinesisClientRecord> deaggregate(List<KinesisClientRecord> records, String startingHashKey, String endingHashKey) {
        return this.deaggregate(records, new BigInteger(startingHashKey), new BigInteger(endingHashKey));
    }

    public List<KinesisClientRecord> deaggregate(List<KinesisClientRecord> records, BigInteger startingHashKey, BigInteger endingHashKey) {
        ArrayList<KinesisClientRecord> result = new ArrayList<KinesisClientRecord>();
        byte[] magic = new byte[AGGREGATED_RECORD_MAGIC.length];
        byte[] digest = new byte[16];
        for (KinesisClientRecord r : records) {
            boolean isAggregated = true;
            long subSeqNum = 0L;
            ByteBuffer bb = r.data();
            if (bb.remaining() >= magic.length) {
                bb.get(magic);
            } else {
                isAggregated = false;
            }
            if (!Arrays.equals(AGGREGATED_RECORD_MAGIC, magic) || bb.remaining() <= 16) {
                isAggregated = false;
            }
            if (isAggregated) {
                int oldLimit = bb.limit();
                bb.limit(oldLimit - 16);
                byte[] messageData = new byte[bb.remaining()];
                bb.get(messageData);
                bb.limit(oldLimit);
                bb.get(digest);
                byte[] calculatedDigest = this.calculateTailCheck(messageData);
                if (!Arrays.equals(digest, calculatedDigest)) {
                    isAggregated = false;
                } else {
                    try {
                        Messages.AggregatedRecord ar = Messages.AggregatedRecord.parseFrom(messageData);
                        ProtocolStringList pks = ar.getPartitionKeyTableList();
                        ProtocolStringList ehks = ar.getExplicitHashKeyTableList();
                        long aat = r.approximateArrivalTimestamp() == null ? -1L : r.approximateArrivalTimestamp().toEpochMilli();
                        try {
                            int recordsInCurrRecord = 0;
                            for (Messages.Record mr : ar.getRecordsList()) {
                                BigInteger effectiveHashKey;
                                String explicitHashKey = null;
                                String partitionKey = (String)pks.get((int)mr.getPartitionKeyIndex());
                                if (mr.hasExplicitHashKeyIndex()) {
                                    explicitHashKey = (String)ehks.get((int)mr.getExplicitHashKeyIndex());
                                }
                                if ((effectiveHashKey = this.effectiveHashKey(partitionKey, explicitHashKey)).compareTo(startingHashKey) < 0 || effectiveHashKey.compareTo(endingHashKey) > 0) {
                                    for (int toRemove = 0; toRemove < recordsInCurrRecord; ++toRemove) {
                                        result.remove(result.size() - 1);
                                    }
                                    break;
                                }
                                ++recordsInCurrRecord;
                                KinesisClientRecord record = r.toBuilder().data(ByteBuffer.wrap(mr.getData().toByteArray())).partitionKey(partitionKey).explicitHashKey(explicitHashKey).build();
                                result.add(this.convertRecordToKinesisClientRecord(record, true, subSeqNum++, explicitHashKey));
                            }
                        }
                        catch (Exception e) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("Unexpected exception during deaggregation, record was:\n");
                            sb.append("PKS:\n");
                            for (String s : pks) {
                                sb.append(s).append("\n");
                            }
                            sb.append("EHKS: \n");
                            for (String s : ehks) {
                                sb.append(s).append("\n");
                            }
                            for (Messages.Record mr : ar.getRecordsList()) {
                                sb.append("Record: [hasEhk=").append(mr.hasExplicitHashKeyIndex()).append(", ").append("ehkIdx=").append(mr.getExplicitHashKeyIndex()).append(", ").append("pkIdx=").append(mr.getPartitionKeyIndex()).append(", ").append("dataLen=").append(mr.getData().toByteArray().length).append("]\n");
                            }
                            sb.append("Sequence number: ").append(r.sequenceNumber()).append("\n").append("Raw data: ").append(DatatypeConverter.printBase64Binary((byte[])messageData)).append("\n");
                            log.error(sb.toString(), (Throwable)e);
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        isAggregated = false;
                    }
                }
            }
            if (isAggregated) continue;
            bb.rewind();
            result.add(r);
        }
        return result;
    }

    protected byte[] calculateTailCheck(byte[] data) {
        return this.md5(data);
    }

    protected BigInteger effectiveHashKey(String partitionKey, String explicitHashKey) throws UnsupportedEncodingException {
        if (explicitHashKey == null) {
            return new BigInteger(1, this.md5(partitionKey.getBytes("UTF-8")));
        }
        return new BigInteger(explicitHashKey);
    }

    private byte[] md5(byte[] data) {
        try {
            MessageDigest d = MessageDigest.getInstance("MD5");
            return d.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public KinesisClientRecord convertRecordToKinesisClientRecord(@NonNull KinesisClientRecord record, boolean aggregated, long subSequenceNumber, String explicitHashKey) {
        if (record == null) {
            throw new NullPointerException("record");
        }
        return KinesisClientRecord.builder().data(record.data()).partitionKey(record.partitionKey()).approximateArrivalTimestamp(record.approximateArrivalTimestamp()).encryptionType(record.encryptionType()).sequenceNumber(record.sequenceNumber()).aggregated(aggregated).subSequenceNumber(subSequenceNumber).explicitHashKey(explicitHashKey).build();
    }
}

