/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval;

import com.amazonaws.services.schemaregistry.common.Schema;
import java.nio.ByteBuffer;
import java.time.Instant;
import software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.awssdk.services.kinesis.model.Record;

public class KinesisClientRecord {
    private final String sequenceNumber;
    private final Instant approximateArrivalTimestamp;
    private final ByteBuffer data;
    private final String partitionKey;
    private final EncryptionType encryptionType;
    private final long subSequenceNumber;
    private final String explicitHashKey;
    private final boolean aggregated;
    private final Schema schema;

    public static KinesisClientRecord fromRecord(Record record) {
        return KinesisClientRecord.builder().sequenceNumber(record.sequenceNumber()).approximateArrivalTimestamp(record.approximateArrivalTimestamp()).data(record.data().asByteBuffer()).partitionKey(record.partitionKey()).encryptionType(record.encryptionType()).build();
    }

    KinesisClientRecord(String sequenceNumber, Instant approximateArrivalTimestamp, ByteBuffer data, String partitionKey, EncryptionType encryptionType, long subSequenceNumber, String explicitHashKey, boolean aggregated, Schema schema) {
        this.sequenceNumber = sequenceNumber;
        this.approximateArrivalTimestamp = approximateArrivalTimestamp;
        this.data = data;
        this.partitionKey = partitionKey;
        this.encryptionType = encryptionType;
        this.subSequenceNumber = subSequenceNumber;
        this.explicitHashKey = explicitHashKey;
        this.aggregated = aggregated;
        this.schema = schema;
    }

    public static KinesisClientRecordBuilder builder() {
        return new KinesisClientRecordBuilder();
    }

    public KinesisClientRecordBuilder toBuilder() {
        return new KinesisClientRecordBuilder().sequenceNumber(this.sequenceNumber).approximateArrivalTimestamp(this.approximateArrivalTimestamp).data(this.data).partitionKey(this.partitionKey).encryptionType(this.encryptionType).subSequenceNumber(this.subSequenceNumber).explicitHashKey(this.explicitHashKey).aggregated(this.aggregated).schema(this.schema);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KinesisClientRecord)) {
            return false;
        }
        KinesisClientRecord other = (KinesisClientRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sequenceNumber = this.sequenceNumber();
        String other$sequenceNumber = other.sequenceNumber();
        if (this$sequenceNumber == null ? other$sequenceNumber != null : !this$sequenceNumber.equals(other$sequenceNumber)) {
            return false;
        }
        Instant this$approximateArrivalTimestamp = this.approximateArrivalTimestamp();
        Instant other$approximateArrivalTimestamp = other.approximateArrivalTimestamp();
        if (this$approximateArrivalTimestamp == null ? other$approximateArrivalTimestamp != null : !((Object)this$approximateArrivalTimestamp).equals(other$approximateArrivalTimestamp)) {
            return false;
        }
        ByteBuffer this$data = this.data();
        ByteBuffer other$data = other.data();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$partitionKey = this.partitionKey();
        String other$partitionKey = other.partitionKey();
        if (this$partitionKey == null ? other$partitionKey != null : !this$partitionKey.equals(other$partitionKey)) {
            return false;
        }
        EncryptionType this$encryptionType = this.encryptionType();
        EncryptionType other$encryptionType = other.encryptionType();
        if (this$encryptionType == null ? other$encryptionType != null : !this$encryptionType.equals(other$encryptionType)) {
            return false;
        }
        if (this.subSequenceNumber() != other.subSequenceNumber()) {
            return false;
        }
        String this$explicitHashKey = this.explicitHashKey();
        String other$explicitHashKey = other.explicitHashKey();
        if (this$explicitHashKey == null ? other$explicitHashKey != null : !this$explicitHashKey.equals(other$explicitHashKey)) {
            return false;
        }
        if (this.aggregated() != other.aggregated()) {
            return false;
        }
        Schema this$schema = this.schema();
        Schema other$schema = other.schema();
        return !(this$schema == null ? other$schema != null : !this$schema.equals(other$schema));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KinesisClientRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sequenceNumber = this.sequenceNumber();
        result = result * 59 + ($sequenceNumber == null ? 43 : $sequenceNumber.hashCode());
        Instant $approximateArrivalTimestamp = this.approximateArrivalTimestamp();
        result = result * 59 + ($approximateArrivalTimestamp == null ? 43 : ((Object)$approximateArrivalTimestamp).hashCode());
        ByteBuffer $data = this.data();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $partitionKey = this.partitionKey();
        result = result * 59 + ($partitionKey == null ? 43 : $partitionKey.hashCode());
        EncryptionType $encryptionType = this.encryptionType();
        result = result * 59 + ($encryptionType == null ? 43 : $encryptionType.hashCode());
        long $subSequenceNumber = this.subSequenceNumber();
        result = result * 59 + (int)($subSequenceNumber >>> 32 ^ $subSequenceNumber);
        String $explicitHashKey = this.explicitHashKey();
        result = result * 59 + ($explicitHashKey == null ? 43 : $explicitHashKey.hashCode());
        result = result * 59 + (this.aggregated() ? 79 : 97);
        Schema $schema = this.schema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        return result;
    }

    public String toString() {
        return "KinesisClientRecord(sequenceNumber=" + this.sequenceNumber() + ", approximateArrivalTimestamp=" + this.approximateArrivalTimestamp() + ", data=" + this.data() + ", partitionKey=" + this.partitionKey() + ", encryptionType=" + this.encryptionType() + ", subSequenceNumber=" + this.subSequenceNumber() + ", explicitHashKey=" + this.explicitHashKey() + ", aggregated=" + this.aggregated() + ", schema=" + this.schema() + ")";
    }

    public String sequenceNumber() {
        return this.sequenceNumber;
    }

    public Instant approximateArrivalTimestamp() {
        return this.approximateArrivalTimestamp;
    }

    public ByteBuffer data() {
        return this.data;
    }

    public String partitionKey() {
        return this.partitionKey;
    }

    public EncryptionType encryptionType() {
        return this.encryptionType;
    }

    public long subSequenceNumber() {
        return this.subSequenceNumber;
    }

    public String explicitHashKey() {
        return this.explicitHashKey;
    }

    public boolean aggregated() {
        return this.aggregated;
    }

    public Schema schema() {
        return this.schema;
    }

    public static class KinesisClientRecordBuilder {
        private String sequenceNumber;
        private Instant approximateArrivalTimestamp;
        private ByteBuffer data;
        private String partitionKey;
        private EncryptionType encryptionType;
        private long subSequenceNumber;
        private String explicitHashKey;
        private boolean aggregated;
        private Schema schema;

        KinesisClientRecordBuilder() {
        }

        public KinesisClientRecordBuilder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public KinesisClientRecordBuilder approximateArrivalTimestamp(Instant approximateArrivalTimestamp) {
            this.approximateArrivalTimestamp = approximateArrivalTimestamp;
            return this;
        }

        public KinesisClientRecordBuilder data(ByteBuffer data) {
            this.data = data;
            return this;
        }

        public KinesisClientRecordBuilder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public KinesisClientRecordBuilder encryptionType(EncryptionType encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        public KinesisClientRecordBuilder subSequenceNumber(long subSequenceNumber) {
            this.subSequenceNumber = subSequenceNumber;
            return this;
        }

        public KinesisClientRecordBuilder explicitHashKey(String explicitHashKey) {
            this.explicitHashKey = explicitHashKey;
            return this;
        }

        public KinesisClientRecordBuilder aggregated(boolean aggregated) {
            this.aggregated = aggregated;
            return this;
        }

        public KinesisClientRecordBuilder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public KinesisClientRecord build() {
            return new KinesisClientRecord(this.sequenceNumber, this.approximateArrivalTimestamp, this.data, this.partitionKey, this.encryptionType, this.subSequenceNumber, this.explicitHashKey, this.aggregated, this.schema);
        }

        public String toString() {
            return "KinesisClientRecord.KinesisClientRecordBuilder(sequenceNumber=" + this.sequenceNumber + ", approximateArrivalTimestamp=" + this.approximateArrivalTimestamp + ", data=" + this.data + ", partitionKey=" + this.partitionKey + ", encryptionType=" + this.encryptionType + ", subSequenceNumber=" + this.subSequenceNumber + ", explicitHashKey=" + this.explicitHashKey + ", aggregated=" + this.aggregated + ", schema=" + this.schema + ")";
        }
    }
}

