/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval;

import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializer;
import lombok.NonNull;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.utils.Either;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.common.StreamConfig;
import software.amazon.kinesis.common.StreamIdentifier;
import software.amazon.kinesis.processor.MultiStreamTracker;
import software.amazon.kinesis.retrieval.RetrievalFactory;
import software.amazon.kinesis.retrieval.RetrievalSpecificConfig;
import software.amazon.kinesis.retrieval.fanout.FanOutConfig;
import software.amazon.kinesis.retrieval.polling.PollingConfig;

public class RetrievalConfig {
    public static final String KINESIS_CLIENT_LIB_USER_AGENT = "amazon-kinesis-client-library-java";
    public static final String KINESIS_CLIENT_LIB_USER_AGENT_VERSION = "2.3.3";
    @NonNull
    private final KinesisAsyncClient kinesisClient;
    @NonNull
    private final String applicationName;
    private GlueSchemaRegistryDeserializer glueSchemaRegistryDeserializer = null;
    private Either<MultiStreamTracker, StreamConfig> appStreamTracker;
    private long listShardsBackoffTimeInMillis = 1500L;
    private int maxListShardsRetryAttempts = 50;
    private InitialPositionInStreamExtended initialPositionInStreamExtended = InitialPositionInStreamExtended.newInitialPosition(InitialPositionInStream.LATEST);
    private RetrievalSpecificConfig retrievalSpecificConfig;
    private RetrievalFactory retrievalFactory;

    public RetrievalConfig(@NonNull KinesisAsyncClient kinesisAsyncClient, @NonNull String streamName, @NonNull String applicationName) {
        if (kinesisAsyncClient == null) {
            throw new NullPointerException("kinesisAsyncClient");
        }
        if (streamName == null) {
            throw new NullPointerException("streamName");
        }
        if (applicationName == null) {
            throw new NullPointerException("applicationName");
        }
        this.kinesisClient = kinesisAsyncClient;
        this.appStreamTracker = Either.right((Object)new StreamConfig(StreamIdentifier.singleStreamInstance(streamName), this.initialPositionInStreamExtended));
        this.applicationName = applicationName;
    }

    public RetrievalConfig(@NonNull KinesisAsyncClient kinesisAsyncClient, @NonNull MultiStreamTracker multiStreamTracker, @NonNull String applicationName) {
        if (kinesisAsyncClient == null) {
            throw new NullPointerException("kinesisAsyncClient");
        }
        if (multiStreamTracker == null) {
            throw new NullPointerException("multiStreamTracker");
        }
        if (applicationName == null) {
            throw new NullPointerException("applicationName");
        }
        this.kinesisClient = kinesisAsyncClient;
        this.appStreamTracker = Either.left((Object)multiStreamTracker);
        this.applicationName = applicationName;
    }

    public RetrievalConfig initialPositionInStreamExtended(InitialPositionInStreamExtended initialPositionInStreamExtended) {
        StreamConfig[] streamConfig = new StreamConfig[1];
        this.appStreamTracker.apply(multiStreamTracker -> {
            throw new IllegalArgumentException("Cannot set initialPositionInStreamExtended when multiStreamTracker is set");
        }, sc -> {
            streamConfig[0] = sc;
        });
        this.appStreamTracker = Either.right((Object)new StreamConfig(streamConfig[0].streamIdentifier(), initialPositionInStreamExtended));
        return this;
    }

    public RetrievalConfig retrievalSpecificConfig(RetrievalSpecificConfig retrievalSpecificConfig) {
        this.retrievalSpecificConfig = retrievalSpecificConfig;
        this.validateFanoutConfig();
        this.validatePollingConfig();
        return this;
    }

    public RetrievalFactory retrievalFactory() {
        if (this.retrievalFactory == null) {
            if (this.retrievalSpecificConfig == null) {
                this.retrievalSpecificConfig = new FanOutConfig(this.kinesisClient()).applicationName(this.applicationName());
                this.retrievalSpecificConfig = (RetrievalSpecificConfig)this.appStreamTracker.map(multiStreamTracker -> this.retrievalSpecificConfig, streamConfig -> ((FanOutConfig)this.retrievalSpecificConfig).streamName(streamConfig.streamIdentifier().streamName()));
            }
            this.retrievalFactory = this.retrievalSpecificConfig.retrievalFactory();
        }
        return this.retrievalFactory;
    }

    private void validateFanoutConfig() {
        boolean isInvalidFanoutConfig;
        boolean isFanoutConfig = this.retrievalSpecificConfig instanceof FanOutConfig;
        boolean bl = isInvalidFanoutConfig = isFanoutConfig && (Boolean)this.appStreamTracker.map(multiStreamTracker -> ((FanOutConfig)this.retrievalSpecificConfig).consumerArn() != null || ((FanOutConfig)this.retrievalSpecificConfig).streamName() != null, streamConfig -> streamConfig.streamIdentifier() == null || streamConfig.streamIdentifier().streamName() == null) != false;
        if (isInvalidFanoutConfig) {
            throw new IllegalArgumentException("Invalid config: Either in multi-stream mode with streamName/consumerArn configured or in single-stream mode with no streamName configured");
        }
    }

    private void validatePollingConfig() {
        boolean isInvalidPollingConfig;
        boolean isPollingConfig = this.retrievalSpecificConfig instanceof PollingConfig;
        boolean bl = isInvalidPollingConfig = isPollingConfig && (Boolean)this.appStreamTracker.map(multiStreamTracker -> ((PollingConfig)this.retrievalSpecificConfig).streamName() != null, streamConfig -> streamConfig.streamIdentifier() == null || streamConfig.streamIdentifier().streamName() == null) != false;
        if (isInvalidPollingConfig) {
            throw new IllegalArgumentException("Invalid config: Either in multi-stream mode with streamName configured or in single-stream mode with no streamName configured");
        }
    }

    @NonNull
    public KinesisAsyncClient kinesisClient() {
        return this.kinesisClient;
    }

    @NonNull
    public String applicationName() {
        return this.applicationName;
    }

    public GlueSchemaRegistryDeserializer glueSchemaRegistryDeserializer() {
        return this.glueSchemaRegistryDeserializer;
    }

    public Either<MultiStreamTracker, StreamConfig> appStreamTracker() {
        return this.appStreamTracker;
    }

    public long listShardsBackoffTimeInMillis() {
        return this.listShardsBackoffTimeInMillis;
    }

    public int maxListShardsRetryAttempts() {
        return this.maxListShardsRetryAttempts;
    }

    public InitialPositionInStreamExtended initialPositionInStreamExtended() {
        return this.initialPositionInStreamExtended;
    }

    public RetrievalSpecificConfig retrievalSpecificConfig() {
        return this.retrievalSpecificConfig;
    }

    public RetrievalConfig glueSchemaRegistryDeserializer(GlueSchemaRegistryDeserializer glueSchemaRegistryDeserializer) {
        this.glueSchemaRegistryDeserializer = glueSchemaRegistryDeserializer;
        return this;
    }

    public RetrievalConfig appStreamTracker(Either<MultiStreamTracker, StreamConfig> appStreamTracker) {
        this.appStreamTracker = appStreamTracker;
        return this;
    }

    public RetrievalConfig listShardsBackoffTimeInMillis(long listShardsBackoffTimeInMillis) {
        this.listShardsBackoffTimeInMillis = listShardsBackoffTimeInMillis;
        return this;
    }

    public RetrievalConfig maxListShardsRetryAttempts(int maxListShardsRetryAttempts) {
        this.maxListShardsRetryAttempts = maxListShardsRetryAttempts;
        return this;
    }

    public RetrievalConfig retrievalFactory(RetrievalFactory retrievalFactory) {
        this.retrievalFactory = retrievalFactory;
        return this;
    }

    public String toString() {
        return "RetrievalConfig(kinesisClient=" + this.kinesisClient() + ", applicationName=" + this.applicationName() + ", glueSchemaRegistryDeserializer=" + this.glueSchemaRegistryDeserializer() + ", appStreamTracker=" + this.appStreamTracker() + ", listShardsBackoffTimeInMillis=" + this.listShardsBackoffTimeInMillis() + ", maxListShardsRetryAttempts=" + this.maxListShardsRetryAttempts() + ", initialPositionInStreamExtended=" + this.initialPositionInStreamExtended() + ", retrievalSpecificConfig=" + this.retrievalSpecificConfig() + ", retrievalFactory=" + this.retrievalFactory() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetrievalConfig)) {
            return false;
        }
        RetrievalConfig other = (RetrievalConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KinesisAsyncClient this$kinesisClient = this.kinesisClient();
        KinesisAsyncClient other$kinesisClient = other.kinesisClient();
        if (this$kinesisClient == null ? other$kinesisClient != null : !this$kinesisClient.equals(other$kinesisClient)) {
            return false;
        }
        String this$applicationName = this.applicationName();
        String other$applicationName = other.applicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        GlueSchemaRegistryDeserializer this$glueSchemaRegistryDeserializer = this.glueSchemaRegistryDeserializer();
        GlueSchemaRegistryDeserializer other$glueSchemaRegistryDeserializer = other.glueSchemaRegistryDeserializer();
        if (this$glueSchemaRegistryDeserializer == null ? other$glueSchemaRegistryDeserializer != null : !this$glueSchemaRegistryDeserializer.equals(other$glueSchemaRegistryDeserializer)) {
            return false;
        }
        Either<MultiStreamTracker, StreamConfig> this$appStreamTracker = this.appStreamTracker();
        Either<MultiStreamTracker, StreamConfig> other$appStreamTracker = other.appStreamTracker();
        if (this$appStreamTracker == null ? other$appStreamTracker != null : !this$appStreamTracker.equals(other$appStreamTracker)) {
            return false;
        }
        if (this.listShardsBackoffTimeInMillis() != other.listShardsBackoffTimeInMillis()) {
            return false;
        }
        if (this.maxListShardsRetryAttempts() != other.maxListShardsRetryAttempts()) {
            return false;
        }
        InitialPositionInStreamExtended this$initialPositionInStreamExtended = this.initialPositionInStreamExtended();
        InitialPositionInStreamExtended other$initialPositionInStreamExtended = other.initialPositionInStreamExtended();
        if (this$initialPositionInStreamExtended == null ? other$initialPositionInStreamExtended != null : !((Object)this$initialPositionInStreamExtended).equals(other$initialPositionInStreamExtended)) {
            return false;
        }
        RetrievalSpecificConfig this$retrievalSpecificConfig = this.retrievalSpecificConfig();
        RetrievalSpecificConfig other$retrievalSpecificConfig = other.retrievalSpecificConfig();
        if (this$retrievalSpecificConfig == null ? other$retrievalSpecificConfig != null : !this$retrievalSpecificConfig.equals(other$retrievalSpecificConfig)) {
            return false;
        }
        RetrievalFactory this$retrievalFactory = this.retrievalFactory();
        RetrievalFactory other$retrievalFactory = other.retrievalFactory();
        return !(this$retrievalFactory == null ? other$retrievalFactory != null : !this$retrievalFactory.equals(other$retrievalFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RetrievalConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KinesisAsyncClient $kinesisClient = this.kinesisClient();
        result = result * 59 + ($kinesisClient == null ? 43 : $kinesisClient.hashCode());
        String $applicationName = this.applicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        GlueSchemaRegistryDeserializer $glueSchemaRegistryDeserializer = this.glueSchemaRegistryDeserializer();
        result = result * 59 + ($glueSchemaRegistryDeserializer == null ? 43 : $glueSchemaRegistryDeserializer.hashCode());
        Either<MultiStreamTracker, StreamConfig> $appStreamTracker = this.appStreamTracker();
        result = result * 59 + ($appStreamTracker == null ? 43 : $appStreamTracker.hashCode());
        long $listShardsBackoffTimeInMillis = this.listShardsBackoffTimeInMillis();
        result = result * 59 + (int)($listShardsBackoffTimeInMillis >>> 32 ^ $listShardsBackoffTimeInMillis);
        result = result * 59 + this.maxListShardsRetryAttempts();
        InitialPositionInStreamExtended $initialPositionInStreamExtended = this.initialPositionInStreamExtended();
        result = result * 59 + ($initialPositionInStreamExtended == null ? 43 : ((Object)$initialPositionInStreamExtended).hashCode());
        RetrievalSpecificConfig $retrievalSpecificConfig = this.retrievalSpecificConfig();
        result = result * 59 + ($retrievalSpecificConfig == null ? 43 : $retrievalSpecificConfig.hashCode());
        RetrievalFactory $retrievalFactory = this.retrievalFactory();
        result = result * 59 + ($retrievalFactory == null ? 43 : $retrievalFactory.hashCode());
        return result;
    }
}

