/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;

@KinesisClientInternalApi
public class DynamoUtils {
    public static AttributeValue createAttributeValue(Collection<String> collectionValue) {
        if (collectionValue == null || collectionValue.isEmpty()) {
            throw new IllegalArgumentException("Collection attributeValues cannot be null or empty.");
        }
        return (AttributeValue)AttributeValue.builder().ss(collectionValue).build();
    }

    public static AttributeValue createAttributeValue(byte[] byteBufferValue) {
        if (byteBufferValue == null) {
            throw new IllegalArgumentException("Byte buffer attributeValues cannot be null or empty.");
        }
        return (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])byteBufferValue)).build();
    }

    public static AttributeValue createAttributeValue(String stringValue) {
        if (stringValue == null || stringValue.isEmpty()) {
            throw new IllegalArgumentException("String attributeValues cannot be null or empty.");
        }
        return (AttributeValue)AttributeValue.builder().s(stringValue).build();
    }

    public static AttributeValue createAttributeValue(Long longValue) {
        if (longValue == null) {
            throw new IllegalArgumentException("Number AttributeValues cannot be null.");
        }
        return (AttributeValue)AttributeValue.builder().n(longValue.toString()).build();
    }

    public static byte[] safeGetByteArray(Map<String, AttributeValue> dynamoRecord, String key) {
        AttributeValue av = dynamoRecord.get(key);
        if (av == null) {
            return null;
        }
        return av.b().asByteArray();
    }

    public static Long safeGetLong(Map<String, AttributeValue> dynamoRecord, String key) {
        AttributeValue av = dynamoRecord.get(key);
        if (av == null) {
            return null;
        }
        return new Long(av.n());
    }

    public static String safeGetString(Map<String, AttributeValue> dynamoRecord, String key) {
        AttributeValue av = dynamoRecord.get(key);
        if (av == null) {
            return null;
        }
        return av.s();
    }

    public static List<String> safeGetSS(Map<String, AttributeValue> dynamoRecord, String key) {
        AttributeValue av = dynamoRecord.get(key);
        if (av == null) {
            return new ArrayList<String>();
        }
        return av.ss();
    }
}

