/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.model.ResourceNotFoundException;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.kinesis.common.StreamIdentifier;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.LeaseCoordinator;
import software.amazon.kinesis.leases.ShardInfo;
import software.amazon.kinesis.leases.UpdateField;
import software.amazon.kinesis.leases.exceptions.DependencyException;
import software.amazon.kinesis.leases.exceptions.InvalidStateException;
import software.amazon.kinesis.leases.exceptions.LeasePendingDeletion;
import software.amazon.kinesis.leases.exceptions.ProvisionedThroughputException;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.retrieval.AWSExceptionManager;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

public class LeaseCleanupManager {
    private static final Logger log = LoggerFactory.getLogger(LeaseCleanupManager.class);
    @NonNull
    private final LeaseCoordinator leaseCoordinator;
    @NonNull
    private final MetricsFactory metricsFactory;
    @NonNull
    private final ScheduledExecutorService deletionThreadPool;
    private final boolean cleanupLeasesUponShardCompletion;
    private final long leaseCleanupIntervalMillis;
    private final long completedLeaseCleanupIntervalMillis;
    private final long garbageLeaseCleanupIntervalMillis;
    private final Stopwatch completedLeaseStopwatch = Stopwatch.createUnstarted();
    private final Stopwatch garbageLeaseStopwatch = Stopwatch.createUnstarted();
    private final Queue<LeasePendingDeletion> deletionQueue = new ConcurrentLinkedQueue<LeasePendingDeletion>();
    private static final long INITIAL_DELAY = 0L;
    private volatile boolean isRunning = false;

    public void start() {
        if (!this.isRunning) {
            log.info("Starting lease cleanup thread.");
            this.completedLeaseStopwatch.reset().start();
            this.garbageLeaseStopwatch.reset().start();
            this.deletionThreadPool.scheduleAtFixedRate(new LeaseCleanupThread(), 0L, this.leaseCleanupIntervalMillis, TimeUnit.MILLISECONDS);
            this.isRunning = true;
        } else {
            log.info("Lease cleanup thread already running, no need to start.");
        }
    }

    public void enqueueForDeletion(LeasePendingDeletion leasePendingDeletion) {
        Lease lease = leasePendingDeletion.lease();
        if (lease == null) {
            log.warn("Cannot enqueue lease {} for deferred deletion - instance doesn't hold the lease for that shard.", (Object)lease.leaseKey());
        } else {
            log.debug("Enqueuing lease {} for deferred deletion.", (Object)lease.leaseKey());
            if (!this.deletionQueue.add(leasePendingDeletion)) {
                log.warn("Unable to enqueue lease {} for deletion.", (Object)lease.leaseKey());
            }
        }
    }

    public boolean isEnqueuedForDeletion(LeasePendingDeletion leasePendingDeletion) {
        return this.deletionQueue.contains(leasePendingDeletion);
    }

    private int leasesPendingDeletion() {
        return this.deletionQueue.size();
    }

    private boolean timeToCheckForCompletedShard() {
        return this.completedLeaseStopwatch.elapsed(TimeUnit.MILLISECONDS) >= this.completedLeaseCleanupIntervalMillis;
    }

    private boolean timeToCheckForGarbageShard() {
        return this.garbageLeaseStopwatch.elapsed(TimeUnit.MILLISECONDS) >= this.garbageLeaseCleanupIntervalMillis;
    }

    public LeaseCleanupResult cleanupLease(LeasePendingDeletion leasePendingDeletion, boolean timeToCheckForCompletedShard, boolean timeToCheckForGarbageShard) throws TimeoutException, InterruptedException, DependencyException, ProvisionedThroughputException, InvalidStateException {
        boolean wasResourceNotFound;
        boolean wereChildShardsPresent;
        boolean cleanedUpGarbageLease;
        boolean cleanedUpCompletedLease;
        block17: {
            Lease lease = leasePendingDeletion.lease();
            ShardInfo shardInfo = leasePendingDeletion.shardInfo();
            StreamIdentifier streamIdentifier = leasePendingDeletion.streamIdentifier();
            AWSExceptionManager exceptionManager = this.createExceptionManager();
            cleanedUpCompletedLease = false;
            cleanedUpGarbageLease = false;
            boolean alreadyCheckedForGarbageCollection = false;
            wereChildShardsPresent = false;
            wasResourceNotFound = false;
            try {
                if (this.cleanupLeasesUponShardCompletion && timeToCheckForCompletedShard) {
                    Lease leaseFromDDB = this.leaseCoordinator.leaseRefresher().getLease(lease.leaseKey());
                    if (leaseFromDDB != null) {
                        Set<String> childShardKeys = leaseFromDDB.childShardIds();
                        if (CollectionUtils.isNullOrEmpty(childShardKeys)) {
                            try {
                                childShardKeys = leasePendingDeletion.getChildShardsFromService();
                                if (CollectionUtils.isNullOrEmpty(childShardKeys)) {
                                    log.error("No child shards returned from service for shard {} for {} while cleaning up lease.", (Object)shardInfo.shardId(), (Object)streamIdentifier.streamName());
                                }
                                wereChildShardsPresent = true;
                                this.updateLeaseWithChildShards(leasePendingDeletion, childShardKeys);
                            }
                            catch (ExecutionException e) {
                                throw exceptionManager.apply(e.getCause());
                            }
                            finally {
                                alreadyCheckedForGarbageCollection = true;
                            }
                        } else {
                            wereChildShardsPresent = true;
                        }
                        try {
                            cleanedUpCompletedLease = this.cleanupLeaseForCompletedShard(lease, shardInfo, childShardKeys);
                        }
                        catch (Exception e) {
                            log.warn("Unable to cleanup lease for shard {} in {}", new Object[]{shardInfo.shardId(), streamIdentifier.streamName(), e});
                        }
                    } else {
                        log.info("Lease not present in lease table while cleaning the shard {} of {}", (Object)shardInfo.shardId(), (Object)streamIdentifier.streamName());
                        cleanedUpCompletedLease = true;
                    }
                }
                if (alreadyCheckedForGarbageCollection || !timeToCheckForGarbageShard) break block17;
                try {
                    wereChildShardsPresent = !CollectionUtils.isNullOrEmpty(leasePendingDeletion.getChildShardsFromService());
                }
                catch (ExecutionException e) {
                    throw exceptionManager.apply(e.getCause());
                }
            }
            catch (ResourceNotFoundException e) {
                wasResourceNotFound = true;
                cleanedUpGarbageLease = this.cleanupLeaseForGarbageShard(lease, e);
            }
        }
        return new LeaseCleanupResult(cleanedUpCompletedLease, cleanedUpGarbageLease, wereChildShardsPresent, wasResourceNotFound);
    }

    private boolean cleanupLeaseForGarbageShard(Lease lease, Throwable e) throws DependencyException, ProvisionedThroughputException, InvalidStateException {
        log.warn("Deleting lease {} as it is not present in the stream.", (Object)lease, (Object)e);
        this.leaseCoordinator.leaseRefresher().deleteLease(lease);
        return true;
    }

    private boolean allParentShardLeasesDeleted(Lease lease, ShardInfo shardInfo) throws DependencyException, ProvisionedThroughputException, InvalidStateException {
        for (String parentShard : lease.parentShardIds()) {
            Lease parentLease = this.leaseCoordinator.leaseRefresher().getLease(ShardInfo.getLeaseKey(shardInfo, parentShard));
            if (parentLease == null) continue;
            log.warn("Lease {} has a parent lease {} which is still present in the lease table, skipping deletion for this lease.", (Object)lease, (Object)parentLease);
            return false;
        }
        return true;
    }

    private boolean cleanupLeaseForCompletedShard(Lease lease, ShardInfo shardInfo, Set<String> childShardKeys) throws DependencyException, ProvisionedThroughputException, InvalidStateException, IllegalStateException {
        HashSet<String> processedChildShardLeaseKeys = new HashSet<String>();
        Set childShardLeaseKeys = childShardKeys.stream().map(ck -> ShardInfo.getLeaseKey(shardInfo, ck)).collect(Collectors.toSet());
        for (String childShardLeaseKey : childShardLeaseKeys) {
            Lease childShardLease = Optional.ofNullable(this.leaseCoordinator.leaseRefresher().getLease(childShardLeaseKey)).orElseThrow(() -> new IllegalStateException("Child lease " + childShardLeaseKey + " for completed shard not found in lease table - not cleaning up lease " + lease));
            if (childShardLease.checkpoint().equals(ExtendedSequenceNumber.TRIM_HORIZON) || childShardLease.checkpoint().equals(ExtendedSequenceNumber.AT_TIMESTAMP)) continue;
            processedChildShardLeaseKeys.add(childShardLease.leaseKey());
        }
        if (!this.allParentShardLeasesDeleted(lease, shardInfo) || !Objects.equals(childShardLeaseKeys, processedChildShardLeaseKeys)) {
            return false;
        }
        log.info("Deleting lease {} as it has been completely processed and processing of child shard(s) has begun.", (Object)lease);
        this.leaseCoordinator.leaseRefresher().deleteLease(lease);
        return true;
    }

    private void updateLeaseWithChildShards(LeasePendingDeletion leasePendingDeletion, Set<String> childShardKeys) throws DependencyException, ProvisionedThroughputException, InvalidStateException {
        Lease updatedLease = leasePendingDeletion.lease();
        updatedLease.childShardIds(childShardKeys);
        this.leaseCoordinator.leaseRefresher().updateLeaseWithMetaInfo(updatedLease, UpdateField.CHILD_SHARDS);
    }

    private AWSExceptionManager createExceptionManager() {
        AWSExceptionManager exceptionManager = new AWSExceptionManager();
        exceptionManager.add(ResourceNotFoundException.class, t -> t);
        return exceptionManager;
    }

    @VisibleForTesting
    void cleanupLeases() {
        log.info("Number of pending leases to clean before the scan : {}", (Object)this.leasesPendingDeletion());
        if (this.deletionQueue.isEmpty()) {
            log.debug("No leases pending deletion.");
        } else if (this.timeToCheckForCompletedShard() | this.timeToCheckForGarbageShard()) {
            ConcurrentLinkedQueue<LeasePendingDeletion> failedDeletions = new ConcurrentLinkedQueue<LeasePendingDeletion>();
            boolean completedLeaseCleanedUp = false;
            boolean garbageLeaseCleanedUp = false;
            log.debug("Attempting to clean up {} lease(s).", (Object)this.deletionQueue.size());
            while (!this.deletionQueue.isEmpty()) {
                LeasePendingDeletion leasePendingDeletion = this.deletionQueue.poll();
                String leaseKey = leasePendingDeletion.lease().leaseKey();
                StreamIdentifier streamIdentifier = leasePendingDeletion.streamIdentifier();
                boolean deletionSucceeded = false;
                try {
                    LeaseCleanupResult leaseCleanupResult = this.cleanupLease(leasePendingDeletion, this.timeToCheckForCompletedShard(), this.timeToCheckForGarbageShard());
                    completedLeaseCleanedUp |= leaseCleanupResult.cleanedUpCompletedLease();
                    garbageLeaseCleanedUp |= leaseCleanupResult.cleanedUpGarbageLease();
                    if (leaseCleanupResult.leaseCleanedUp()) {
                        log.info("Successfully cleaned up lease {} for {} due to {}", new Object[]{leaseKey, streamIdentifier, leaseCleanupResult});
                        deletionSucceeded = true;
                    } else {
                        log.warn("Unable to clean up lease {} for {} due to {}", new Object[]{leaseKey, streamIdentifier, leaseCleanupResult});
                    }
                }
                catch (Exception e) {
                    log.error("Failed to cleanup lease {} for {}. Will re-enqueue for deletion and retry on next scheduled execution.", new Object[]{leaseKey, streamIdentifier, e});
                }
                if (deletionSucceeded) continue;
                log.debug("Did not cleanup lease {} for {}. Re-enqueueing for deletion.", (Object)leaseKey, (Object)streamIdentifier);
                failedDeletions.add(leasePendingDeletion);
            }
            if (completedLeaseCleanedUp) {
                log.debug("At least one completed lease was cleaned up - restarting interval");
                this.completedLeaseStopwatch.reset().start();
            }
            if (garbageLeaseCleanedUp) {
                log.debug("At least one garbage lease was cleaned up - restarting interval");
                this.garbageLeaseStopwatch.reset().start();
            }
            this.deletionQueue.addAll(failedDeletions);
            log.info("Number of pending leases to clean after the scan : {}", (Object)this.leasesPendingDeletion());
        }
    }

    public LeaseCleanupManager(@NonNull LeaseCoordinator leaseCoordinator, @NonNull MetricsFactory metricsFactory, @NonNull ScheduledExecutorService deletionThreadPool, boolean cleanupLeasesUponShardCompletion, long leaseCleanupIntervalMillis, long completedLeaseCleanupIntervalMillis, long garbageLeaseCleanupIntervalMillis) {
        if (leaseCoordinator == null) {
            throw new NullPointerException("leaseCoordinator");
        }
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        if (deletionThreadPool == null) {
            throw new NullPointerException("deletionThreadPool");
        }
        this.leaseCoordinator = leaseCoordinator;
        this.metricsFactory = metricsFactory;
        this.deletionThreadPool = deletionThreadPool;
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        this.leaseCleanupIntervalMillis = leaseCleanupIntervalMillis;
        this.completedLeaseCleanupIntervalMillis = completedLeaseCleanupIntervalMillis;
        this.garbageLeaseCleanupIntervalMillis = garbageLeaseCleanupIntervalMillis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeaseCleanupManager)) {
            return false;
        }
        LeaseCleanupManager other = (LeaseCleanupManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LeaseCoordinator this$leaseCoordinator = this.leaseCoordinator;
        LeaseCoordinator other$leaseCoordinator = other.leaseCoordinator;
        if (this$leaseCoordinator == null ? other$leaseCoordinator != null : !this$leaseCoordinator.equals(other$leaseCoordinator)) {
            return false;
        }
        MetricsFactory this$metricsFactory = this.metricsFactory;
        MetricsFactory other$metricsFactory = other.metricsFactory;
        if (this$metricsFactory == null ? other$metricsFactory != null : !this$metricsFactory.equals(other$metricsFactory)) {
            return false;
        }
        ScheduledExecutorService this$deletionThreadPool = this.deletionThreadPool;
        ScheduledExecutorService other$deletionThreadPool = other.deletionThreadPool;
        if (this$deletionThreadPool == null ? other$deletionThreadPool != null : !this$deletionThreadPool.equals(other$deletionThreadPool)) {
            return false;
        }
        if (this.cleanupLeasesUponShardCompletion != other.cleanupLeasesUponShardCompletion) {
            return false;
        }
        if (this.leaseCleanupIntervalMillis != other.leaseCleanupIntervalMillis) {
            return false;
        }
        if (this.completedLeaseCleanupIntervalMillis != other.completedLeaseCleanupIntervalMillis) {
            return false;
        }
        if (this.garbageLeaseCleanupIntervalMillis != other.garbageLeaseCleanupIntervalMillis) {
            return false;
        }
        Stopwatch this$completedLeaseStopwatch = this.completedLeaseStopwatch;
        Stopwatch other$completedLeaseStopwatch = other.completedLeaseStopwatch;
        if (this$completedLeaseStopwatch == null ? other$completedLeaseStopwatch != null : !this$completedLeaseStopwatch.equals(other$completedLeaseStopwatch)) {
            return false;
        }
        Stopwatch this$garbageLeaseStopwatch = this.garbageLeaseStopwatch;
        Stopwatch other$garbageLeaseStopwatch = other.garbageLeaseStopwatch;
        if (this$garbageLeaseStopwatch == null ? other$garbageLeaseStopwatch != null : !this$garbageLeaseStopwatch.equals(other$garbageLeaseStopwatch)) {
            return false;
        }
        Queue<LeasePendingDeletion> this$deletionQueue = this.deletionQueue;
        Queue<LeasePendingDeletion> other$deletionQueue = other.deletionQueue;
        if (this$deletionQueue == null ? other$deletionQueue != null : !this$deletionQueue.equals(other$deletionQueue)) {
            return false;
        }
        return this.isRunning() == other.isRunning();
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeaseCleanupManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LeaseCoordinator $leaseCoordinator = this.leaseCoordinator;
        result = result * 59 + ($leaseCoordinator == null ? 43 : $leaseCoordinator.hashCode());
        MetricsFactory $metricsFactory = this.metricsFactory;
        result = result * 59 + ($metricsFactory == null ? 43 : $metricsFactory.hashCode());
        ScheduledExecutorService $deletionThreadPool = this.deletionThreadPool;
        result = result * 59 + ($deletionThreadPool == null ? 43 : $deletionThreadPool.hashCode());
        result = result * 59 + (this.cleanupLeasesUponShardCompletion ? 79 : 97);
        long $leaseCleanupIntervalMillis = this.leaseCleanupIntervalMillis;
        result = result * 59 + (int)($leaseCleanupIntervalMillis >>> 32 ^ $leaseCleanupIntervalMillis);
        long $completedLeaseCleanupIntervalMillis = this.completedLeaseCleanupIntervalMillis;
        result = result * 59 + (int)($completedLeaseCleanupIntervalMillis >>> 32 ^ $completedLeaseCleanupIntervalMillis);
        long $garbageLeaseCleanupIntervalMillis = this.garbageLeaseCleanupIntervalMillis;
        result = result * 59 + (int)($garbageLeaseCleanupIntervalMillis >>> 32 ^ $garbageLeaseCleanupIntervalMillis);
        Stopwatch $completedLeaseStopwatch = this.completedLeaseStopwatch;
        result = result * 59 + ($completedLeaseStopwatch == null ? 43 : $completedLeaseStopwatch.hashCode());
        Stopwatch $garbageLeaseStopwatch = this.garbageLeaseStopwatch;
        result = result * 59 + ($garbageLeaseStopwatch == null ? 43 : $garbageLeaseStopwatch.hashCode());
        Queue<LeasePendingDeletion> $deletionQueue = this.deletionQueue;
        result = result * 59 + ($deletionQueue == null ? 43 : $deletionQueue.hashCode());
        result = result * 59 + (this.isRunning() ? 79 : 97);
        return result;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public static final class LeaseCleanupResult {
        private final boolean cleanedUpCompletedLease;
        private final boolean cleanedUpGarbageLease;
        private final boolean wereChildShardsPresent;
        private final boolean wasResourceNotFound;

        public boolean leaseCleanedUp() {
            return this.cleanedUpCompletedLease | this.cleanedUpGarbageLease;
        }

        public LeaseCleanupResult(boolean cleanedUpCompletedLease, boolean cleanedUpGarbageLease, boolean wereChildShardsPresent, boolean wasResourceNotFound) {
            this.cleanedUpCompletedLease = cleanedUpCompletedLease;
            this.cleanedUpGarbageLease = cleanedUpGarbageLease;
            this.wereChildShardsPresent = wereChildShardsPresent;
            this.wasResourceNotFound = wasResourceNotFound;
        }

        public boolean cleanedUpCompletedLease() {
            return this.cleanedUpCompletedLease;
        }

        public boolean cleanedUpGarbageLease() {
            return this.cleanedUpGarbageLease;
        }

        public boolean wereChildShardsPresent() {
            return this.wereChildShardsPresent;
        }

        public boolean wasResourceNotFound() {
            return this.wasResourceNotFound;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LeaseCleanupResult)) {
                return false;
            }
            LeaseCleanupResult other = (LeaseCleanupResult)o;
            if (this.cleanedUpCompletedLease() != other.cleanedUpCompletedLease()) {
                return false;
            }
            if (this.cleanedUpGarbageLease() != other.cleanedUpGarbageLease()) {
                return false;
            }
            if (this.wereChildShardsPresent() != other.wereChildShardsPresent()) {
                return false;
            }
            return this.wasResourceNotFound() == other.wasResourceNotFound();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.cleanedUpCompletedLease() ? 79 : 97);
            result = result * 59 + (this.cleanedUpGarbageLease() ? 79 : 97);
            result = result * 59 + (this.wereChildShardsPresent() ? 79 : 97);
            result = result * 59 + (this.wasResourceNotFound() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "LeaseCleanupManager.LeaseCleanupResult(cleanedUpCompletedLease=" + this.cleanedUpCompletedLease() + ", cleanedUpGarbageLease=" + this.cleanedUpGarbageLease() + ", wereChildShardsPresent=" + this.wereChildShardsPresent() + ", wasResourceNotFound=" + this.wasResourceNotFound() + ")";
        }
    }

    private class LeaseCleanupThread
    implements Runnable {
        private LeaseCleanupThread() {
        }

        @Override
        public void run() {
            LeaseCleanupManager.this.cleanupLeases();
        }
    }
}

