/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.common.LeaseCleanupConfig;
import software.amazon.kinesis.common.StreamConfig;
import software.amazon.kinesis.leases.HierarchicalShardSyncer;
import software.amazon.kinesis.leases.LeaseManagementFactory;
import software.amazon.kinesis.leases.LeaseSerializer;
import software.amazon.kinesis.leases.ShardDetector;
import software.amazon.kinesis.leases.dynamodb.DynamoDBLeaseManagementFactory;
import software.amazon.kinesis.leases.dynamodb.TableCreatorCallback;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.NullMetricsFactory;

public class LeaseManagementConfig {
    public static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofMinutes(1L);
    public static final long DEFAULT_LEASE_CLEANUP_INTERVAL_MILLIS = Duration.ofMinutes(1L).toMillis();
    public static final long DEFAULT_COMPLETED_LEASE_CLEANUP_INTERVAL_MILLIS = Duration.ofMinutes(5L).toMillis();
    public static final long DEFAULT_GARBAGE_LEASE_CLEANUP_INTERVAL_MILLIS = Duration.ofMinutes(30L).toMillis();
    public static final long DEFAULT_PERIODIC_SHARD_SYNC_INTERVAL_MILLIS = 120000L;
    public static final int DEFAULT_CONSECUTIVE_HOLES_FOR_TRIGGERING_LEASE_RECOVERY = 3;
    public static final LeaseCleanupConfig DEFAULT_LEASE_CLEANUP_CONFIG = LeaseCleanupConfig.builder().leaseCleanupIntervalMillis(DEFAULT_LEASE_CLEANUP_INTERVAL_MILLIS).completedLeaseCleanupIntervalMillis(DEFAULT_COMPLETED_LEASE_CLEANUP_INTERVAL_MILLIS).garbageLeaseCleanupIntervalMillis(DEFAULT_GARBAGE_LEASE_CLEANUP_INTERVAL_MILLIS).build();
    @NonNull
    private final String tableName;
    @NonNull
    private final DynamoDbAsyncClient dynamoDBClient;
    @NonNull
    private final KinesisAsyncClient kinesisClient;
    @NonNull
    private String streamName;
    @NonNull
    private final String workerIdentifier;
    private long failoverTimeMillis = 10000L;
    private long shardSyncIntervalMillis = 60000L;
    private boolean cleanupLeasesUponShardCompletion = true;
    private final LeaseCleanupConfig leaseCleanupConfig = DEFAULT_LEASE_CLEANUP_CONFIG;
    private int maxLeasesForWorker = Integer.MAX_VALUE;
    private int maxLeasesToStealAtOneTime = 1;
    private int initialLeaseTableReadCapacity = 10;
    private int initialLeaseTableWriteCapacity = 10;
    private Function<StreamConfig, ShardDetector> customShardDetectorProvider;
    private int maxLeaseRenewalThreads = 20;
    private boolean ignoreUnexpectedChildShards = false;
    private boolean consistentReads = false;
    private long listShardsBackoffTimeInMillis = 1500L;
    private int maxListShardsRetryAttempts = 50;
    public long epsilonMillis = 25L;
    private Duration dynamoDbRequestTimeout = DEFAULT_REQUEST_TIMEOUT;
    private BillingMode billingMode = BillingMode.PROVISIONED;
    private long leasesRecoveryAuditorExecutionFrequencyMillis = 120000L;
    private int leasesRecoveryAuditorInconsistencyConfidenceThreshold = 3;
    private InitialPositionInStreamExtended initialPositionInStream = InitialPositionInStreamExtended.newInitialPosition(InitialPositionInStream.TRIM_HORIZON);
    private int maxCacheMissesBeforeReload = 1000;
    private long listShardsCacheAllowedAgeInSeconds = 30L;
    private int cacheMissWarningModulus = 250;
    private MetricsFactory metricsFactory = new NullMetricsFactory();
    private ExecutorService executorService = new LeaseManagementThreadPool(new ThreadFactoryBuilder().setNameFormat("ShardSyncTaskManager-%04d").build());
    private TableCreatorCallback tableCreatorCallback = TableCreatorCallback.NOOP_TABLE_CREATOR_CALLBACK;
    private HierarchicalShardSyncer hierarchicalShardSyncer;
    private LeaseManagementFactory leaseManagementFactory;

    @Deprecated
    public LeaseManagementConfig(String tableName, DynamoDbAsyncClient dynamoDBClient, KinesisAsyncClient kinesisClient, String streamName, String workerIdentifier) {
        this.tableName = tableName;
        this.dynamoDBClient = dynamoDBClient;
        this.kinesisClient = kinesisClient;
        this.streamName = streamName;
        this.workerIdentifier = workerIdentifier;
    }

    public LeaseManagementConfig(String tableName, DynamoDbAsyncClient dynamoDBClient, KinesisAsyncClient kinesisClient, String workerIdentifier) {
        this.tableName = tableName;
        this.dynamoDBClient = dynamoDBClient;
        this.kinesisClient = kinesisClient;
        this.workerIdentifier = workerIdentifier;
    }

    @Deprecated
    public MetricsFactory metricsFactory() {
        return this.metricsFactory;
    }

    @Deprecated
    public LeaseManagementConfig metricsFactory(MetricsFactory metricsFactory) {
        this.metricsFactory = metricsFactory;
        return this;
    }

    private HierarchicalShardSyncer hierarchicalShardSyncer() {
        if (this.hierarchicalShardSyncer == null) {
            this.hierarchicalShardSyncer = new HierarchicalShardSyncer();
        }
        return this.hierarchicalShardSyncer;
    }

    @Deprecated
    public LeaseManagementFactory leaseManagementFactory() {
        if (this.leaseManagementFactory == null) {
            Validate.notEmpty((CharSequence)this.streamName(), (String)"Stream name is empty", (Object[])new Object[0]);
            this.leaseManagementFactory = new DynamoDBLeaseManagementFactory(this.kinesisClient(), this.streamName(), this.dynamoDBClient(), this.tableName(), this.workerIdentifier(), this.executorService(), this.initialPositionInStream(), this.failoverTimeMillis(), this.epsilonMillis(), this.maxLeasesForWorker(), this.maxLeasesToStealAtOneTime(), this.maxLeaseRenewalThreads(), this.cleanupLeasesUponShardCompletion(), this.ignoreUnexpectedChildShards(), this.shardSyncIntervalMillis(), this.consistentReads(), this.listShardsBackoffTimeInMillis(), this.maxListShardsRetryAttempts(), this.maxCacheMissesBeforeReload(), this.listShardsCacheAllowedAgeInSeconds(), this.cacheMissWarningModulus(), (long)this.initialLeaseTableReadCapacity(), this.initialLeaseTableWriteCapacity(), this.hierarchicalShardSyncer(), this.tableCreatorCallback(), this.dynamoDbRequestTimeout(), this.billingMode());
        }
        return this.leaseManagementFactory;
    }

    public LeaseManagementFactory leaseManagementFactory(LeaseSerializer leaseSerializer, boolean isMultiStreamingMode) {
        if (this.leaseManagementFactory == null) {
            this.leaseManagementFactory = new DynamoDBLeaseManagementFactory(this.kinesisClient(), this.dynamoDBClient(), this.tableName(), this.workerIdentifier(), this.executorService(), this.failoverTimeMillis(), this.epsilonMillis(), this.maxLeasesForWorker(), this.maxLeasesToStealAtOneTime(), this.maxLeaseRenewalThreads(), this.cleanupLeasesUponShardCompletion(), this.ignoreUnexpectedChildShards(), this.shardSyncIntervalMillis(), this.consistentReads(), this.listShardsBackoffTimeInMillis(), this.maxListShardsRetryAttempts(), this.maxCacheMissesBeforeReload(), this.listShardsCacheAllowedAgeInSeconds(), this.cacheMissWarningModulus(), this.initialLeaseTableReadCapacity(), this.initialLeaseTableWriteCapacity(), this.hierarchicalShardSyncer(), this.tableCreatorCallback(), this.dynamoDbRequestTimeout(), this.billingMode(), leaseSerializer, this.customShardDetectorProvider(), isMultiStreamingMode, this.leaseCleanupConfig());
        }
        return this.leaseManagementFactory;
    }

    public LeaseManagementConfig leaseManagementFactory(LeaseManagementFactory leaseManagementFactory) {
        this.leaseManagementFactory = leaseManagementFactory;
        return this;
    }

    @NonNull
    public String tableName() {
        return this.tableName;
    }

    @NonNull
    public DynamoDbAsyncClient dynamoDBClient() {
        return this.dynamoDBClient;
    }

    @NonNull
    public KinesisAsyncClient kinesisClient() {
        return this.kinesisClient;
    }

    @NonNull
    public String streamName() {
        return this.streamName;
    }

    @NonNull
    public String workerIdentifier() {
        return this.workerIdentifier;
    }

    public long failoverTimeMillis() {
        return this.failoverTimeMillis;
    }

    public long shardSyncIntervalMillis() {
        return this.shardSyncIntervalMillis;
    }

    public boolean cleanupLeasesUponShardCompletion() {
        return this.cleanupLeasesUponShardCompletion;
    }

    public LeaseCleanupConfig leaseCleanupConfig() {
        return this.leaseCleanupConfig;
    }

    public int maxLeasesForWorker() {
        return this.maxLeasesForWorker;
    }

    public int maxLeasesToStealAtOneTime() {
        return this.maxLeasesToStealAtOneTime;
    }

    public int initialLeaseTableReadCapacity() {
        return this.initialLeaseTableReadCapacity;
    }

    public int initialLeaseTableWriteCapacity() {
        return this.initialLeaseTableWriteCapacity;
    }

    public Function<StreamConfig, ShardDetector> customShardDetectorProvider() {
        return this.customShardDetectorProvider;
    }

    public int maxLeaseRenewalThreads() {
        return this.maxLeaseRenewalThreads;
    }

    public boolean ignoreUnexpectedChildShards() {
        return this.ignoreUnexpectedChildShards;
    }

    public boolean consistentReads() {
        return this.consistentReads;
    }

    public long listShardsBackoffTimeInMillis() {
        return this.listShardsBackoffTimeInMillis;
    }

    public int maxListShardsRetryAttempts() {
        return this.maxListShardsRetryAttempts;
    }

    public long epsilonMillis() {
        return this.epsilonMillis;
    }

    public Duration dynamoDbRequestTimeout() {
        return this.dynamoDbRequestTimeout;
    }

    public BillingMode billingMode() {
        return this.billingMode;
    }

    public long leasesRecoveryAuditorExecutionFrequencyMillis() {
        return this.leasesRecoveryAuditorExecutionFrequencyMillis;
    }

    public int leasesRecoveryAuditorInconsistencyConfidenceThreshold() {
        return this.leasesRecoveryAuditorInconsistencyConfidenceThreshold;
    }

    public InitialPositionInStreamExtended initialPositionInStream() {
        return this.initialPositionInStream;
    }

    public int maxCacheMissesBeforeReload() {
        return this.maxCacheMissesBeforeReload;
    }

    public long listShardsCacheAllowedAgeInSeconds() {
        return this.listShardsCacheAllowedAgeInSeconds;
    }

    public int cacheMissWarningModulus() {
        return this.cacheMissWarningModulus;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public TableCreatorCallback tableCreatorCallback() {
        return this.tableCreatorCallback;
    }

    public LeaseManagementConfig streamName(@NonNull String streamName) {
        if (streamName == null) {
            throw new NullPointerException("streamName");
        }
        this.streamName = streamName;
        return this;
    }

    public LeaseManagementConfig failoverTimeMillis(long failoverTimeMillis) {
        this.failoverTimeMillis = failoverTimeMillis;
        return this;
    }

    public LeaseManagementConfig shardSyncIntervalMillis(long shardSyncIntervalMillis) {
        this.shardSyncIntervalMillis = shardSyncIntervalMillis;
        return this;
    }

    public LeaseManagementConfig cleanupLeasesUponShardCompletion(boolean cleanupLeasesUponShardCompletion) {
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        return this;
    }

    public LeaseManagementConfig maxLeasesForWorker(int maxLeasesForWorker) {
        this.maxLeasesForWorker = maxLeasesForWorker;
        return this;
    }

    public LeaseManagementConfig maxLeasesToStealAtOneTime(int maxLeasesToStealAtOneTime) {
        this.maxLeasesToStealAtOneTime = maxLeasesToStealAtOneTime;
        return this;
    }

    public LeaseManagementConfig initialLeaseTableReadCapacity(int initialLeaseTableReadCapacity) {
        this.initialLeaseTableReadCapacity = initialLeaseTableReadCapacity;
        return this;
    }

    public LeaseManagementConfig initialLeaseTableWriteCapacity(int initialLeaseTableWriteCapacity) {
        this.initialLeaseTableWriteCapacity = initialLeaseTableWriteCapacity;
        return this;
    }

    public LeaseManagementConfig customShardDetectorProvider(Function<StreamConfig, ShardDetector> customShardDetectorProvider) {
        this.customShardDetectorProvider = customShardDetectorProvider;
        return this;
    }

    public LeaseManagementConfig maxLeaseRenewalThreads(int maxLeaseRenewalThreads) {
        this.maxLeaseRenewalThreads = maxLeaseRenewalThreads;
        return this;
    }

    public LeaseManagementConfig ignoreUnexpectedChildShards(boolean ignoreUnexpectedChildShards) {
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        return this;
    }

    public LeaseManagementConfig consistentReads(boolean consistentReads) {
        this.consistentReads = consistentReads;
        return this;
    }

    public LeaseManagementConfig listShardsBackoffTimeInMillis(long listShardsBackoffTimeInMillis) {
        this.listShardsBackoffTimeInMillis = listShardsBackoffTimeInMillis;
        return this;
    }

    public LeaseManagementConfig maxListShardsRetryAttempts(int maxListShardsRetryAttempts) {
        this.maxListShardsRetryAttempts = maxListShardsRetryAttempts;
        return this;
    }

    public LeaseManagementConfig epsilonMillis(long epsilonMillis) {
        this.epsilonMillis = epsilonMillis;
        return this;
    }

    public LeaseManagementConfig dynamoDbRequestTimeout(Duration dynamoDbRequestTimeout) {
        this.dynamoDbRequestTimeout = dynamoDbRequestTimeout;
        return this;
    }

    public LeaseManagementConfig billingMode(BillingMode billingMode) {
        this.billingMode = billingMode;
        return this;
    }

    public LeaseManagementConfig leasesRecoveryAuditorExecutionFrequencyMillis(long leasesRecoveryAuditorExecutionFrequencyMillis) {
        this.leasesRecoveryAuditorExecutionFrequencyMillis = leasesRecoveryAuditorExecutionFrequencyMillis;
        return this;
    }

    public LeaseManagementConfig leasesRecoveryAuditorInconsistencyConfidenceThreshold(int leasesRecoveryAuditorInconsistencyConfidenceThreshold) {
        this.leasesRecoveryAuditorInconsistencyConfidenceThreshold = leasesRecoveryAuditorInconsistencyConfidenceThreshold;
        return this;
    }

    public LeaseManagementConfig initialPositionInStream(InitialPositionInStreamExtended initialPositionInStream) {
        this.initialPositionInStream = initialPositionInStream;
        return this;
    }

    public LeaseManagementConfig maxCacheMissesBeforeReload(int maxCacheMissesBeforeReload) {
        this.maxCacheMissesBeforeReload = maxCacheMissesBeforeReload;
        return this;
    }

    public LeaseManagementConfig listShardsCacheAllowedAgeInSeconds(long listShardsCacheAllowedAgeInSeconds) {
        this.listShardsCacheAllowedAgeInSeconds = listShardsCacheAllowedAgeInSeconds;
        return this;
    }

    public LeaseManagementConfig cacheMissWarningModulus(int cacheMissWarningModulus) {
        this.cacheMissWarningModulus = cacheMissWarningModulus;
        return this;
    }

    public LeaseManagementConfig executorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public LeaseManagementConfig tableCreatorCallback(TableCreatorCallback tableCreatorCallback) {
        this.tableCreatorCallback = tableCreatorCallback;
        return this;
    }

    public LeaseManagementConfig hierarchicalShardSyncer(HierarchicalShardSyncer hierarchicalShardSyncer) {
        this.hierarchicalShardSyncer = hierarchicalShardSyncer;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeaseManagementConfig)) {
            return false;
        }
        LeaseManagementConfig other = (LeaseManagementConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tableName = this.tableName();
        String other$tableName = other.tableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        DynamoDbAsyncClient this$dynamoDBClient = this.dynamoDBClient();
        DynamoDbAsyncClient other$dynamoDBClient = other.dynamoDBClient();
        if (this$dynamoDBClient == null ? other$dynamoDBClient != null : !this$dynamoDBClient.equals(other$dynamoDBClient)) {
            return false;
        }
        KinesisAsyncClient this$kinesisClient = this.kinesisClient();
        KinesisAsyncClient other$kinesisClient = other.kinesisClient();
        if (this$kinesisClient == null ? other$kinesisClient != null : !this$kinesisClient.equals(other$kinesisClient)) {
            return false;
        }
        String this$streamName = this.streamName();
        String other$streamName = other.streamName();
        if (this$streamName == null ? other$streamName != null : !this$streamName.equals(other$streamName)) {
            return false;
        }
        String this$workerIdentifier = this.workerIdentifier();
        String other$workerIdentifier = other.workerIdentifier();
        if (this$workerIdentifier == null ? other$workerIdentifier != null : !this$workerIdentifier.equals(other$workerIdentifier)) {
            return false;
        }
        if (this.failoverTimeMillis() != other.failoverTimeMillis()) {
            return false;
        }
        if (this.shardSyncIntervalMillis() != other.shardSyncIntervalMillis()) {
            return false;
        }
        if (this.cleanupLeasesUponShardCompletion() != other.cleanupLeasesUponShardCompletion()) {
            return false;
        }
        LeaseCleanupConfig this$leaseCleanupConfig = this.leaseCleanupConfig();
        LeaseCleanupConfig other$leaseCleanupConfig = other.leaseCleanupConfig();
        if (this$leaseCleanupConfig == null ? other$leaseCleanupConfig != null : !this$leaseCleanupConfig.equals(other$leaseCleanupConfig)) {
            return false;
        }
        if (this.maxLeasesForWorker() != other.maxLeasesForWorker()) {
            return false;
        }
        if (this.maxLeasesToStealAtOneTime() != other.maxLeasesToStealAtOneTime()) {
            return false;
        }
        if (this.initialLeaseTableReadCapacity() != other.initialLeaseTableReadCapacity()) {
            return false;
        }
        if (this.initialLeaseTableWriteCapacity() != other.initialLeaseTableWriteCapacity()) {
            return false;
        }
        Function<StreamConfig, ShardDetector> this$customShardDetectorProvider = this.customShardDetectorProvider();
        Function<StreamConfig, ShardDetector> other$customShardDetectorProvider = other.customShardDetectorProvider();
        if (this$customShardDetectorProvider == null ? other$customShardDetectorProvider != null : !this$customShardDetectorProvider.equals(other$customShardDetectorProvider)) {
            return false;
        }
        if (this.maxLeaseRenewalThreads() != other.maxLeaseRenewalThreads()) {
            return false;
        }
        if (this.ignoreUnexpectedChildShards() != other.ignoreUnexpectedChildShards()) {
            return false;
        }
        if (this.consistentReads() != other.consistentReads()) {
            return false;
        }
        if (this.listShardsBackoffTimeInMillis() != other.listShardsBackoffTimeInMillis()) {
            return false;
        }
        if (this.maxListShardsRetryAttempts() != other.maxListShardsRetryAttempts()) {
            return false;
        }
        if (this.epsilonMillis() != other.epsilonMillis()) {
            return false;
        }
        Duration this$dynamoDbRequestTimeout = this.dynamoDbRequestTimeout();
        Duration other$dynamoDbRequestTimeout = other.dynamoDbRequestTimeout();
        if (this$dynamoDbRequestTimeout == null ? other$dynamoDbRequestTimeout != null : !((Object)this$dynamoDbRequestTimeout).equals(other$dynamoDbRequestTimeout)) {
            return false;
        }
        BillingMode this$billingMode = this.billingMode();
        BillingMode other$billingMode = other.billingMode();
        if (this$billingMode == null ? other$billingMode != null : !this$billingMode.equals(other$billingMode)) {
            return false;
        }
        if (this.leasesRecoveryAuditorExecutionFrequencyMillis() != other.leasesRecoveryAuditorExecutionFrequencyMillis()) {
            return false;
        }
        if (this.leasesRecoveryAuditorInconsistencyConfidenceThreshold() != other.leasesRecoveryAuditorInconsistencyConfidenceThreshold()) {
            return false;
        }
        InitialPositionInStreamExtended this$initialPositionInStream = this.initialPositionInStream();
        InitialPositionInStreamExtended other$initialPositionInStream = other.initialPositionInStream();
        if (this$initialPositionInStream == null ? other$initialPositionInStream != null : !((Object)this$initialPositionInStream).equals(other$initialPositionInStream)) {
            return false;
        }
        if (this.maxCacheMissesBeforeReload() != other.maxCacheMissesBeforeReload()) {
            return false;
        }
        if (this.listShardsCacheAllowedAgeInSeconds() != other.listShardsCacheAllowedAgeInSeconds()) {
            return false;
        }
        if (this.cacheMissWarningModulus() != other.cacheMissWarningModulus()) {
            return false;
        }
        MetricsFactory this$metricsFactory = this.metricsFactory();
        MetricsFactory other$metricsFactory = other.metricsFactory();
        if (this$metricsFactory == null ? other$metricsFactory != null : !this$metricsFactory.equals(other$metricsFactory)) {
            return false;
        }
        ExecutorService this$executorService = this.executorService();
        ExecutorService other$executorService = other.executorService();
        if (this$executorService == null ? other$executorService != null : !this$executorService.equals(other$executorService)) {
            return false;
        }
        TableCreatorCallback this$tableCreatorCallback = this.tableCreatorCallback();
        TableCreatorCallback other$tableCreatorCallback = other.tableCreatorCallback();
        if (this$tableCreatorCallback == null ? other$tableCreatorCallback != null : !this$tableCreatorCallback.equals(other$tableCreatorCallback)) {
            return false;
        }
        HierarchicalShardSyncer this$hierarchicalShardSyncer = this.hierarchicalShardSyncer();
        HierarchicalShardSyncer other$hierarchicalShardSyncer = other.hierarchicalShardSyncer();
        if (this$hierarchicalShardSyncer == null ? other$hierarchicalShardSyncer != null : !this$hierarchicalShardSyncer.equals(other$hierarchicalShardSyncer)) {
            return false;
        }
        LeaseManagementFactory this$leaseManagementFactory = this.leaseManagementFactory();
        LeaseManagementFactory other$leaseManagementFactory = other.leaseManagementFactory();
        return !(this$leaseManagementFactory == null ? other$leaseManagementFactory != null : !this$leaseManagementFactory.equals(other$leaseManagementFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeaseManagementConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableName = this.tableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        DynamoDbAsyncClient $dynamoDBClient = this.dynamoDBClient();
        result = result * 59 + ($dynamoDBClient == null ? 43 : $dynamoDBClient.hashCode());
        KinesisAsyncClient $kinesisClient = this.kinesisClient();
        result = result * 59 + ($kinesisClient == null ? 43 : $kinesisClient.hashCode());
        String $streamName = this.streamName();
        result = result * 59 + ($streamName == null ? 43 : $streamName.hashCode());
        String $workerIdentifier = this.workerIdentifier();
        result = result * 59 + ($workerIdentifier == null ? 43 : $workerIdentifier.hashCode());
        long $failoverTimeMillis = this.failoverTimeMillis();
        result = result * 59 + (int)($failoverTimeMillis >>> 32 ^ $failoverTimeMillis);
        long $shardSyncIntervalMillis = this.shardSyncIntervalMillis();
        result = result * 59 + (int)($shardSyncIntervalMillis >>> 32 ^ $shardSyncIntervalMillis);
        result = result * 59 + (this.cleanupLeasesUponShardCompletion() ? 79 : 97);
        LeaseCleanupConfig $leaseCleanupConfig = this.leaseCleanupConfig();
        result = result * 59 + ($leaseCleanupConfig == null ? 43 : $leaseCleanupConfig.hashCode());
        result = result * 59 + this.maxLeasesForWorker();
        result = result * 59 + this.maxLeasesToStealAtOneTime();
        result = result * 59 + this.initialLeaseTableReadCapacity();
        result = result * 59 + this.initialLeaseTableWriteCapacity();
        Function<StreamConfig, ShardDetector> $customShardDetectorProvider = this.customShardDetectorProvider();
        result = result * 59 + ($customShardDetectorProvider == null ? 43 : $customShardDetectorProvider.hashCode());
        result = result * 59 + this.maxLeaseRenewalThreads();
        result = result * 59 + (this.ignoreUnexpectedChildShards() ? 79 : 97);
        result = result * 59 + (this.consistentReads() ? 79 : 97);
        long $listShardsBackoffTimeInMillis = this.listShardsBackoffTimeInMillis();
        result = result * 59 + (int)($listShardsBackoffTimeInMillis >>> 32 ^ $listShardsBackoffTimeInMillis);
        result = result * 59 + this.maxListShardsRetryAttempts();
        long $epsilonMillis = this.epsilonMillis();
        result = result * 59 + (int)($epsilonMillis >>> 32 ^ $epsilonMillis);
        Duration $dynamoDbRequestTimeout = this.dynamoDbRequestTimeout();
        result = result * 59 + ($dynamoDbRequestTimeout == null ? 43 : ((Object)$dynamoDbRequestTimeout).hashCode());
        BillingMode $billingMode = this.billingMode();
        result = result * 59 + ($billingMode == null ? 43 : $billingMode.hashCode());
        long $leasesRecoveryAuditorExecutionFrequencyMillis = this.leasesRecoveryAuditorExecutionFrequencyMillis();
        result = result * 59 + (int)($leasesRecoveryAuditorExecutionFrequencyMillis >>> 32 ^ $leasesRecoveryAuditorExecutionFrequencyMillis);
        result = result * 59 + this.leasesRecoveryAuditorInconsistencyConfidenceThreshold();
        InitialPositionInStreamExtended $initialPositionInStream = this.initialPositionInStream();
        result = result * 59 + ($initialPositionInStream == null ? 43 : ((Object)$initialPositionInStream).hashCode());
        result = result * 59 + this.maxCacheMissesBeforeReload();
        long $listShardsCacheAllowedAgeInSeconds = this.listShardsCacheAllowedAgeInSeconds();
        result = result * 59 + (int)($listShardsCacheAllowedAgeInSeconds >>> 32 ^ $listShardsCacheAllowedAgeInSeconds);
        result = result * 59 + this.cacheMissWarningModulus();
        MetricsFactory $metricsFactory = this.metricsFactory();
        result = result * 59 + ($metricsFactory == null ? 43 : $metricsFactory.hashCode());
        ExecutorService $executorService = this.executorService();
        result = result * 59 + ($executorService == null ? 43 : $executorService.hashCode());
        TableCreatorCallback $tableCreatorCallback = this.tableCreatorCallback();
        result = result * 59 + ($tableCreatorCallback == null ? 43 : $tableCreatorCallback.hashCode());
        HierarchicalShardSyncer $hierarchicalShardSyncer = this.hierarchicalShardSyncer();
        result = result * 59 + ($hierarchicalShardSyncer == null ? 43 : $hierarchicalShardSyncer.hashCode());
        LeaseManagementFactory $leaseManagementFactory = this.leaseManagementFactory();
        result = result * 59 + ($leaseManagementFactory == null ? 43 : $leaseManagementFactory.hashCode());
        return result;
    }

    public String toString() {
        return "LeaseManagementConfig(tableName=" + this.tableName() + ", dynamoDBClient=" + this.dynamoDBClient() + ", kinesisClient=" + this.kinesisClient() + ", streamName=" + this.streamName() + ", workerIdentifier=" + this.workerIdentifier() + ", failoverTimeMillis=" + this.failoverTimeMillis() + ", shardSyncIntervalMillis=" + this.shardSyncIntervalMillis() + ", cleanupLeasesUponShardCompletion=" + this.cleanupLeasesUponShardCompletion() + ", leaseCleanupConfig=" + this.leaseCleanupConfig() + ", maxLeasesForWorker=" + this.maxLeasesForWorker() + ", maxLeasesToStealAtOneTime=" + this.maxLeasesToStealAtOneTime() + ", initialLeaseTableReadCapacity=" + this.initialLeaseTableReadCapacity() + ", initialLeaseTableWriteCapacity=" + this.initialLeaseTableWriteCapacity() + ", customShardDetectorProvider=" + this.customShardDetectorProvider() + ", maxLeaseRenewalThreads=" + this.maxLeaseRenewalThreads() + ", ignoreUnexpectedChildShards=" + this.ignoreUnexpectedChildShards() + ", consistentReads=" + this.consistentReads() + ", listShardsBackoffTimeInMillis=" + this.listShardsBackoffTimeInMillis() + ", maxListShardsRetryAttempts=" + this.maxListShardsRetryAttempts() + ", epsilonMillis=" + this.epsilonMillis() + ", dynamoDbRequestTimeout=" + this.dynamoDbRequestTimeout() + ", billingMode=" + this.billingMode() + ", leasesRecoveryAuditorExecutionFrequencyMillis=" + this.leasesRecoveryAuditorExecutionFrequencyMillis() + ", leasesRecoveryAuditorInconsistencyConfidenceThreshold=" + this.leasesRecoveryAuditorInconsistencyConfidenceThreshold() + ", initialPositionInStream=" + this.initialPositionInStream() + ", maxCacheMissesBeforeReload=" + this.maxCacheMissesBeforeReload() + ", listShardsCacheAllowedAgeInSeconds=" + this.listShardsCacheAllowedAgeInSeconds() + ", cacheMissWarningModulus=" + this.cacheMissWarningModulus() + ", metricsFactory=" + this.metricsFactory() + ", executorService=" + this.executorService() + ", tableCreatorCallback=" + this.tableCreatorCallback() + ", hierarchicalShardSyncer=" + this.hierarchicalShardSyncer() + ", leaseManagementFactory=" + this.leaseManagementFactory() + ")";
    }

    static class LeaseManagementThreadPool
    extends ThreadPoolExecutor {
        private static final long DEFAULT_KEEP_ALIVE_TIME = 60L;

        LeaseManagementThreadPool(ThreadFactory threadFactory) {
            super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        }
    }
}

