/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.metrics;

import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.lifecycle.ConsumerTask;
import software.amazon.kinesis.lifecycle.TaskResult;
import software.amazon.kinesis.lifecycle.TaskType;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.metrics.MetricsScope;
import software.amazon.kinesis.metrics.MetricsUtil;

@KinesisClientInternalApi
public class MetricsCollectingTaskDecorator
implements ConsumerTask {
    private final ConsumerTask other;
    private final MetricsFactory factory;

    public MetricsCollectingTaskDecorator(ConsumerTask other, MetricsFactory factory) {
        this.other = other;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult call() {
        MetricsScope scope = MetricsUtil.createMetricsWithOperation(this.factory, this.other.getClass().getSimpleName());
        TaskResult result = null;
        long startTimeMillis = System.currentTimeMillis();
        try {
            result = this.other.call();
            MetricsUtil.addSuccessAndLatency(scope, result != null && result.getException() == null, startTimeMillis, MetricsLevel.SUMMARY);
        }
        catch (Throwable throwable) {
            MetricsUtil.addSuccessAndLatency(scope, result != null && result.getException() == null, startTimeMillis, MetricsLevel.SUMMARY);
            MetricsUtil.endScope(scope);
            throw throwable;
        }
        MetricsUtil.endScope(scope);
        return result;
    }

    @Override
    public TaskType taskType() {
        return this.other.taskType();
    }

    public String toString() {
        return this.getClass().getName() + "<" + (Object)((Object)this.other.taskType()) + ">(" + this.other + ")";
    }

    public ConsumerTask getOther() {
        return this.other;
    }
}

