/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;

@KinesisClientInternalApi
public class AWSExceptionManager {
    private final Map<Class<? extends Throwable>, Function<? extends Throwable, RuntimeException>> map = new HashMap<Class<? extends Throwable>, Function<? extends Throwable, RuntimeException>>();
    private Function<Throwable, RuntimeException> defaultFunction = RuntimeException::new;

    public <T extends Throwable> void add(@NonNull Class<T> clazz, @NonNull Function<T, RuntimeException> function) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (function == null) {
            throw new NullPointerException("function");
        }
        this.map.put(clazz, function);
    }

    private Function<? extends Throwable, RuntimeException> handleFor(@NonNull Throwable t) {
        if (t == null) {
            throw new NullPointerException("t");
        }
        Class<?> clazz = t.getClass();
        Optional<Function<? extends Throwable, RuntimeException>> toApply = Optional.ofNullable(this.map.get(clazz));
        while (!toApply.isPresent() && clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            toApply = Optional.ofNullable(this.map.get(clazz));
        }
        return toApply.orElse(this.defaultFunction);
    }

    public RuntimeException apply(Throwable t) {
        Function<? extends Throwable, RuntimeException> f = this.handleFor(t);
        return f.apply(t);
    }

    public AWSExceptionManager defaultFunction(Function<Throwable, RuntimeException> defaultFunction) {
        this.defaultFunction = defaultFunction;
        return this;
    }
}

