/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.schemaregistry;

import com.amazonaws.services.schemaregistry.common.Schema;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.retrieval.KinesisClientRecord;

public class SchemaRegistryDecoder {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryDecoder.class);
    private final GlueSchemaRegistryDeserializer glueSchemaRegistryDeserializer;

    public SchemaRegistryDecoder(GlueSchemaRegistryDeserializer glueSchemaRegistryDeserializer) {
        this.glueSchemaRegistryDeserializer = glueSchemaRegistryDeserializer;
    }

    public List<KinesisClientRecord> decode(List<KinesisClientRecord> records) {
        ArrayList<KinesisClientRecord> decodedRecords = new ArrayList<KinesisClientRecord>();
        for (KinesisClientRecord record : records) {
            KinesisClientRecord decodedRecord = this.decodeRecord(record);
            decodedRecords.add(decodedRecord);
        }
        return decodedRecords;
    }

    private KinesisClientRecord decodeRecord(KinesisClientRecord record) {
        if (record.data() == null) {
            return record;
        }
        int length = record.data().remaining();
        byte[] data = new byte[length];
        record.data().get(data, 0, length);
        try {
            if (!this.isSchemaEncoded(data)) {
                return record;
            }
            Schema schema = this.glueSchemaRegistryDeserializer.getSchema(data);
            ByteBuffer recordData = ByteBuffer.wrap(this.glueSchemaRegistryDeserializer.getData(data));
            return record.toBuilder().schema(schema).data(recordData).build();
        }
        catch (Exception e) {
            log.warn("Unable to decode Glue Schema Registry information from record {}: ", (Object)record.sequenceNumber(), (Object)e);
            return record;
        }
    }

    private boolean isSchemaEncoded(byte[] data) {
        return this.glueSchemaRegistryDeserializer.canDeserialize(data);
    }
}

