/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.producer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.kinesis.producer.BinaryToHexConverter;
import software.amazon.kinesis.producer.DaemonException;
import software.amazon.kinesis.producer.IrrecoverableError;
import software.amazon.kinesis.producer.KinesisProducerConfiguration;
import software.amazon.kinesis.producer.LogInputStreamReader;
import software.amazon.kinesis.producer.protobuf.Messages;

public class Daemon {
    private static final Logger log = LoggerFactory.getLogger(Daemon.class);
    private BlockingQueue<Messages.Message> outgoingMessages = new LinkedBlockingQueue<Messages.Message>();
    private BlockingQueue<Messages.Message> incomingMessages = new LinkedBlockingQueue<Messages.Message>();
    private ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("kpl-daemon-%04d").build());
    private Process process = null;
    private LogInputStreamReader stdOutReader;
    private LogInputStreamReader stdErrReader;
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private File inPipe = null;
    private File outPipe = null;
    private FileChannel inChannel = null;
    private FileChannel outChannel = null;
    private OutputStream outStream;
    private ByteBuffer lenBuf = ByteBuffer.allocate(4);
    private ByteBuffer rcvBuf = ByteBuffer.allocate(0xC00000);
    private final String pathToExecutable;
    private final MessageHandler handler;
    private final String workingDir;
    private final KinesisProducerConfiguration config;
    private final Map<String, String> environmentVariables;

    public Daemon(String pathToExecutable, MessageHandler handler, String workingDir, KinesisProducerConfiguration config, Map<String, String> environmentVariables) {
        this.pathToExecutable = pathToExecutable;
        this.handler = handler;
        this.workingDir = workingDir;
        this.config = config;
        this.environmentVariables = environmentVariables;
        this.lenBuf.order(ByteOrder.BIG_ENDIAN);
        this.rcvBuf.order(ByteOrder.BIG_ENDIAN);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Daemon.this.createPipes();
                    Daemon.this.startChildProcess();
                }
                catch (Exception e) {
                    Daemon.this.fatalError("Error running child process", e);
                }
            }
        });
    }

    protected Daemon(File inPipe, File outPipe, MessageHandler handler) {
        this.workingDir = ".";
        this.pathToExecutable = null;
        this.inPipe = inPipe;
        this.outPipe = outPipe;
        this.handler = handler;
        this.config = null;
        this.environmentVariables = null;
        try {
            this.connectToChild();
            this.startLoops();
        }
        catch (IOException e) {
            this.fatalError("Could not connect to child", e, false);
        }
    }

    public void add(Messages.Message m) {
        if (this.shutdown.get()) {
            throw new DaemonException("The child process has been shutdown and can no longer accept messages.");
        }
        try {
            this.outgoingMessages.put(m);
        }
        catch (InterruptedException e) {
            this.fatalError("Unexpected error", e);
        }
    }

    public void destroy() {
        this.fatalError("Destroy is called", false);
    }

    public File getInPipe() {
        return this.inPipe;
    }

    public File getOutPipe() {
        return this.outPipe;
    }

    public String getPathToExecutable() {
        return this.pathToExecutable;
    }

    public MessageHandler getHandler() {
        return this.handler;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public int getQueueSize() {
        return this.outgoingMessages.size();
    }

    private void sendMessage() {
        try {
            Messages.Message m = this.outgoingMessages.take();
            int size = m.getSerializedSize();
            this.lenBuf.rewind();
            this.lenBuf.putInt(size);
            this.lenBuf.rewind();
            this.outChannel.write(this.lenBuf);
            m.writeTo(this.outStream);
            this.outStream.flush();
        }
        catch (IOException | InterruptedException e) {
            this.fatalError("Error writing message to daemon", e);
        }
    }

    private void receiveMessage() {
        try {
            this.readSome(4);
            int len = this.rcvBuf.getInt();
            if (len <= 0 || len > this.rcvBuf.capacity()) {
                throw new IllegalArgumentException("Invalid message size (" + len + " bytes, at most " + this.rcvBuf.capacity() + " supported)");
            }
            this.readSome(len);
            Messages.Message m = Messages.Message.parseFrom(ByteString.copyFrom((ByteBuffer)this.rcvBuf));
            this.incomingMessages.put(m);
        }
        catch (IOException | InterruptedException e) {
            this.fatalError("Error reading message from daemon", e);
        }
    }

    private void returnMessage() {
        try {
            Messages.Message m = this.incomingMessages.take();
            if (this.handler != null) {
                try {
                    this.handler.onMessage(m);
                }
                catch (Exception e) {
                    log.error("Error in message handler", (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            this.fatalError("Unexpected error", e);
        }
    }

    private void startLoops() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!Daemon.this.shutdown.get()) {
                    Daemon.this.sendMessage();
                }
            }
        });
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!Daemon.this.shutdown.get()) {
                    Daemon.this.receiveMessage();
                }
            }
        });
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!Daemon.this.shutdown.get()) {
                    Daemon.this.returnMessage();
                }
            }
        });
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!Daemon.this.shutdown.get()) {
                    try {
                        Daemon.this.updateCredentials();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (RuntimeException re) {
                        log.error("Caught runtime exception while updating credentials.  Will retry after refresh delay", (Throwable)re);
                    }
                    try {
                        Thread.sleep(Daemon.this.config.getCredentialsRefreshDelay());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
    }

    private void connectToChild() throws IOException {
        long start = System.nanoTime();
        while (true) {
            try {
                this.inChannel = FileChannel.open(Paths.get(this.inPipe.getAbsolutePath(), new String[0]), StandardOpenOption.READ);
                this.outChannel = FileChannel.open(Paths.get(this.outPipe.getAbsolutePath(), new String[0]), StandardOpenOption.WRITE);
                this.outStream = Channels.newOutputStream(this.outChannel);
            }
            catch (IOException e) {
                if (this.inChannel != null && this.inChannel.isOpen()) {
                    this.inChannel.close();
                }
                if (this.outChannel != null && this.outChannel.isOpen()) {
                    this.outChannel.close();
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!((double)(System.nanoTime() - start) > 2.0E9)) continue;
                throw e;
            }
            break;
        }
    }

    private void createPipes() throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            this.createPipesWindows();
        } else {
            this.createPipesUnix();
        }
        this.inPipe.deleteOnExit();
        this.outPipe.deleteOnExit();
    }

    private void createPipesWindows() {
        do {
            this.inPipe = Paths.get("\\\\.\\pipe\\amz-aws-kpl-in-pipe-" + Daemon.uuid8Chars(), new String[0]).toFile();
        } while (this.inPipe.exists());
        do {
            this.outPipe = Paths.get("\\\\.\\pipe\\amz-aws-kpl-out-pipe-" + Daemon.uuid8Chars(), new String[0]).toFile();
        } while (this.outPipe.exists());
    }

    private void createPipesUnix() {
        File dir = new File(this.workingDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        do {
            this.inPipe = Paths.get(dir.getAbsolutePath(), "amz-aws-kpl-in-pipe-" + Daemon.uuid8Chars()).toFile();
        } while (this.inPipe.exists());
        do {
            this.outPipe = Paths.get(dir.getAbsolutePath(), "amz-aws-kpl-out-pipe-" + Daemon.uuid8Chars()).toFile();
        } while (this.outPipe.exists());
        try {
            Runtime.getRuntime().exec("mkfifo " + this.inPipe.getAbsolutePath() + " " + this.outPipe.getAbsolutePath());
        }
        catch (Exception e) {
            this.fatalError("Error creating pipes", e, false);
        }
        long start = System.nanoTime();
        while (!this.inPipe.exists() || !this.outPipe.exists()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!((double)(System.nanoTime() - start) > 1.5E10)) continue;
            this.fatalError("Pipes did not show up after calling mkfifo", false);
        }
    }

    private void deletePipes() {
        try {
            this.inChannel.close();
            this.outChannel.close();
            this.inPipe.delete();
            this.outPipe.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startChildProcess() throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(this.pathToExecutable, "-o", this.outPipe.getAbsolutePath(), "-i", this.inPipe.getAbsolutePath(), "-c", Daemon.protobufToHex((Message)this.config.toProtobufMessage()), "-k", Daemon.protobufToHex((Message)Daemon.makeSetCredentialsMessage(this.config.getCredentialsProvider(), false)), "-t"));
        AwsCredentialsProvider metricsCreds = this.config.getMetricsCredentialsProvider();
        if (metricsCreds == null) {
            metricsCreds = this.config.getCredentialsProvider();
        }
        args.add("-w");
        args.add(Daemon.protobufToHex((Message)Daemon.makeSetCredentialsMessage(metricsCreds, true)));
        args.add("-l");
        args.add(this.config.getLogLevel());
        log.debug("Starting Native Process: {}", (Object)StringUtils.join(args, (String)" "));
        ProcessBuilder pb = new ProcessBuilder(args);
        for (Map.Entry<String, String> e : this.environmentVariables.entrySet()) {
            pb.environment().put(e.getKey(), e.getValue());
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Daemon.this.connectToChild();
                    Daemon.this.startLoops();
                }
                catch (IOException e) {
                    Daemon.this.fatalError("Unexpected error connecting to child process", e, false);
                }
            }
        });
        try {
            this.process = pb.start();
        }
        catch (Exception e) {
            this.fatalError("Error starting child process", e, false);
        }
        this.stdOutReader = new LogInputStreamReader(this.process.getInputStream(), "StdOut", new LogInputStreamReader.DefaultLoggingFunction(){

            @Override
            public void apply(Logger logger, String message) {
                logger.info(message);
            }
        });
        this.stdErrReader = new LogInputStreamReader(this.process.getErrorStream(), "StdErr", new LogInputStreamReader.DefaultLoggingFunction(){

            @Override
            public void apply(Logger logger, String message) {
                logger.warn(message);
            }
        });
        this.executor.execute(this.stdOutReader);
        this.executor.execute(this.stdErrReader);
        try {
            int code = this.process.waitFor();
            this.fatalError("Child process exited with code " + code, code != 1);
        }
        finally {
            this.stdOutReader.shutdown();
            this.stdErrReader.shutdown();
            this.deletePipes();
        }
    }

    private void updateCredentials() throws InterruptedException {
        this.outgoingMessages.put(Daemon.makeSetCredentialsMessage(this.config.getCredentialsProvider(), false));
        AwsCredentialsProvider metricsCreds = this.config.getMetricsCredentialsProvider();
        if (metricsCreds == null) {
            metricsCreds = this.config.getCredentialsProvider();
        }
        this.outgoingMessages.put(Daemon.makeSetCredentialsMessage(metricsCreds, true));
    }

    private void fatalError(String message) {
        this.fatalError(message, true);
    }

    private void fatalError(String message, boolean retryable) {
        this.fatalError(message, null, retryable);
    }

    private synchronized void fatalError(String message, Throwable t) {
        this.fatalError(message, t, true);
    }

    private synchronized void fatalError(String message, Throwable t, boolean retryable) {
        if (!this.shutdown.getAndSet(true)) {
            if (this.process != null) {
                if (this.stdErrReader != null) {
                    this.stdErrReader.prepareForShutdown();
                }
                if (this.stdOutReader != null) {
                    this.stdOutReader.prepareForShutdown();
                }
                this.process.destroy();
            }
            try {
                this.executor.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executor.shutdownNow();
            if (this.handler != null) {
                if (retryable) {
                    this.handler.onError(t != null ? new RuntimeException(message, t) : new RuntimeException(message));
                } else {
                    this.handler.onError(t != null ? new IrrecoverableError(message, t) : new IrrecoverableError(message));
                }
            }
        }
    }

    private void readSome(int n) throws IOException {
        this.rcvBuf.rewind();
        this.rcvBuf.limit(n);
        int total = 0;
        while (total < n) {
            int r = this.inChannel.read(this.rcvBuf);
            if (r >= 0) {
                total += r;
                continue;
            }
            this.fatalError("EOF reached during read");
        }
        this.rcvBuf.rewind();
    }

    private static String uuid8Chars() {
        return UUID.randomUUID().toString().substring(0, 8);
    }

    private static Messages.Message makeSetCredentialsMessage(AwsCredentialsProvider provider, boolean forMetrics) {
        AwsCredentials creds = provider.resolveCredentials();
        Messages.Credentials.Builder cb = Messages.Credentials.newBuilder().setAkid(creds.accessKeyId()).setSecretKey(creds.secretAccessKey());
        if (creds instanceof AwsSessionCredentials) {
            cb.setToken(((AwsSessionCredentials)creds).sessionToken());
        }
        Messages.SetCredentials setCreds = Messages.SetCredentials.newBuilder().setCredentials(cb.build()).setForMetrics(forMetrics).build();
        return Messages.Message.newBuilder().setSetCredentials(setCreds).setId(Long.MAX_VALUE).build();
    }

    private static String protobufToHex(Message msg) {
        return BinaryToHexConverter.convert(msg.toByteArray());
    }

    public static interface MessageHandler {
        public void onMessage(Messages.Message var1);

        public void onError(Throwable var1);
    }
}

