/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.producer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileAgeManager
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FileAgeManager.class);
    private static final FileAgeManager instance = new FileAgeManager();
    private final ScheduledExecutorService executorService;
    private final Set<File> watchedFiles = new HashSet<File>();

    static synchronized FileAgeManager instance() {
        return instance;
    }

    FileAgeManager() {
        this(Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("KP-FileMaintenance-%04d").build()));
    }

    FileAgeManager(ScheduledExecutorService executorService) {
        this.executorService = executorService;
        this.executorService.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.MINUTES);
    }

    public synchronized void registerFiles(Collection<File> toRegister) {
        for (File f : toRegister) {
            this.watchedFiles.add(f.getAbsoluteFile());
        }
    }

    @Override
    public synchronized void run() {
        for (File file : this.watchedFiles) {
            if (!file.exists()) {
                log.error("File '{}' doesn't exist or has been removed. This could cause problems with the native components.  It's recommended to restart the JVM.", (Object)file.getAbsolutePath());
                continue;
            }
            if (file.setLastModified(System.currentTimeMillis())) continue;
            log.warn("Failed to update the last modified time of '{}'.", (Object)file.getAbsolutePath());
        }
    }
}

