/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.producer;

import com.amazonaws.services.schemaregistry.common.Schema;
import com.amazonaws.services.schemaregistry.serializers.GlueSchemaRegistrySerializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.producer.CertificateExtractor;
import software.amazon.kinesis.producer.Daemon;
import software.amazon.kinesis.producer.FileAgeManager;
import software.amazon.kinesis.producer.FutureTimedOutException;
import software.amazon.kinesis.producer.GlueSchemaRegistrySerializerInstance;
import software.amazon.kinesis.producer.HashedFileCopier;
import software.amazon.kinesis.producer.IKinesisProducer;
import software.amazon.kinesis.producer.IrrecoverableError;
import software.amazon.kinesis.producer.KinesisProducerConfiguration;
import software.amazon.kinesis.producer.KinesisProducerException;
import software.amazon.kinesis.producer.Metric;
import software.amazon.kinesis.producer.ProcessFailureBehavior;
import software.amazon.kinesis.producer.UnexpectedMessageException;
import software.amazon.kinesis.producer.UserRecord;
import software.amazon.kinesis.producer.UserRecordFailedException;
import software.amazon.kinesis.producer.UserRecordResult;
import software.amazon.kinesis.producer.protobuf.Messages;

public class KinesisProducer
implements IKinesisProducer {
    private static final Logger log = LoggerFactory.getLogger(KinesisProducer.class);
    private static final BigInteger UINT_128_MAX = new BigInteger(StringUtils.repeat((String)"FF", (int)16), 16);
    private static final Object EXTRACT_BIN_MUTEX = new Object();
    private static final AtomicInteger CALLBACK_COMPLETION_POOL_NUMBER = new AtomicInteger(0);
    private static final int CALLBACK_COMPLETION_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 4;
    private final KinesisProducerConfiguration config;
    private final Map<String, String> env;
    private final AtomicLong messageNumber = new AtomicLong(1L);
    private final AtomicLong totalFutureTimeouts = new AtomicLong(0L);
    private final GlueSchemaRegistrySerializerInstance glueSchemaRegistrySerializerInstance = new GlueSchemaRegistrySerializerInstance();
    private final Map<Long, SettableFutureTracker> futures = new ConcurrentHashMap<Long, SettableFutureTracker>();
    private final PriorityBlockingQueue<SettableFutureTracker> oldestFutureTrackerHeap = new PriorityBlockingQueue<SettableFutureTracker>(10, new SettableFutureTrackerComparator());
    private final ScheduledThreadPoolExecutor futureTimeoutExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("kpl-timeout-future-" + CALLBACK_COMPLETION_POOL_NUMBER.getAndIncrement() + "-thread-%d").build());
    private final ExecutorService callbackCompletionExecutor = new ThreadPoolExecutor(CALLBACK_COMPLETION_POOL_SIZE, CALLBACK_COMPLETION_POOL_SIZE, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("kpl-callback-pool-" + CALLBACK_COMPLETION_POOL_NUMBER.getAndIncrement() + "-thread-%d").build(), new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            r.run();
        }
    });
    private String pathToExecutable;
    private String pathToLibDir;
    private String pathToTmpDir;
    private volatile Daemon child;
    private volatile long lastChild = System.nanoTime();
    private volatile boolean destroyed = false;
    private ProcessFailureBehavior processFailureBehavior = ProcessFailureBehavior.AutoRestart;

    private SettableFutureTracker getFutureTracker(long id) {
        SettableFutureTracker futureTracker = this.futures.remove(id);
        if (futureTracker == null) {
            String message = "Future for message id " + id + " not found as potentially it was a duplicate message or was timed out in Java layer.";
            log.error(message);
            throw new RuntimeException(message);
        }
        if (this.config.getEnableOldestFutureTracker()) {
            this.oldestFutureTrackerHeap.remove(futureTracker);
        }
        return futureTracker;
    }

    public KinesisProducer(KinesisProducerConfiguration config) {
        this.config = config;
        this.env = this.initEnv();
        this.child = new Daemon(this.pathToExecutable, new MessageHandler(), this.pathToTmpDir, config, this.env);
        this.futureTimeoutExecutor.setRemoveOnCancelPolicy(true);
    }

    private Map<String, String> initEnv() {
        String caPath = this.config.getCaCertPath();
        String caFile = this.config.getCaCertFile();
        String caDirectory = this.extractBinaries();
        if (!StringUtils.isEmpty((CharSequence)caPath)) {
            log.info("Overrding the ca cert path to use as provided in the kpl config to be " + caPath);
            caDirectory = caPath;
        }
        ImmutableMap env = new ImmutableMap.Builder().put((Object)"LD_LIBRARY_PATH", (Object)this.pathToLibDir).put((Object)"DYLD_LIBRARY_PATH", (Object)this.pathToLibDir).put((Object)"CA_DIR", (Object)caDirectory).put((Object)"CA_FILE", (Object)caFile).build();
        return env;
    }

    KinesisProducer(KinesisProducerConfiguration config, Daemon daemon) {
        this.config = config;
        this.child = daemon;
        this.env = this.initEnv();
        this.futureTimeoutExecutor.setRemoveOnCancelPolicy(true);
    }

    public KinesisProducer() {
        this(new KinesisProducerConfiguration());
    }

    protected KinesisProducer(File inPipe, File outPipe) {
        this.config = null;
        this.env = null;
        this.child = new Daemon(inPipe, outPipe, new MessageHandler());
    }

    @Override
    public ListenableFuture<UserRecordResult> addUserRecord(String stream, String partitionKey, ByteBuffer data) {
        return this.addUserRecord(stream, partitionKey, null, data);
    }

    @Override
    public ListenableFuture<UserRecordResult> addUserRecord(UserRecord userRecord) {
        return this.addUserRecord(userRecord.getStreamName(), userRecord.getPartitionKey(), userRecord.getExplicitHashKey(), userRecord.getData(), userRecord.getSchema());
    }

    @Override
    public ListenableFuture<UserRecordResult> addUserRecord(String stream, String partitionKey, String explicitHashKey, ByteBuffer data) {
        return this.addUserRecord(stream, partitionKey, explicitHashKey, data, null);
    }

    @Override
    public ListenableFuture<UserRecordResult> addUserRecord(String stream, String partitionKey, String explicitHashKey, ByteBuffer data, Schema schema) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream name cannot be null");
        }
        if ((stream = stream.trim()).length() == 0) {
            throw new IllegalArgumentException("Stream name cannot be empty");
        }
        if (partitionKey == null) {
            throw new IllegalArgumentException("partitionKey cannot be null");
        }
        if (partitionKey.length() < 1 || partitionKey.length() > 256) {
            throw new IllegalArgumentException("Invalid partition key. Length must be at least 1 and at most 256, got " + partitionKey.length());
        }
        try {
            partitionKey.getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Partition key must be valid UTF-8");
        }
        BigInteger b = null;
        if (explicitHashKey != null) {
            explicitHashKey = explicitHashKey.trim();
            try {
                b = new BigInteger(explicitHashKey);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid explicitHashKey, must be an integer, got " + explicitHashKey);
            }
            if (b != null && (b.compareTo(UINT_128_MAX) > 0 || b.compareTo(BigInteger.ZERO) < 0)) {
                throw new IllegalArgumentException("Invalid explicitHashKey, must be greater or equal to zero and less than or equal to (2^128 - 1), got " + explicitHashKey);
            }
        }
        if (schema != null && data != null) {
            if (schema.getSchemaDefinition() == null || schema.getDataFormat() == null) {
                throw new IllegalArgumentException(String.format("Schema specification is not valid. SchemaDefinition or DataFormat cannot be null. SchemaDefinition: %s, DataFormat: %s", schema.getSchemaDefinition(), schema.getDataFormat()));
            }
            GlueSchemaRegistrySerializer serializer = this.glueSchemaRegistrySerializerInstance.get(this.config);
            byte[] encodedBytes = serializer.encode(stream, schema, data.array());
            data = ByteBuffer.wrap(encodedBytes);
        }
        if (data != null && data.remaining() > 0xA00000) {
            throw new IllegalArgumentException("Data must be less than or equal to 10MB in size, got " + data.remaining() + " bytes");
        }
        long id = this.messageNumber.getAndIncrement();
        SettableFuture f = SettableFuture.create();
        FutureTask<String> task = null;
        if (this.config.getUserRecordTimeoutInMillis() > 0L) {
            task = new FutureTask<String>(new FutureTimeoutRunnableTask(id), "TimedOut");
            this.futureTimeoutExecutor.schedule(task, this.config.getUserRecordTimeoutInMillis(), TimeUnit.MILLISECONDS);
        }
        UserRecord userRecord = null;
        if (this.config.getReturnUserRecordOnFailure()) {
            ByteBuffer deepCopyOfData = data != null ? ByteString.copyFrom((ByteBuffer)data.duplicate()).asReadOnlyByteBuffer() : null;
            userRecord = new UserRecord(stream, partitionKey, explicitHashKey, deepCopyOfData, schema);
        }
        SettableFutureTracker futuresTracking = new SettableFutureTracker(f, Instant.now(), Optional.ofNullable(task), userRecord);
        this.futures.put(id, futuresTracking);
        if (this.config.getEnableOldestFutureTracker()) {
            this.oldestFutureTrackerHeap.add(futuresTracking);
        }
        Messages.PutRecord.Builder pr = Messages.PutRecord.newBuilder().setStreamName(stream).setPartitionKey(partitionKey).setData(data != null ? ByteString.copyFrom((ByteBuffer)data) : ByteString.EMPTY);
        if (b != null) {
            pr.setExplicitHashKey(b.toString(10));
        }
        Messages.Message m = Messages.Message.newBuilder().setId(id).setPutRecord(pr.build()).build();
        this.addMessageToChild(m);
        return f;
    }

    @Override
    public int getOutstandingRecordsCount() {
        return this.futures.size();
    }

    @Override
    public long getOldestRecordTimeInMillis() {
        SettableFutureTracker oldestFuture = this.oldestFutureTrackerHeap.peek();
        if (oldestFuture == null) {
            return 0L;
        }
        return Instant.now().toEpochMilli() - oldestFuture.getTimestamp().toEpochMilli();
    }

    @Override
    public List<Metric> getMetrics(String metricName, int windowSeconds) throws InterruptedException, ExecutionException {
        Messages.MetricsRequest.Builder mrb = Messages.MetricsRequest.newBuilder();
        if (metricName != null) {
            mrb.setName(metricName);
        }
        if (windowSeconds > 0) {
            mrb.setSeconds(windowSeconds);
        }
        long id = this.messageNumber.getAndIncrement();
        SettableFuture f = SettableFuture.create();
        FutureTask<String> task = null;
        if (this.config.getUserRecordTimeoutInMillis() > 0L) {
            task = new FutureTask<String>(new FutureTimeoutRunnableTask(id), "TimedOut");
            this.futureTimeoutExecutor.schedule(task, this.config.getUserRecordTimeoutInMillis(), TimeUnit.MILLISECONDS);
        }
        SettableFutureTracker futuresTracking = new SettableFutureTracker(f, Instant.now(), Optional.ofNullable(task), null);
        this.futures.put(id, futuresTracking);
        if (this.config.getEnableOldestFutureTracker()) {
            this.oldestFutureTrackerHeap.add(futuresTracking);
        }
        this.addMessageToChild(Messages.Message.newBuilder().setId(id).setMetricsRequest(mrb.build()).build());
        return (List)f.get();
    }

    @Override
    public List<Metric> getMetrics(String metricName) throws InterruptedException, ExecutionException {
        return this.getMetrics(metricName, -1);
    }

    @Override
    public List<Metric> getMetrics() throws InterruptedException, ExecutionException {
        return this.getMetrics(null);
    }

    @Override
    public List<Metric> getMetrics(int windowSeconds) throws InterruptedException, ExecutionException {
        return this.getMetrics(null, windowSeconds);
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        this.callbackCompletionExecutor.shutdownNow();
        this.child.destroy();
    }

    @Override
    public void flush(String stream) {
        Messages.Flush.Builder f = Messages.Flush.newBuilder();
        if (stream != null) {
            f.setStreamName(stream);
        }
        Messages.Message m = Messages.Message.newBuilder().setId(this.messageNumber.getAndIncrement()).setFlush(f.build()).build();
        this.addMessageToChild(m);
    }

    @Override
    public void flush() {
        this.flush(null);
    }

    @Override
    public void flushSync() {
        while (this.getOutstandingRecordsCount() > 0) {
            this.flush();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @VisibleForTesting
    Map<Long, SettableFutureTracker> getFutures() {
        return this.futures;
    }

    @VisibleForTesting
    Daemon getChild() {
        return this.child;
    }

    @VisibleForTesting
    void addMessageToChild(Messages.Message m) {
        this.child.add(m);
    }

    private String extractBinaries() {
        Object object = EXTRACT_BIN_MUTEX;
        synchronized (object) {
            ArrayList<File> watchFiles = new ArrayList<File>(2);
            String os = SystemUtils.OS_NAME;
            if (SystemUtils.IS_OS_WINDOWS) {
                os = "windows";
            } else if (SystemUtils.IS_OS_LINUX) {
                os = "linux-" + (SystemUtils.OS_ARCH.equals("amd64") ? "x86_64" : SystemUtils.OS_ARCH);
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                os = "osx";
            } else {
                throw new RuntimeException("Your operation system is not supported (" + os + "), the KPL only supports Linux, OSX and Windows");
            }
            String root = "amazon-kinesis-producer-native-binaries";
            String tmpDir = this.config.getTempDirectory();
            if (tmpDir.trim().length() == 0) {
                tmpDir = System.getProperty("java.io.tmpdir");
            }
            this.pathToTmpDir = tmpDir = Paths.get(tmpDir, root).toString();
            String binPath = this.config.getNativeExecutable();
            if (binPath != null && !binPath.trim().isEmpty()) {
                this.pathToExecutable = binPath.trim();
                log.warn("Using non-default native binary at " + this.pathToExecutable);
                File parent = new File(binPath).getParentFile();
                this.pathToLibDir = parent.getAbsolutePath();
                CertificateExtractor certificateExtractor = new CertificateExtractor();
                try {
                    String caDirectory = certificateExtractor.extractCertificates(parent.getAbsoluteFile());
                    watchFiles.addAll(certificateExtractor.getExtractedCertificates());
                    FileAgeManager.instance().registerFiles(watchFiles);
                    return caDirectory;
                }
                catch (IOException ioex) {
                    log.error("Exception while extracting certificates.  Returning no CA directory", (Throwable)ioex);
                    return "";
                }
            }
            log.info("Extracting binaries to " + tmpDir);
            try {
                File tmpDirFile = new File(tmpDir);
                if (!tmpDirFile.exists() && !tmpDirFile.mkdirs()) {
                    throw new IOException("Could not create tmp dir " + tmpDir);
                }
                String extension = os.equals("windows") ? ".exe" : "";
                String executableName = "kinesis_producer" + extension;
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(root + "/" + os + "/" + executableName);
                String resultFileFormat = "kinesis_producer_%s" + extension;
                File extracted = HashedFileCopier.copyFileFrom(is, tmpDirFile, resultFileFormat);
                watchFiles.add(extracted);
                extracted.setExecutable(true);
                this.pathToExecutable = extracted.getAbsolutePath();
                CertificateExtractor certificateExtractor = new CertificateExtractor();
                String caDirectory = certificateExtractor.extractCertificates(new File(this.pathToTmpDir).getAbsoluteFile());
                watchFiles.addAll(certificateExtractor.getExtractedCertificates());
                this.pathToLibDir = this.pathToTmpDir;
                FileAgeManager.instance().registerFiles(watchFiles);
                return caDirectory;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not copy native binaries to temp directory " + tmpDir, e);
            }
        }
    }

    private class FutureTimeoutRunnableTask
    implements Runnable {
        private long id;

        @Override
        public void run() {
            SettableFutureTracker futureTracker = KinesisProducer.this.getFutureTracker(this.id);
            KinesisProducer.this.totalFutureTimeouts.getAndIncrement();
            SettableFuture<?> f = futureTracker.getFuture();
            String message = "Message id " + this.id + " timeout out. Removing the submitted future from processing queue.";
            f.setException((Throwable)new FutureTimedOutException(message, futureTracker.getUserRecord()));
            log.error(message);
        }

        public FutureTimeoutRunnableTask(long id) {
            this.id = id;
        }
    }

    private class MessageHandler
    implements Daemon.MessageHandler {
        private MessageHandler() {
        }

        @Override
        public void onMessage(final Messages.Message m) {
            KinesisProducer.this.callbackCompletionExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (m.hasPutRecordResult()) {
                        MessageHandler.this.onPutRecordResult(m);
                    } else if (m.hasMetricsResponse()) {
                        MessageHandler.this.onMetricsResponse(m);
                    } else {
                        SettableFutureTracker futureTracker = MessageHandler.this.getFuture(m);
                        SettableFuture<?> f = futureTracker.getFuture();
                        f.setException((Throwable)new UnexpectedMessageException("Unexpected message type from child process", futureTracker.getUserRecord()));
                        log.error(String.format("Unexpected message type with case %s from child process with message id %s. Removing the submitted future from processing queue.", new Object[]{m.getActualMessageCase(), m.getSourceId()}));
                    }
                }
            });
        }

        @Override
        public void onError(final Throwable t) {
            if (!KinesisProducer.this.destroyed) {
                log.error("Error in child process", t);
            }
            for (final Map.Entry entry : KinesisProducer.this.futures.entrySet()) {
                KinesisProducer.this.callbackCompletionExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ((SettableFutureTracker)entry.getValue()).getFuture().setException((Throwable)new KinesisProducerException(t, ((SettableFutureTracker)entry.getValue()).getUserRecord()));
                    }
                });
            }
            KinesisProducer.this.futures.clear();
            if (KinesisProducer.this.config.getEnableOldestFutureTracker()) {
                KinesisProducer.this.oldestFutureTrackerHeap.clear();
            }
            if (KinesisProducer.this.processFailureBehavior == ProcessFailureBehavior.AutoRestart && !KinesisProducer.this.destroyed) {
                log.info("Restarting native producer process.");
                KinesisProducer.this.child = new Daemon(KinesisProducer.this.pathToExecutable, new MessageHandler(), KinesisProducer.this.pathToTmpDir, KinesisProducer.this.config, KinesisProducer.this.env);
            } else if (!(t instanceof IrrecoverableError) && (double)(System.nanoTime() - KinesisProducer.this.lastChild) > 3.0E9) {
                KinesisProducer.this.lastChild = System.nanoTime();
                KinesisProducer.this.child = new Daemon(KinesisProducer.this.pathToExecutable, new MessageHandler(), KinesisProducer.this.pathToTmpDir, KinesisProducer.this.config, KinesisProducer.this.env);
            }
        }

        private void onPutRecordResult(Messages.Message msg) {
            SettableFutureTracker futureTracker = this.getFuture(msg);
            SettableFuture<?> f = futureTracker.getFuture();
            UserRecordResult result = UserRecordResult.fromProtobufMessage(msg.getPutRecordResult());
            if (result.isSuccessful()) {
                f.set((Object)result);
            } else {
                f.setException((Throwable)new UserRecordFailedException(result, futureTracker.getUserRecord()));
            }
        }

        private void onMetricsResponse(Messages.Message msg) {
            SettableFutureTracker futureTracker = this.getFuture(msg);
            SettableFuture<?> f = futureTracker.getFuture();
            ArrayList<Metric> userMetrics = new ArrayList<Metric>();
            Messages.MetricsResponse res = msg.getMetricsResponse();
            for (Messages.Metric metric : res.getMetricsList()) {
                userMetrics.add(new Metric(metric));
            }
            f.set(userMetrics);
        }

        private SettableFutureTracker getFuture(Messages.Message msg) {
            long id = msg.getSourceId();
            SettableFutureTracker futureTracker = KinesisProducer.this.getFutureTracker(id);
            futureTracker.cancelTimeoutTaskIfPresent();
            return futureTracker;
        }
    }

    static final class SettableFutureTracker {
        @NonNull
        private final SettableFuture<?> future;
        @NonNull
        private final Instant timestamp;
        @NonNull
        private final Optional<FutureTask> timeoutTask;
        private final UserRecord userRecord;

        private void cancelTimeoutTaskIfPresent() {
            this.timeoutTask.ifPresent(t -> t.cancel(false));
        }

        public SettableFutureTracker(@NonNull SettableFuture<?> future, @NonNull Instant timestamp, @NonNull Optional<FutureTask> timeoutTask, UserRecord userRecord) {
            if (future == null) {
                throw new NullPointerException("future is marked non-null but is null");
            }
            if (timestamp == null) {
                throw new NullPointerException("timestamp is marked non-null but is null");
            }
            if (timeoutTask == null) {
                throw new NullPointerException("timeoutTask is marked non-null but is null");
            }
            this.future = future;
            this.timestamp = timestamp;
            this.timeoutTask = timeoutTask;
            this.userRecord = userRecord;
        }

        @NonNull
        public SettableFuture<?> getFuture() {
            return this.future;
        }

        @NonNull
        public Instant getTimestamp() {
            return this.timestamp;
        }

        @NonNull
        public Optional<FutureTask> getTimeoutTask() {
            return this.timeoutTask;
        }

        public UserRecord getUserRecord() {
            return this.userRecord;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SettableFutureTracker)) {
                return false;
            }
            SettableFutureTracker other = (SettableFutureTracker)o;
            SettableFuture<?> this$future = this.getFuture();
            SettableFuture<?> other$future = other.getFuture();
            if (this$future == null ? other$future != null : !this$future.equals(other$future)) {
                return false;
            }
            Instant this$timestamp = this.getTimestamp();
            Instant other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            Optional<FutureTask> this$timeoutTask = this.getTimeoutTask();
            Optional<FutureTask> other$timeoutTask = other.getTimeoutTask();
            if (this$timeoutTask == null ? other$timeoutTask != null : !((Object)this$timeoutTask).equals(other$timeoutTask)) {
                return false;
            }
            UserRecord this$userRecord = this.getUserRecord();
            UserRecord other$userRecord = other.getUserRecord();
            return !(this$userRecord == null ? other$userRecord != null : !this$userRecord.equals(other$userRecord));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SettableFuture<?> $future = this.getFuture();
            result = result * 59 + ($future == null ? 43 : $future.hashCode());
            Instant $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            Optional<FutureTask> $timeoutTask = this.getTimeoutTask();
            result = result * 59 + ($timeoutTask == null ? 43 : ((Object)$timeoutTask).hashCode());
            UserRecord $userRecord = this.getUserRecord();
            result = result * 59 + ($userRecord == null ? 43 : $userRecord.hashCode());
            return result;
        }

        public String toString() {
            return "KinesisProducer.SettableFutureTracker(future=" + this.getFuture() + ", timestamp=" + this.getTimestamp() + ", timeoutTask=" + this.getTimeoutTask() + ", userRecord=" + this.getUserRecord() + ")";
        }
    }

    private static class SettableFutureTrackerComparator
    implements Comparator<SettableFutureTracker> {
        private SettableFutureTrackerComparator() {
        }

        @Override
        public int compare(SettableFutureTracker x, SettableFutureTracker y) {
            return Long.compare(x.getTimestamp().toEpochMilli(), y.getTimestamp().toEpochMilli());
        }
    }
}

