/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.connectors.flink;

import java.util.List;
import java.util.Properties;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.connectors.flink.FlinkKinesisConsumer;
import software.amazon.kinesis.connectors.flink.internals.DynamoDBStreamsDataFetcher;
import software.amazon.kinesis.connectors.flink.internals.KinesisDataFetcher;
import software.amazon.kinesis.connectors.flink.serialization.KinesisDeserializationSchema;

public class FlinkDynamoDBStreamsConsumer<T>
extends FlinkKinesisConsumer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkDynamoDBStreamsConsumer.class);

    public FlinkDynamoDBStreamsConsumer(String stream, DeserializationSchema<T> deserializer, Properties config) {
        super(stream, deserializer, config);
    }

    public FlinkDynamoDBStreamsConsumer(List<String> streams, KinesisDeserializationSchema deserializer, Properties config) {
        super(streams, deserializer, config);
    }

    @Override
    protected KinesisDataFetcher<T> createFetcher(List<String> streams, SourceFunction.SourceContext<T> sourceContext, RuntimeContext runtimeContext, Properties configProps, KinesisDeserializationSchema<T> deserializationSchema) {
        return new DynamoDBStreamsDataFetcher<T>(streams, sourceContext, runtimeContext, configProps, deserializationSchema, this.getShardAssigner());
    }
}

