/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.connectors.flink.config;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import software.amazon.kinesis.connectors.flink.config.AWSConfigConstants;
import software.amazon.kinesis.connectors.flink.model.SentinelSequenceNumber;

@PublicEvolving
public class ConsumerConfigConstants
extends AWSConfigConstants {
    public static final String RECORD_PUBLISHER_TYPE = "flink.stream.recordpublisher";
    public static final String EFO_CONSUMER_NAME = "flink.stream.efo.consumername";
    public static final String EFO_REGISTRATION_TYPE = "flink.stream.efo.registration";
    public static final String EFO_CONSUMER_ARN_PREFIX = "flink.stream.efo.consumerarn";
    public static final String STREAM_INITIAL_POSITION = "flink.stream.initpos";
    public static final String STREAM_INITIAL_TIMESTAMP = "flink.stream.initpos.timestamp";
    public static final String STREAM_TIMESTAMP_DATE_FORMAT = "flink.stream.initpos.timestamp.format";
    public static final String STREAM_DESCRIBE_RETRIES = "flink.stream.describe.maxretries";
    public static final String STREAM_DESCRIBE_BACKOFF_BASE = "flink.stream.describe.backoff.base";
    public static final String STREAM_DESCRIBE_BACKOFF_MAX = "flink.stream.describe.backoff.max";
    public static final String STREAM_DESCRIBE_BACKOFF_EXPONENTIAL_CONSTANT = "flink.stream.describe.backoff.expconst";
    public static final String LIST_SHARDS_RETRIES = "flink.list.shards.maxretries";
    public static final String LIST_SHARDS_BACKOFF_BASE = "flink.list.shards.backoff.base";
    public static final String LIST_SHARDS_BACKOFF_MAX = "flink.list.shards.backoff.max";
    public static final String LIST_SHARDS_BACKOFF_EXPONENTIAL_CONSTANT = "flink.list.shards.backoff.expconst";
    public static final String DESCRIBE_STREAM_CONSUMER_RETRIES = "flink.stream.describestreamconsumer.maxretries";
    public static final String DESCRIBE_STREAM_CONSUMER_BACKOFF_BASE = "flink.stream.describestreamconsumer.backoff.base";
    public static final String DESCRIBE_STREAM_CONSUMER_BACKOFF_MAX = "flink.stream.describestreamconsumer.backoff.max";
    public static final String DESCRIBE_STREAM_CONSUMER_BACKOFF_EXPONENTIAL_CONSTANT = "flink.stream.describestreamconsumer.backoff.expconst";
    public static final String REGISTER_STREAM_RETRIES = "flink.stream.registerstreamconsumer.maxretries";
    public static final String REGISTER_STREAM_TIMEOUT_SECONDS = "flink.stream.registerstreamconsumer.timeout";
    public static final String REGISTER_STREAM_BACKOFF_BASE = "flink.stream.registerstreamconsumer.backoff.base";
    public static final String REGISTER_STREAM_BACKOFF_MAX = "flink.stream.registerstreamconsumer.backoff.max";
    public static final String REGISTER_STREAM_BACKOFF_EXPONENTIAL_CONSTANT = "flink.stream.registerstreamconsumer.backoff.expconst";
    public static final String DEREGISTER_STREAM_RETRIES = "flink.stream.deregisterstreamconsumer.maxretries";
    public static final String DEREGISTER_STREAM_TIMEOUT_SECONDS = "flink.stream.deregisterstreamconsumer.timeout";
    public static final String DEREGISTER_STREAM_BACKOFF_BASE = "flink.stream.deregisterstreamconsumer.backoff.base";
    public static final String DEREGISTER_STREAM_BACKOFF_MAX = "flink.stream.deregisterstreamconsumer.backoff.max";
    public static final String DEREGISTER_STREAM_BACKOFF_EXPONENTIAL_CONSTANT = "flink.stream.deregisterstreamconsumer.backoff.expconst";
    public static final String SUBSCRIBE_TO_SHARD_RETRIES = "flink.shard.subscribetoshard.maxretries";
    public static final String SUBSCRIBE_TO_SHARD_TIMEOUT_SECONDS = "flink.shard.subscribetoshard.timeout";
    public static final String SUBSCRIBE_TO_SHARD_BACKOFF_BASE = "flink.shard.subscribetoshard.backoff.base";
    public static final String SUBSCRIBE_TO_SHARD_BACKOFF_MAX = "flink.shard.subscribetoshard.backoff.max";
    public static final String SUBSCRIBE_TO_SHARD_BACKOFF_EXPONENTIAL_CONSTANT = "flink.shard.subscribetoshard.backoff.expconst";
    public static final String SHARD_GETRECORDS_MAX = "flink.shard.getrecords.maxrecordcount";
    public static final String SHARD_GETRECORDS_RETRIES = "flink.shard.getrecords.maxretries";
    public static final String SHARD_GETRECORDS_BACKOFF_BASE = "flink.shard.getrecords.backoff.base";
    public static final String SHARD_GETRECORDS_BACKOFF_MAX = "flink.shard.getrecords.backoff.max";
    public static final String SHARD_GETRECORDS_BACKOFF_EXPONENTIAL_CONSTANT = "flink.shard.getrecords.backoff.expconst";
    public static final String SHARD_GETRECORDS_INTERVAL_MILLIS = "flink.shard.getrecords.intervalmillis";
    public static final String SHARD_GETITERATOR_RETRIES = "flink.shard.getiterator.maxretries";
    public static final String SHARD_GETITERATOR_BACKOFF_BASE = "flink.shard.getiterator.backoff.base";
    public static final String SHARD_GETITERATOR_BACKOFF_MAX = "flink.shard.getiterator.backoff.max";
    public static final String SHARD_GETITERATOR_BACKOFF_EXPONENTIAL_CONSTANT = "flink.shard.getiterator.backoff.expconst";
    public static final String SHARD_DISCOVERY_INTERVAL_MILLIS = "flink.shard.discovery.intervalmillis";
    public static final String SHARD_USE_ADAPTIVE_READS = "flink.shard.adaptivereads";
    public static final String SHARD_IDLE_INTERVAL_MILLIS = "flink.shard.idle.interval";
    public static final String WATERMARK_SYNC_MILLIS = "flink.watermark.sync.interval";
    public static final String WATERMARK_LOOKAHEAD_MILLIS = "flink.watermark.lookahead.millis";
    public static final String WATERMARK_SYNC_QUEUE_CAPACITY = "flink.watermark.sync.queue.capacity";
    public static final String EFO_HTTP_CLIENT_MAX_CONCURRENCY = "flink.stream.efo.http-client.max-concurrency";
    public static final String EFO_HTTP_CLIENT_READ_TIMEOUT_MILLIS = "flink.stream.efo.http-client.read-timeout";
    public static final String EFO_HTTP_CLIENT_ACQUISITION_TIMEOUT_MILLIS = "flink.stream.efo.http-client.acquisition-timeout";
    public static final String DEFAULT_STREAM_INITIAL_POSITION = InitialPosition.LATEST.toString();
    public static final String DEFAULT_STREAM_TIMESTAMP_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final int DEFAULT_STREAM_DESCRIBE_RETRIES = 50;
    public static final long DEFAULT_STREAM_DESCRIBE_BACKOFF_BASE = 2000L;
    public static final long DEFAULT_STREAM_DESCRIBE_BACKOFF_MAX = 5000L;
    public static final double DEFAULT_STREAM_DESCRIBE_BACKOFF_EXPONENTIAL_CONSTANT = 1.5;
    public static final long DEFAULT_LIST_SHARDS_BACKOFF_BASE = 1000L;
    public static final long DEFAULT_LIST_SHARDS_BACKOFF_MAX = 5000L;
    public static final double DEFAULT_LIST_SHARDS_BACKOFF_EXPONENTIAL_CONSTANT = 1.5;
    public static final int DEFAULT_LIST_SHARDS_RETRIES = 10;
    public static final int DEFAULT_DESCRIBE_STREAM_CONSUMER_RETRIES = 50;
    public static final long DEFAULT_DESCRIBE_STREAM_CONSUMER_BACKOFF_BASE = 2000L;
    public static final long DEFAULT_DESCRIBE_STREAM_CONSUMER_BACKOFF_MAX = 5000L;
    public static final double DEFAULT_DESCRIBE_STREAM_CONSUMER_BACKOFF_EXPONENTIAL_CONSTANT = 1.5;
    public static final int DEFAULT_REGISTER_STREAM_RETRIES = 10;
    public static final Duration DEFAULT_REGISTER_STREAM_TIMEOUT = Duration.ofSeconds(60L);
    public static final long DEFAULT_REGISTER_STREAM_BACKOFF_BASE = 500L;
    public static final long DEFAULT_REGISTER_STREAM_BACKOFF_MAX = 2000L;
    public static final double DEFAULT_REGISTER_STREAM_BACKOFF_EXPONENTIAL_CONSTANT = 1.5;
    public static final int DEFAULT_DEREGISTER_STREAM_RETRIES = 10;
    public static final Duration DEFAULT_DEREGISTER_STREAM_TIMEOUT = Duration.ofSeconds(60L);
    public static final long DEFAULT_DEREGISTER_STREAM_BACKOFF_BASE = 500L;
    public static final long DEFAULT_DEREGISTER_STREAM_BACKOFF_MAX = 2000L;
    public static final double DEFAULT_DEREGISTER_STREAM_BACKOFF_EXPONENTIAL_CONSTANT = 1.5;
    public static final int DEFAULT_SUBSCRIBE_TO_SHARD_RETRIES = 10;
    public static final Duration DEFAULT_SUBSCRIBE_TO_SHARD_TIMEOUT = Duration.ofSeconds(60L);
    public static final long DEFAULT_SUBSCRIBE_TO_SHARD_BACKOFF_BASE = 1000L;
    public static final long DEFAULT_SUBSCRIBE_TO_SHARD_BACKOFF_MAX = 2000L;
    public static final double DEFAULT_SUBSCRIBE_TO_SHARD_BACKOFF_EXPONENTIAL_CONSTANT = 1.5;
    public static final int DEFAULT_SHARD_GETRECORDS_MAX = 10000;
    public static final int DEFAULT_SHARD_GETRECORDS_RETRIES = 3;
    public static final long DEFAULT_SHARD_GETRECORDS_BACKOFF_BASE = 300L;
    public static final long DEFAULT_SHARD_GETRECORDS_BACKOFF_MAX = 1000L;
    public static final double DEFAULT_SHARD_GETRECORDS_BACKOFF_EXPONENTIAL_CONSTANT = 1.5;
    public static final long DEFAULT_SHARD_GETRECORDS_INTERVAL_MILLIS = 200L;
    public static final int DEFAULT_SHARD_GETITERATOR_RETRIES = 3;
    public static final long DEFAULT_SHARD_GETITERATOR_BACKOFF_BASE = 300L;
    public static final long DEFAULT_SHARD_GETITERATOR_BACKOFF_MAX = 1000L;
    public static final double DEFAULT_SHARD_GETITERATOR_BACKOFF_EXPONENTIAL_CONSTANT = 1.5;
    public static final long DEFAULT_SHARD_DISCOVERY_INTERVAL_MILLIS = 10000L;
    public static final boolean DEFAULT_SHARD_USE_ADAPTIVE_READS = false;
    public static final long DEFAULT_SHARD_IDLE_INTERVAL_MILLIS = -1L;
    public static final long DEFAULT_WATERMARK_SYNC_MILLIS = 30000L;
    public static final int DEFAULT_EFO_HTTP_CLIENT_MAX_CONCURRENCY = 10000;
    public static final Duration DEFAULT_EFO_HTTP_CLIENT_READ_TIMEOUT = Duration.ofMinutes(6L);
    public static final Duration DEFAULT_EFO_HTTP_CLIENT_ACQUISITION_TIMEOUT = Duration.ofMinutes(1L);
    public static final long MAX_SHARD_GETRECORDS_INTERVAL_MILLIS = 300000L;

    public static String efoConsumerArn(String streamName) {
        return "flink.stream.efo.consumerarn." + streamName;
    }

    public static enum EFORegistrationType {
        LAZY,
        EAGER,
        NONE;

    }

    public static enum RecordPublisherType {
        EFO,
        POLLING;

    }

    public static enum InitialPosition {
        TRIM_HORIZON(SentinelSequenceNumber.SENTINEL_EARLIEST_SEQUENCE_NUM),
        LATEST(SentinelSequenceNumber.SENTINEL_LATEST_SEQUENCE_NUM),
        AT_TIMESTAMP(SentinelSequenceNumber.SENTINEL_AT_TIMESTAMP_SEQUENCE_NUM);

        private SentinelSequenceNumber sentinelSequenceNumber;

        private InitialPosition(SentinelSequenceNumber sentinelSequenceNumber) {
            this.sentinelSequenceNumber = sentinelSequenceNumber;
        }

        public SentinelSequenceNumber toSentinelSequenceNumber() {
            return this.sentinelSequenceNumber;
        }
    }
}

