/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.connectors.flink.internals.publisher.polling;

import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.Preconditions;
import software.amazon.kinesis.connectors.flink.internals.KinesisDataFetcher;
import software.amazon.kinesis.connectors.flink.internals.publisher.RecordPublisherFactory;
import software.amazon.kinesis.connectors.flink.internals.publisher.polling.AdaptivePollingRecordPublisher;
import software.amazon.kinesis.connectors.flink.internals.publisher.polling.PollingRecordPublisher;
import software.amazon.kinesis.connectors.flink.internals.publisher.polling.PollingRecordPublisherConfiguration;
import software.amazon.kinesis.connectors.flink.metrics.PollingRecordPublisherMetricsReporter;
import software.amazon.kinesis.connectors.flink.model.StartingPosition;
import software.amazon.kinesis.connectors.flink.model.StreamShardHandle;
import software.amazon.kinesis.connectors.flink.proxy.KinesisProxyInterface;

@Internal
public class PollingRecordPublisherFactory
implements RecordPublisherFactory {
    private final KinesisDataFetcher.FlinkKinesisProxyFactory kinesisProxyFactory;

    public PollingRecordPublisherFactory(KinesisDataFetcher.FlinkKinesisProxyFactory kinesisProxyFactory) {
        this.kinesisProxyFactory = kinesisProxyFactory;
    }

    @Override
    public PollingRecordPublisher create(StartingPosition startingPosition, Properties consumerConfig, MetricGroup metricGroup, StreamShardHandle streamShardHandle) throws InterruptedException {
        Preconditions.checkNotNull((Object)startingPosition);
        Preconditions.checkNotNull((Object)consumerConfig);
        Preconditions.checkNotNull((Object)metricGroup);
        Preconditions.checkNotNull((Object)streamShardHandle);
        PollingRecordPublisherConfiguration configuration = new PollingRecordPublisherConfiguration(consumerConfig);
        PollingRecordPublisherMetricsReporter metricsReporter = new PollingRecordPublisherMetricsReporter(metricGroup);
        KinesisProxyInterface kinesisProxy = this.kinesisProxyFactory.create(consumerConfig);
        if (configuration.isAdaptiveReads()) {
            return new AdaptivePollingRecordPublisher(startingPosition, streamShardHandle, metricsReporter, kinesisProxy, configuration.getMaxNumberOfRecordsPerFetch(), configuration.getFetchIntervalMillis());
        }
        return new PollingRecordPublisher(startingPosition, streamShardHandle, metricsReporter, kinesisProxy, configuration.getMaxNumberOfRecordsPerFetch(), configuration.getFetchIntervalMillis());
    }
}

