/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.connectors.flink.metrics;

import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;

@Internal
public class ShardConsumerMetricsReporter {
    private final MetricGroup metricGroup;
    private volatile long millisBehindLatest = -1L;
    private volatile long averageRecordSizeBytes = 0L;
    private volatile int numberOfAggregatedRecords = 0;
    private volatile int numberOfDeaggregatedRecords = 0;

    public ShardConsumerMetricsReporter(MetricGroup metricGroup) {
        this.metricGroup = metricGroup;
        metricGroup.gauge("millisBehindLatest", this::getMillisBehindLatest);
        metricGroup.gauge("numberOfAggregatedRecordsPerFetch", this::getNumberOfAggregatedRecords);
        metricGroup.gauge("numberOfDeaggregatedRecordsPerFetch", this::getNumberOfDeaggregatedRecords);
        metricGroup.gauge("averageRecordSizeBytes", this::getAverageRecordSizeBytes);
    }

    public long getMillisBehindLatest() {
        return this.millisBehindLatest;
    }

    public void setMillisBehindLatest(long millisBehindLatest) {
        this.millisBehindLatest = millisBehindLatest;
    }

    public long getAverageRecordSizeBytes() {
        return this.averageRecordSizeBytes;
    }

    public void setAverageRecordSizeBytes(long averageRecordSizeBytes) {
        this.averageRecordSizeBytes = averageRecordSizeBytes;
    }

    public int getNumberOfAggregatedRecords() {
        return this.numberOfAggregatedRecords;
    }

    public void setNumberOfAggregatedRecords(int numberOfAggregatedRecords) {
        this.numberOfAggregatedRecords = numberOfAggregatedRecords;
    }

    public int getNumberOfDeaggregatedRecords() {
        return this.numberOfDeaggregatedRecords;
    }

    public void setNumberOfDeaggregatedRecords(int numberOfDeaggregatedRecords) {
        this.numberOfDeaggregatedRecords = numberOfDeaggregatedRecords;
    }

    public void unregister() {
        if (this.metricGroup instanceof AbstractMetricGroup) {
            ((AbstractMetricGroup)this.metricGroup).close();
        }
    }
}

