/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.connectors.flink.model;

import software.amazon.kinesis.connectors.flink.model.StreamShardHandle;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.Shard;

public class DynamoDBStreamsShardHandle
extends StreamShardHandle {
    public static final String SHARDID_PREFIX = "shardId-";
    public static final int SHARDID_PREFIX_LEN = "shardId-".length();

    public DynamoDBStreamsShardHandle(String streamName, Shard shard) {
        super(streamName, shard);
    }

    public static int compareShardIds(String firstShardId, String secondShardId) {
        if (!DynamoDBStreamsShardHandle.isValidShardId(firstShardId)) {
            throw new IllegalArgumentException(String.format("The first shard id %s has invalid format.", firstShardId));
        }
        if (!DynamoDBStreamsShardHandle.isValidShardId(secondShardId)) {
            throw new IllegalArgumentException(String.format("The second shard id %s has invalid format.", secondShardId));
        }
        return firstShardId.substring(SHARDID_PREFIX_LEN).compareTo(secondShardId.substring(SHARDID_PREFIX_LEN));
    }

    public static boolean isValidShardId(String shardId) {
        return shardId == null ? false : shardId.matches("^shardId-\\d{20}-{0,1}\\w{0,36}");
    }
}

