/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.connectors.flink.model;

import java.util.Date;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import software.amazon.kinesis.connectors.flink.model.SentinelSequenceNumber;
import software.amazon.kinesis.connectors.flink.model.SequenceNumber;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.ShardIteratorType;

@Internal
public class StartingPosition {
    private final ShardIteratorType shardIteratorType;
    private final Object startingMarker;

    private StartingPosition(ShardIteratorType shardIteratorType, @Nullable Object startingMarker) {
        this.shardIteratorType = shardIteratorType;
        this.startingMarker = startingMarker;
    }

    public ShardIteratorType getShardIteratorType() {
        return this.shardIteratorType;
    }

    @Nullable
    public Object getStartingMarker() {
        return this.startingMarker;
    }

    public static StartingPosition fromTimestamp(Date date) {
        return new StartingPosition(ShardIteratorType.AT_TIMESTAMP, date);
    }

    public static StartingPosition continueFromSequenceNumber(SequenceNumber sequenceNumber) {
        return StartingPosition.fromSequenceNumber(sequenceNumber, false);
    }

    public static StartingPosition restartFromSequenceNumber(SequenceNumber sequenceNumber) {
        return StartingPosition.fromSequenceNumber(sequenceNumber, true);
    }

    private static StartingPosition fromSequenceNumber(SequenceNumber sequenceNumber, boolean restart) {
        if (SentinelSequenceNumber.isSentinelSequenceNumber(sequenceNumber)) {
            return new StartingPosition(StartingPosition.fromSentinelSequenceNumber(sequenceNumber), null);
        }
        return new StartingPosition(StartingPosition.getShardIteratorType(sequenceNumber, restart), sequenceNumber.getSequenceNumber());
    }

    private static ShardIteratorType getShardIteratorType(SequenceNumber sequenceNumber, boolean restart) {
        return restart && sequenceNumber.isAggregated() ? ShardIteratorType.AT_SEQUENCE_NUMBER : ShardIteratorType.AFTER_SEQUENCE_NUMBER;
    }

    private static ShardIteratorType fromSentinelSequenceNumber(SequenceNumber sequenceNumber) {
        if (sequenceNumber.equals(SentinelSequenceNumber.SENTINEL_LATEST_SEQUENCE_NUM.get())) {
            return ShardIteratorType.LATEST;
        }
        if (sequenceNumber.equals(SentinelSequenceNumber.SENTINEL_EARLIEST_SEQUENCE_NUM.get())) {
            return ShardIteratorType.TRIM_HORIZON;
        }
        throw new IllegalArgumentException("Unexpected sentinel type: " + sequenceNumber);
    }
}

