/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.connectors.flink.proxy;

import java.util.Collections;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import software.amazon.kinesis.connectors.flink.internals.publisher.fanout.FanOutRecordPublisherConfiguration;
import software.amazon.kinesis.connectors.flink.proxy.FullJitterBackoff;
import software.amazon.kinesis.connectors.flink.proxy.KinesisProxyV2;
import software.amazon.kinesis.connectors.flink.proxy.KinesisProxyV2Interface;
import software.amazon.kinesis.connectors.flink.util.AWSUtil;
import software.amazon.kinesis.connectors.flink.util.AwsV2Util;
import software.amazon.kinesis.shaded.com.amazonaws.ClientConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.ClientConfigurationFactory;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisAsyncClient;

@Internal
public class KinesisProxyV2Factory {
    private static final FullJitterBackoff BACKOFF = new FullJitterBackoff();

    public static KinesisProxyV2Interface createKinesisProxyV2(Properties configProps) {
        Preconditions.checkNotNull((Object)configProps);
        ClientConfiguration clientConfiguration = new ClientConfigurationFactory().getConfig();
        KinesisProxyV2Factory.populateDefaultValues(clientConfiguration);
        AWSUtil.setAwsClientConfigProperties(clientConfiguration, configProps);
        SdkAsyncHttpClient httpClient = AwsV2Util.createHttpClient(clientConfiguration, NettyNioAsyncHttpClient.builder(), configProps);
        FanOutRecordPublisherConfiguration configuration = new FanOutRecordPublisherConfiguration(configProps, Collections.emptyList());
        KinesisAsyncClient client = AwsV2Util.createKinesisAsyncClient(configProps, clientConfiguration, httpClient);
        return new KinesisProxyV2(client, httpClient, configuration, BACKOFF);
    }

    private static void populateDefaultValues(ClientConfiguration clientConfiguration) {
        clientConfiguration.setUseTcpKeepAlive(true);
    }
}

