/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.connectors.flink.table;

import java.util.Objects;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import software.amazon.kinesis.connectors.flink.FlinkKinesisConsumer;
import software.amazon.kinesis.connectors.flink.serialization.KinesisDeserializationSchemaWrapper;

@Internal
public class KinesisDynamicSource
implements ScanTableSource {
    private final DataType physicalDataType;
    private final DecodingFormat<DeserializationSchema<RowData>> decodingFormat;
    private final String stream;
    private final Properties consumerProperties;

    public KinesisDynamicSource(DataType physicalDataType, String stream, Properties consumerProperties, DecodingFormat<DeserializationSchema<RowData>> decodingFormat) {
        this.physicalDataType = (DataType)Preconditions.checkNotNull((Object)physicalDataType, (String)"Physical data type must not be null.");
        this.stream = (String)Preconditions.checkNotNull((Object)stream, (String)"Stream must not be null.");
        this.consumerProperties = (Properties)Preconditions.checkNotNull((Object)consumerProperties, (String)"Properties for the Flink Kinesis consumer must not be null.");
        this.decodingFormat = (DecodingFormat)Preconditions.checkNotNull(decodingFormat, (String)"Decoding format must not be null.");
    }

    public ChangelogMode getChangelogMode() {
        return this.decodingFormat.getChangelogMode();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        DeserializationSchema x = (DeserializationSchema)this.decodingFormat.createRuntimeDecoder((DynamicTableSource.Context)runtimeProviderContext, this.physicalDataType);
        KinesisDeserializationSchemaWrapper deserializationSchema = new KinesisDeserializationSchemaWrapper(x);
        FlinkKinesisConsumer kinesisConsumer = new FlinkKinesisConsumer(this.stream, deserializationSchema, this.consumerProperties);
        return SourceFunctionProvider.of(kinesisConsumer, (boolean)false);
    }

    public DynamicTableSource copy() {
        return new KinesisDynamicSource(this.physicalDataType, this.stream, this.consumerProperties, this.decodingFormat);
    }

    public String asSummaryString() {
        return "Kinesis";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KinesisDynamicSource that = (KinesisDynamicSource)o;
        return Objects.equals(this.physicalDataType, that.physicalDataType) && Objects.equals(this.stream, that.stream) && Objects.equals(this.consumerProperties, that.consumerProperties) && Objects.equals(this.decodingFormat, that.decodingFormat);
    }

    public int hashCode() {
        return Objects.hash(this.physicalDataType, this.stream, this.consumerProperties, this.decodingFormat);
    }
}

