/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.connectors.flink.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;
import software.amazon.kinesis.connectors.flink.KinesisPartitioner;

@Internal
public final class RowDataFieldsKinesisPartitioner
extends KinesisPartitioner<RowData> {
    private static final long serialVersionUID = 1L;
    public static final int MAX_PARTITION_KEY_LENGTH = 256;
    public static final String DEFAULT_DELIMITER = String.valueOf('|');
    private final String delimiter;
    private final List<String> fieldNames;
    private final Map<String, RowData.FieldGetter> dynamicFieldGetters;
    private final StringBuilder keyBuffer = new StringBuilder();
    private Map<String, String> staticFields = Collections.emptyMap();
    private int keyBufferStaticPrefixLength = 0;
    private int fieldNamesStaticPrefixLength = 0;

    public RowDataFieldsKinesisPartitioner(CatalogTable table) {
        this(table, DEFAULT_DELIMITER);
    }

    public RowDataFieldsKinesisPartitioner(CatalogTable table, String delimiter) {
        Preconditions.checkNotNull((Object)table, (String)"table");
        Preconditions.checkNotNull((Object)delimiter, (String)"delimiter");
        Preconditions.checkArgument((boolean)table.isPartitioned(), (Object)"Cannot create a RowDataFieldsKinesisPartitioner for a non-partitioned table");
        Preconditions.checkArgument((table.getPartitionKeys().size() == new HashSet(table.getPartitionKeys()).size() ? 1 : 0) != 0, (Object)"The sequence of partition keys cannot contain duplicates");
        TableSchema schema = table.getSchema();
        List<String> schemaFieldsList = Arrays.asList(schema.getFieldNames());
        ArrayList<String> badKeyNames = new ArrayList<String>();
        ArrayList<String> badKeyTypes = new ArrayList<String>();
        for (String fieldName : table.getPartitionKeys()) {
            Optional dataType = schema.getFieldDataType(fieldName);
            if (!dataType.isPresent()) {
                badKeyNames.add(fieldName);
                continue;
            }
            if (RowDataFieldsKinesisPartitioner.hasWellDefinedString(((DataType)dataType.get()).getLogicalType())) continue;
            badKeyTypes.add(fieldName);
        }
        Preconditions.checkArgument((badKeyNames.size() == 0 ? 1 : 0) != 0, (String)"The following partition keys are not present in the table: %s", (Object[])new Object[]{String.join((CharSequence)", ", badKeyNames)});
        Preconditions.checkArgument((badKeyTypes.size() == 0 ? 1 : 0) != 0, (String)"The following partition keys have types that are not supported by Kinesis: %s", (Object[])new Object[]{String.join((CharSequence)", ", badKeyTypes)});
        this.delimiter = delimiter;
        this.fieldNames = table.getPartitionKeys();
        this.dynamicFieldGetters = new HashMap<String, RowData.FieldGetter>();
        for (String fieldName : table.getPartitionKeys()) {
            TableColumn column = (TableColumn)schema.getTableColumn(fieldName).orElseThrow(() -> new RuntimeException("Unexpected field column " + fieldName));
            RowData.FieldGetter fieldGetter = RowData.createFieldGetter((LogicalType)column.getType().getLogicalType(), (int)schemaFieldsList.indexOf(column.getName()));
            this.dynamicFieldGetters.put(fieldName, fieldGetter);
        }
    }

    @Override
    public String getPartitionId(RowData element) {
        this.keyBuffer.setLength(this.keyBufferStaticPrefixLength);
        for (int i = this.fieldNamesStaticPrefixLength; i < this.fieldNames.size(); ++i) {
            String fieldName = this.fieldNames.get(i);
            if (!this.staticFields.containsKey(fieldName)) {
                this.keyBuffer.append(this.dynamicFieldGetters.get(fieldName).getFieldOrNull(element));
            } else {
                this.keyBuffer.append(this.staticFields.get(fieldName));
            }
            this.keyBuffer.append(this.delimiter);
            if (this.keyBuffer.length() >= 256) break;
        }
        int length = Math.min(this.keyBuffer.length() - this.delimiter.length(), 256);
        return this.keyBuffer.substring(0, length);
    }

    public void setStaticFields(Map<String, String> staticFields) {
        Preconditions.checkArgument((boolean)this.isPartitionKeySubset(staticFields.keySet()), (Object)String.format("Not all static field names (%s) are part of the partition key (%s).", String.join((CharSequence)", ", staticFields.keySet()), String.join((CharSequence)", ", this.fieldNames)));
        this.staticFields = new HashMap<String, String>(staticFields);
        this.updateKeyBufferStaticPrefix();
    }

    private boolean isPartitionKeySubset(Set<String> candidateSubset) {
        return new HashSet<String>(this.fieldNames).containsAll(candidateSubset);
    }

    private void updateKeyBufferStaticPrefix() {
        this.keyBuffer.setLength(0);
        this.fieldNamesStaticPrefixLength = 0;
        for (String fieldName : this.fieldNames) {
            if (!this.staticFields.containsKey(fieldName)) break;
            this.keyBuffer.append(this.staticFields.get(fieldName));
            this.keyBuffer.append(this.delimiter);
            ++this.fieldNamesStaticPrefixLength;
        }
        this.keyBufferStaticPrefixLength = this.keyBuffer.length();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowDataFieldsKinesisPartitioner that = (RowDataFieldsKinesisPartitioner)o;
        return Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.fieldNames, that.fieldNames) && Objects.equals(this.staticFields, that.staticFields) && Objects.equals(this.keyBufferStaticPrefixLength, that.keyBufferStaticPrefixLength) && Objects.equals(this.fieldNamesStaticPrefixLength, that.fieldNamesStaticPrefixLength);
    }

    public int hashCode() {
        return Objects.hash(this.delimiter, this.fieldNames, this.staticFields, this.keyBufferStaticPrefixLength, this.fieldNamesStaticPrefixLength);
    }

    public static boolean hasWellDefinedString(LogicalType logicalType) {
        if (logicalType instanceof DistinctType) {
            return RowDataFieldsKinesisPartitioner.hasWellDefinedString(((DistinctType)logicalType).getSourceType());
        }
        switch (logicalType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }
}

