/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.connectors.flink.util;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.util.EnvironmentInformation;
import software.amazon.kinesis.connectors.flink.config.AWSConfigConstants;
import software.amazon.kinesis.connectors.flink.model.SentinelSequenceNumber;
import software.amazon.kinesis.connectors.flink.model.SequenceNumber;
import software.amazon.kinesis.connectors.flink.model.StartingPosition;
import software.amazon.kinesis.connectors.flink.util.BeanDeserializerModifierForIgnorables;
import software.amazon.kinesis.connectors.flink.util.KinesisConfigUtil;
import software.amazon.kinesis.shaded.com.amazonaws.ClientConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.ClientConfigurationFactory;
import software.amazon.kinesis.shaded.com.amazonaws.auth.AWSCredentials;
import software.amazon.kinesis.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import software.amazon.kinesis.shaded.com.amazonaws.auth.BasicAWSCredentials;
import software.amazon.kinesis.shaded.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import software.amazon.kinesis.shaded.com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import software.amazon.kinesis.shaded.com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import software.amazon.kinesis.shaded.com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import software.amazon.kinesis.shaded.com.amazonaws.auth.WebIdentityTokenCredentialsProvider;
import software.amazon.kinesis.shaded.com.amazonaws.auth.profile.ProfileCredentialsProvider;
import software.amazon.kinesis.shaded.com.amazonaws.client.builder.AwsClientBuilder;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.AmazonKinesis;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import software.amazon.kinesis.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import software.amazon.kinesis.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import software.amazon.kinesis.shaded.com.fasterxml.jackson.databind.JsonNode;
import software.amazon.kinesis.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import software.amazon.kinesis.shaded.com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import software.amazon.kinesis.shaded.com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import software.amazon.kinesis.shaded.com.fasterxml.jackson.databind.deser.DeserializerFactory;

@Internal
public class AWSUtil {
    private static final String USER_AGENT_FORMAT = "Apache Flink %s (%s) Kinesis Connector";
    public static final String AWS_CLIENT_CONFIG_PREFIX = "aws.clientconfig.";

    public static AmazonKinesis createKinesisClient(Properties configProps) {
        return AWSUtil.createKinesisClient(configProps, new ClientConfigurationFactory().getConfig());
    }

    public static AmazonKinesis createKinesisClient(Properties configProps, ClientConfiguration awsClientConfig) {
        awsClientConfig.setUserAgentPrefix(AWSUtil.formatFlinkUserAgentPrefix());
        AmazonKinesisClientBuilder builder = (AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withCredentials(AWSUtil.getCredentialsProvider(configProps))).withClientConfiguration(awsClientConfig);
        if (configProps.containsKey("aws.endpoint")) {
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(configProps.getProperty("aws.endpoint"), configProps.getProperty("aws.region")));
        } else {
            builder.withRegion(configProps.getProperty("aws.region"));
        }
        return (AmazonKinesis)builder.build();
    }

    public static String formatFlinkUserAgentPrefix() {
        return String.format(USER_AGENT_FORMAT, EnvironmentInformation.getVersion(), EnvironmentInformation.getRevisionInformation().commitId);
    }

    public static AWSCredentialsProvider getCredentialsProvider(Properties configProps) {
        return AWSUtil.getCredentialsProvider(configProps, "aws.credentials.provider");
    }

    static AWSConfigConstants.CredentialProvider getCredentialProviderType(Properties configProps, String configPrefix) {
        if (!configProps.containsKey(configPrefix)) {
            if (configProps.containsKey(AWSConfigConstants.accessKeyId(configPrefix)) && configProps.containsKey(AWSConfigConstants.secretKey(configPrefix))) {
                return AWSConfigConstants.CredentialProvider.BASIC;
            }
            return AWSConfigConstants.CredentialProvider.AUTO;
        }
        return AWSConfigConstants.CredentialProvider.valueOf(configProps.getProperty(configPrefix));
    }

    private static AWSCredentialsProvider getCredentialsProvider(final Properties configProps, final String configPrefix) {
        AWSConfigConstants.CredentialProvider credentialProviderType = AWSUtil.getCredentialProviderType(configProps, configPrefix);
        switch (credentialProviderType) {
            case ENV_VAR: {
                return new EnvironmentVariableCredentialsProvider();
            }
            case SYS_PROP: {
                return new SystemPropertiesCredentialsProvider();
            }
            case PROFILE: {
                String profileName = configProps.getProperty(AWSConfigConstants.profileName(configPrefix), null);
                String profileConfigPath = configProps.getProperty(AWSConfigConstants.profilePath(configPrefix), null);
                return profileConfigPath == null ? new ProfileCredentialsProvider(profileName) : new ProfileCredentialsProvider(profileConfigPath, profileName);
            }
            case BASIC: {
                return new AWSCredentialsProvider(){

                    @Override
                    public AWSCredentials getCredentials() {
                        return new BasicAWSCredentials(configProps.getProperty(AWSConfigConstants.accessKeyId(configPrefix)), configProps.getProperty(AWSConfigConstants.secretKey(configPrefix)));
                    }

                    @Override
                    public void refresh() {
                    }
                };
            }
            case ASSUME_ROLE: {
                AWSSecurityTokenService baseCredentials = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials(AWSUtil.getCredentialsProvider(configProps, AWSConfigConstants.roleCredentialsProvider(configPrefix)))).withRegion(configProps.getProperty("aws.region"))).build();
                return new STSAssumeRoleSessionCredentialsProvider.Builder(configProps.getProperty(AWSConfigConstants.roleArn(configPrefix)), configProps.getProperty(AWSConfigConstants.roleSessionName(configPrefix))).withExternalId(configProps.getProperty(AWSConfigConstants.externalId(configPrefix))).withStsClient(baseCredentials).build();
            }
            case WEB_IDENTITY_TOKEN: {
                return WebIdentityTokenCredentialsProvider.builder().roleArn(configProps.getProperty(AWSConfigConstants.roleArn(configPrefix), null)).roleSessionName(configProps.getProperty(AWSConfigConstants.roleSessionName(configPrefix), null)).webIdentityTokenFile(configProps.getProperty(AWSConfigConstants.webIdentityTokenFile(configPrefix), null)).build();
            }
            case AUTO: {
                return new DefaultAWSCredentialsProviderChain();
            }
        }
        throw new IllegalArgumentException("Credential provider not supported: " + (Object)((Object)credentialProviderType));
    }

    public static boolean isValidRegion(String region) {
        return Pattern.matches("^[a-z]+-([a-z]+[-]{0,1}[a-z]+-([0-9]|global)|global)$", region);
    }

    public static void setAwsClientConfigProperties(ClientConfiguration config, Properties configProps) {
        HashMap<String, Object> awsConfigProperties = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : configProps.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(AWS_CLIENT_CONFIG_PREFIX)) continue;
            awsConfigProperties.put(key.substring(AWS_CLIENT_CONFIG_PREFIX.length()), entry.getValue());
        }
        String[] ignorableProperties = new String[]{"secureRandom"};
        BeanDeserializerModifierForIgnorables modifier = new BeanDeserializerModifierForIgnorables(ClientConfiguration.class, ignorableProperties);
        DeserializerFactory factory = BeanDeserializerFactory.instance.withDeserializerModifier(modifier);
        ObjectMapper mapper = new ObjectMapper(null, null, new DefaultDeserializationContext.Impl(factory));
        JsonNode propTree = mapper.convertValue(awsConfigProperties, JsonNode.class);
        try {
            mapper.readerForUpdating(config).readValue(propTree);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static StartingPosition getStartingPosition(SequenceNumber sequenceNumber, Properties configProps) {
        if (sequenceNumber.equals(SentinelSequenceNumber.SENTINEL_LATEST_SEQUENCE_NUM.get())) {
            return StartingPosition.fromTimestamp(new Date());
        }
        if (SentinelSequenceNumber.SENTINEL_AT_TIMESTAMP_SEQUENCE_NUM.get().equals(sequenceNumber)) {
            Date timestamp = KinesisConfigUtil.parseStreamTimestampStartingPosition(configProps);
            return StartingPosition.fromTimestamp(timestamp);
        }
        return StartingPosition.restartFromSequenceNumber(sequenceNumber);
    }
}

