/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.auth;

import java.util.HashMap;
import java.util.Map;
import software.amazon.kinesis.shaded.com.amazonaws.ClientConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.auth.AWSCredentials;
import software.amazon.kinesis.shaded.com.amazonaws.auth.STSSessionCredentialsProvider;

public class SessionCredentialsProviderFactory {
    private static final Map<Key, STSSessionCredentialsProvider> cache = new HashMap<Key, STSSessionCredentialsProvider>();

    public static synchronized STSSessionCredentialsProvider getSessionCredentialsProvider(AWSCredentials longTermCredentials, String serviceEndpoint, ClientConfiguration stsClientConfiguration) {
        Key key = new Key(longTermCredentials.getAWSAccessKeyId(), serviceEndpoint);
        if (!cache.containsKey(key)) {
            cache.put(key, new STSSessionCredentialsProvider(longTermCredentials, stsClientConfiguration));
        }
        return cache.get(key);
    }

    private static final class Key {
        private final String awsAccessKeyId;
        private final String serviceEndpoint;

        public Key(String awsAccessKeyId, String serviceEndpoint) {
            this.awsAccessKeyId = awsAccessKeyId;
            this.serviceEndpoint = serviceEndpoint;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.awsAccessKeyId == null ? 0 : this.awsAccessKeyId.hashCode());
            result = 31 * result + (this.serviceEndpoint == null ? 0 : this.serviceEndpoint.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.awsAccessKeyId == null ? other.awsAccessKeyId != null : !this.awsAccessKeyId.equals(other.awsAccessKeyId)) {
                return false;
            }
            return !(this.serviceEndpoint == null ? other.serviceEndpoint != null : !this.serviceEndpoint.equals(other.serviceEndpoint));
        }
    }
}

