/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.StandardUnit;

public class Datapoint
implements Serializable,
Cloneable {
    private Date timestamp;
    private Double sampleCount;
    private Double average;
    private Double sum;
    private Double minimum;
    private Double maximum;
    private String unit;
    private Map<String, Double> extendedStatistics;

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Datapoint withTimestamp(Date timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public void setSampleCount(Double sampleCount) {
        this.sampleCount = sampleCount;
    }

    public Double getSampleCount() {
        return this.sampleCount;
    }

    public Datapoint withSampleCount(Double sampleCount) {
        this.setSampleCount(sampleCount);
        return this;
    }

    public void setAverage(Double average) {
        this.average = average;
    }

    public Double getAverage() {
        return this.average;
    }

    public Datapoint withAverage(Double average) {
        this.setAverage(average);
        return this;
    }

    public void setSum(Double sum) {
        this.sum = sum;
    }

    public Double getSum() {
        return this.sum;
    }

    public Datapoint withSum(Double sum) {
        this.setSum(sum);
        return this;
    }

    public void setMinimum(Double minimum) {
        this.minimum = minimum;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public Datapoint withMinimum(Double minimum) {
        this.setMinimum(minimum);
        return this;
    }

    public void setMaximum(Double maximum) {
        this.maximum = maximum;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public Datapoint withMaximum(Double maximum) {
        this.setMaximum(maximum);
        return this;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public Datapoint withUnit(String unit) {
        this.setUnit(unit);
        return this;
    }

    public void setUnit(StandardUnit unit) {
        this.withUnit(unit);
    }

    public Datapoint withUnit(StandardUnit unit) {
        this.unit = unit.toString();
        return this;
    }

    public Map<String, Double> getExtendedStatistics() {
        return this.extendedStatistics;
    }

    public void setExtendedStatistics(Map<String, Double> extendedStatistics) {
        this.extendedStatistics = extendedStatistics;
    }

    public Datapoint withExtendedStatistics(Map<String, Double> extendedStatistics) {
        this.setExtendedStatistics(extendedStatistics);
        return this;
    }

    public Datapoint addExtendedStatisticsEntry(String key, Double value) {
        if (null == this.extendedStatistics) {
            this.extendedStatistics = new HashMap<String, Double>();
        }
        if (this.extendedStatistics.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.extendedStatistics.put(key, value);
        return this;
    }

    public Datapoint clearExtendedStatisticsEntries() {
        this.extendedStatistics = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTimestamp() != null) {
            sb.append("Timestamp: ").append(this.getTimestamp()).append(",");
        }
        if (this.getSampleCount() != null) {
            sb.append("SampleCount: ").append(this.getSampleCount()).append(",");
        }
        if (this.getAverage() != null) {
            sb.append("Average: ").append(this.getAverage()).append(",");
        }
        if (this.getSum() != null) {
            sb.append("Sum: ").append(this.getSum()).append(",");
        }
        if (this.getMinimum() != null) {
            sb.append("Minimum: ").append(this.getMinimum()).append(",");
        }
        if (this.getMaximum() != null) {
            sb.append("Maximum: ").append(this.getMaximum()).append(",");
        }
        if (this.getUnit() != null) {
            sb.append("Unit: ").append(this.getUnit()).append(",");
        }
        if (this.getExtendedStatistics() != null) {
            sb.append("ExtendedStatistics: ").append(this.getExtendedStatistics());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Datapoint)) {
            return false;
        }
        Datapoint other = (Datapoint)obj;
        if (other.getTimestamp() == null ^ this.getTimestamp() == null) {
            return false;
        }
        if (other.getTimestamp() != null && !other.getTimestamp().equals(this.getTimestamp())) {
            return false;
        }
        if (other.getSampleCount() == null ^ this.getSampleCount() == null) {
            return false;
        }
        if (other.getSampleCount() != null && !other.getSampleCount().equals(this.getSampleCount())) {
            return false;
        }
        if (other.getAverage() == null ^ this.getAverage() == null) {
            return false;
        }
        if (other.getAverage() != null && !other.getAverage().equals(this.getAverage())) {
            return false;
        }
        if (other.getSum() == null ^ this.getSum() == null) {
            return false;
        }
        if (other.getSum() != null && !other.getSum().equals(this.getSum())) {
            return false;
        }
        if (other.getMinimum() == null ^ this.getMinimum() == null) {
            return false;
        }
        if (other.getMinimum() != null && !other.getMinimum().equals(this.getMinimum())) {
            return false;
        }
        if (other.getMaximum() == null ^ this.getMaximum() == null) {
            return false;
        }
        if (other.getMaximum() != null && !other.getMaximum().equals(this.getMaximum())) {
            return false;
        }
        if (other.getUnit() == null ^ this.getUnit() == null) {
            return false;
        }
        if (other.getUnit() != null && !other.getUnit().equals(this.getUnit())) {
            return false;
        }
        if (other.getExtendedStatistics() == null ^ this.getExtendedStatistics() == null) {
            return false;
        }
        return other.getExtendedStatistics() == null || other.getExtendedStatistics().equals(this.getExtendedStatistics());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getSampleCount() == null ? 0 : this.getSampleCount().hashCode());
        hashCode = 31 * hashCode + (this.getAverage() == null ? 0 : this.getAverage().hashCode());
        hashCode = 31 * hashCode + (this.getSum() == null ? 0 : this.getSum().hashCode());
        hashCode = 31 * hashCode + (this.getMinimum() == null ? 0 : this.getMinimum().hashCode());
        hashCode = 31 * hashCode + (this.getMaximum() == null ? 0 : this.getMaximum().hashCode());
        hashCode = 31 * hashCode + (this.getUnit() == null ? 0 : this.getUnit().hashCode());
        hashCode = 31 * hashCode + (this.getExtendedStatistics() == null ? 0 : this.getExtendedStatistics().hashCode());
        return hashCode;
    }

    public Datapoint clone() {
        try {
            return (Datapoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

