/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import software.amazon.kinesis.shaded.com.amazonaws.AmazonWebServiceRequest;
import software.amazon.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricStreamFilter;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricStreamOutputFormat;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricStreamStatisticsConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Tag;

public class PutMetricStreamRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private SdkInternalList<MetricStreamFilter> includeFilters;
    private SdkInternalList<MetricStreamFilter> excludeFilters;
    private String firehoseArn;
    private String roleArn;
    private String outputFormat;
    private SdkInternalList<Tag> tags;
    private SdkInternalList<MetricStreamStatisticsConfiguration> statisticsConfigurations;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PutMetricStreamRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<MetricStreamFilter> getIncludeFilters() {
        if (this.includeFilters == null) {
            this.includeFilters = new SdkInternalList();
        }
        return this.includeFilters;
    }

    public void setIncludeFilters(Collection<MetricStreamFilter> includeFilters) {
        if (includeFilters == null) {
            this.includeFilters = null;
            return;
        }
        this.includeFilters = new SdkInternalList<MetricStreamFilter>(includeFilters);
    }

    public PutMetricStreamRequest withIncludeFilters(MetricStreamFilter ... includeFilters) {
        if (this.includeFilters == null) {
            this.setIncludeFilters(new SdkInternalList<MetricStreamFilter>(includeFilters.length));
        }
        for (MetricStreamFilter ele : includeFilters) {
            this.includeFilters.add(ele);
        }
        return this;
    }

    public PutMetricStreamRequest withIncludeFilters(Collection<MetricStreamFilter> includeFilters) {
        this.setIncludeFilters(includeFilters);
        return this;
    }

    public List<MetricStreamFilter> getExcludeFilters() {
        if (this.excludeFilters == null) {
            this.excludeFilters = new SdkInternalList();
        }
        return this.excludeFilters;
    }

    public void setExcludeFilters(Collection<MetricStreamFilter> excludeFilters) {
        if (excludeFilters == null) {
            this.excludeFilters = null;
            return;
        }
        this.excludeFilters = new SdkInternalList<MetricStreamFilter>(excludeFilters);
    }

    public PutMetricStreamRequest withExcludeFilters(MetricStreamFilter ... excludeFilters) {
        if (this.excludeFilters == null) {
            this.setExcludeFilters(new SdkInternalList<MetricStreamFilter>(excludeFilters.length));
        }
        for (MetricStreamFilter ele : excludeFilters) {
            this.excludeFilters.add(ele);
        }
        return this;
    }

    public PutMetricStreamRequest withExcludeFilters(Collection<MetricStreamFilter> excludeFilters) {
        this.setExcludeFilters(excludeFilters);
        return this;
    }

    public void setFirehoseArn(String firehoseArn) {
        this.firehoseArn = firehoseArn;
    }

    public String getFirehoseArn() {
        return this.firehoseArn;
    }

    public PutMetricStreamRequest withFirehoseArn(String firehoseArn) {
        this.setFirehoseArn(firehoseArn);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public PutMetricStreamRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public PutMetricStreamRequest withOutputFormat(String outputFormat) {
        this.setOutputFormat(outputFormat);
        return this;
    }

    public PutMetricStreamRequest withOutputFormat(MetricStreamOutputFormat outputFormat) {
        this.outputFormat = outputFormat.toString();
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public PutMetricStreamRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public PutMetricStreamRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public List<MetricStreamStatisticsConfiguration> getStatisticsConfigurations() {
        if (this.statisticsConfigurations == null) {
            this.statisticsConfigurations = new SdkInternalList();
        }
        return this.statisticsConfigurations;
    }

    public void setStatisticsConfigurations(Collection<MetricStreamStatisticsConfiguration> statisticsConfigurations) {
        if (statisticsConfigurations == null) {
            this.statisticsConfigurations = null;
            return;
        }
        this.statisticsConfigurations = new SdkInternalList<MetricStreamStatisticsConfiguration>(statisticsConfigurations);
    }

    public PutMetricStreamRequest withStatisticsConfigurations(MetricStreamStatisticsConfiguration ... statisticsConfigurations) {
        if (this.statisticsConfigurations == null) {
            this.setStatisticsConfigurations(new SdkInternalList<MetricStreamStatisticsConfiguration>(statisticsConfigurations.length));
        }
        for (MetricStreamStatisticsConfiguration ele : statisticsConfigurations) {
            this.statisticsConfigurations.add(ele);
        }
        return this;
    }

    public PutMetricStreamRequest withStatisticsConfigurations(Collection<MetricStreamStatisticsConfiguration> statisticsConfigurations) {
        this.setStatisticsConfigurations(statisticsConfigurations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getIncludeFilters() != null) {
            sb.append("IncludeFilters: ").append(this.getIncludeFilters()).append(",");
        }
        if (this.getExcludeFilters() != null) {
            sb.append("ExcludeFilters: ").append(this.getExcludeFilters()).append(",");
        }
        if (this.getFirehoseArn() != null) {
            sb.append("FirehoseArn: ").append(this.getFirehoseArn()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getOutputFormat() != null) {
            sb.append("OutputFormat: ").append(this.getOutputFormat()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getStatisticsConfigurations() != null) {
            sb.append("StatisticsConfigurations: ").append(this.getStatisticsConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricStreamRequest)) {
            return false;
        }
        PutMetricStreamRequest other = (PutMetricStreamRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getIncludeFilters() == null ^ this.getIncludeFilters() == null) {
            return false;
        }
        if (other.getIncludeFilters() != null && !other.getIncludeFilters().equals(this.getIncludeFilters())) {
            return false;
        }
        if (other.getExcludeFilters() == null ^ this.getExcludeFilters() == null) {
            return false;
        }
        if (other.getExcludeFilters() != null && !other.getExcludeFilters().equals(this.getExcludeFilters())) {
            return false;
        }
        if (other.getFirehoseArn() == null ^ this.getFirehoseArn() == null) {
            return false;
        }
        if (other.getFirehoseArn() != null && !other.getFirehoseArn().equals(this.getFirehoseArn())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getOutputFormat() == null ^ this.getOutputFormat() == null) {
            return false;
        }
        if (other.getOutputFormat() != null && !other.getOutputFormat().equals(this.getOutputFormat())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getStatisticsConfigurations() == null ^ this.getStatisticsConfigurations() == null) {
            return false;
        }
        return other.getStatisticsConfigurations() == null || other.getStatisticsConfigurations().equals(this.getStatisticsConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeFilters() == null ? 0 : this.getIncludeFilters().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeFilters() == null ? 0 : this.getExcludeFilters().hashCode());
        hashCode = 31 * hashCode + (this.getFirehoseArn() == null ? 0 : this.getFirehoseArn().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getOutputFormat() == null ? 0 : this.getOutputFormat().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getStatisticsConfigurations() == null ? 0 : this.getStatisticsConfigurations().hashCode());
        return hashCode;
    }

    @Override
    public PutMetricStreamRequest clone() {
        return (PutMetricStreamRequest)super.clone();
    }
}

