/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.AnomalyDetectorConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Range;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform.RangeStaxUnmarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.kinesis.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import software.amazon.kinesis.shaded.com.amazonaws.transform.Unmarshaller;

public class AnomalyDetectorConfigurationStaxUnmarshaller
implements Unmarshaller<AnomalyDetectorConfiguration, StaxUnmarshallerContext> {
    private static AnomalyDetectorConfigurationStaxUnmarshaller instance;

    @Override
    public AnomalyDetectorConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        AnomalyDetectorConfiguration anomalyDetectorConfiguration = new AnomalyDetectorConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return anomalyDetectorConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ExcludedTimeRanges", targetDepth)) {
                    anomalyDetectorConfiguration.withExcludedTimeRanges(new ArrayList<Range>());
                    continue;
                }
                if (context.testExpression("ExcludedTimeRanges/member", targetDepth)) {
                    anomalyDetectorConfiguration.withExcludedTimeRanges(RangeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("MetricTimezone", targetDepth)) continue;
                anomalyDetectorConfiguration.setMetricTimezone(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return anomalyDetectorConfiguration;
    }

    public static AnomalyDetectorConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AnomalyDetectorConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

