/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.AnomalyDetector;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Dimension;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform.AnomalyDetectorConfigurationStaxUnmarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform.DimensionStaxUnmarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform.MetricMathAnomalyDetectorStaxUnmarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform.SingleMetricAnomalyDetectorStaxUnmarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.kinesis.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import software.amazon.kinesis.shaded.com.amazonaws.transform.Unmarshaller;

public class AnomalyDetectorStaxUnmarshaller
implements Unmarshaller<AnomalyDetector, StaxUnmarshallerContext> {
    private static AnomalyDetectorStaxUnmarshaller instance;

    @Override
    public AnomalyDetector unmarshall(StaxUnmarshallerContext context) throws Exception {
        AnomalyDetector anomalyDetector = new AnomalyDetector();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return anomalyDetector;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Namespace", targetDepth)) {
                    anomalyDetector.setNamespace(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MetricName", targetDepth)) {
                    anomalyDetector.setMetricName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Dimensions", targetDepth)) {
                    anomalyDetector.withDimensions(new ArrayList<Dimension>());
                    continue;
                }
                if (context.testExpression("Dimensions/member", targetDepth)) {
                    anomalyDetector.withDimensions(DimensionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Stat", targetDepth)) {
                    anomalyDetector.setStat(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Configuration", targetDepth)) {
                    anomalyDetector.setConfiguration(AnomalyDetectorConfigurationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StateValue", targetDepth)) {
                    anomalyDetector.setStateValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SingleMetricAnomalyDetector", targetDepth)) {
                    anomalyDetector.setSingleMetricAnomalyDetector(SingleMetricAnomalyDetectorStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("MetricMathAnomalyDetector", targetDepth)) continue;
                anomalyDetector.setMetricMathAnomalyDetector(MetricMathAnomalyDetectorStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return anomalyDetector;
    }

    public static AnomalyDetectorStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AnomalyDetectorStaxUnmarshaller();
        }
        return instance;
    }
}

