/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricStreamEntry;
import software.amazon.kinesis.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.kinesis.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import software.amazon.kinesis.shaded.com.amazonaws.transform.Unmarshaller;

public class MetricStreamEntryStaxUnmarshaller
implements Unmarshaller<MetricStreamEntry, StaxUnmarshallerContext> {
    private static MetricStreamEntryStaxUnmarshaller instance;

    @Override
    public MetricStreamEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        MetricStreamEntry metricStreamEntry = new MetricStreamEntry();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return metricStreamEntry;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Arn", targetDepth)) {
                    metricStreamEntry.setArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    metricStreamEntry.setCreationDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("LastUpdateDate", targetDepth)) {
                    metricStreamEntry.setLastUpdateDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("Name", targetDepth)) {
                    metricStreamEntry.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FirehoseArn", targetDepth)) {
                    metricStreamEntry.setFirehoseArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("State", targetDepth)) {
                    metricStreamEntry.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OutputFormat", targetDepth)) continue;
                metricStreamEntry.setOutputFormat(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return metricStreamEntry;
    }

    public static MetricStreamEntryStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MetricStreamEntryStaxUnmarshaller();
        }
        return instance;
    }
}

