/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.DefaultRequest;
import software.amazon.kinesis.shaded.com.amazonaws.Request;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.http.HttpMethodName;
import software.amazon.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.PutInsightRuleRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Tag;
import software.amazon.kinesis.shaded.com.amazonaws.transform.Marshaller;
import software.amazon.kinesis.shaded.com.amazonaws.util.StringUtils;

public class PutInsightRuleRequestMarshaller
implements Marshaller<Request<PutInsightRuleRequest>, PutInsightRuleRequest> {
    @Override
    public Request<PutInsightRuleRequest> marshall(PutInsightRuleRequest putInsightRuleRequest) {
        if (putInsightRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutInsightRuleRequest> request = new DefaultRequest<PutInsightRuleRequest>(putInsightRuleRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutInsightRule");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putInsightRuleRequest.getRuleName() != null) {
            request.addParameter("RuleName", StringUtils.fromString(putInsightRuleRequest.getRuleName()));
        }
        if (putInsightRuleRequest.getRuleState() != null) {
            request.addParameter("RuleState", StringUtils.fromString(putInsightRuleRequest.getRuleState()));
        }
        if (putInsightRuleRequest.getRuleDefinition() != null) {
            request.addParameter("RuleDefinition", StringUtils.fromString(putInsightRuleRequest.getRuleDefinition()));
        }
        if (!putInsightRuleRequest.getTags().isEmpty() || !((SdkInternalList)putInsightRuleRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)putInsightRuleRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

