/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.DefaultRequest;
import software.amazon.kinesis.shaded.com.amazonaws.Request;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.http.HttpMethodName;
import software.amazon.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Dimension;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Metric;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricDataQuery;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricStat;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Tag;
import software.amazon.kinesis.shaded.com.amazonaws.transform.Marshaller;
import software.amazon.kinesis.shaded.com.amazonaws.util.StringUtils;

public class PutMetricAlarmRequestMarshaller
implements Marshaller<Request<PutMetricAlarmRequest>, PutMetricAlarmRequest> {
    @Override
    public Request<PutMetricAlarmRequest> marshall(PutMetricAlarmRequest putMetricAlarmRequest) {
        if (putMetricAlarmRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutMetricAlarmRequest> request = new DefaultRequest<PutMetricAlarmRequest>(putMetricAlarmRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutMetricAlarm");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putMetricAlarmRequest.getAlarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString(putMetricAlarmRequest.getAlarmName()));
        }
        if (putMetricAlarmRequest.getAlarmDescription() != null) {
            request.addParameter("AlarmDescription", StringUtils.fromString(putMetricAlarmRequest.getAlarmDescription()));
        }
        if (putMetricAlarmRequest.getActionsEnabled() != null) {
            request.addParameter("ActionsEnabled", StringUtils.fromBoolean(putMetricAlarmRequest.getActionsEnabled()));
        }
        if (!putMetricAlarmRequest.getOKActions().isEmpty() || !((SdkInternalList)putMetricAlarmRequest.getOKActions()).isAutoConstruct()) {
            SdkInternalList oKActionsList = (SdkInternalList)putMetricAlarmRequest.getOKActions();
            int oKActionsListIndex = 1;
            for (String oKActionsListValue : oKActionsList) {
                if (oKActionsListValue != null) {
                    request.addParameter("OKActions.member." + oKActionsListIndex, StringUtils.fromString(oKActionsListValue));
                }
                ++oKActionsListIndex;
            }
        }
        if (!putMetricAlarmRequest.getAlarmActions().isEmpty() || !((SdkInternalList)putMetricAlarmRequest.getAlarmActions()).isAutoConstruct()) {
            SdkInternalList alarmActionsList = (SdkInternalList)putMetricAlarmRequest.getAlarmActions();
            int alarmActionsListIndex = 1;
            for (String alarmActionsListValue : alarmActionsList) {
                if (alarmActionsListValue != null) {
                    request.addParameter("AlarmActions.member." + alarmActionsListIndex, StringUtils.fromString(alarmActionsListValue));
                }
                ++alarmActionsListIndex;
            }
        }
        if (!putMetricAlarmRequest.getInsufficientDataActions().isEmpty() || !((SdkInternalList)putMetricAlarmRequest.getInsufficientDataActions()).isAutoConstruct()) {
            SdkInternalList insufficientDataActionsList = (SdkInternalList)putMetricAlarmRequest.getInsufficientDataActions();
            int insufficientDataActionsListIndex = 1;
            for (String insufficientDataActionsListValue : insufficientDataActionsList) {
                if (insufficientDataActionsListValue != null) {
                    request.addParameter("InsufficientDataActions.member." + insufficientDataActionsListIndex, StringUtils.fromString(insufficientDataActionsListValue));
                }
                ++insufficientDataActionsListIndex;
            }
        }
        if (putMetricAlarmRequest.getMetricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString(putMetricAlarmRequest.getMetricName()));
        }
        if (putMetricAlarmRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString(putMetricAlarmRequest.getNamespace()));
        }
        if (putMetricAlarmRequest.getStatistic() != null) {
            request.addParameter("Statistic", StringUtils.fromString(putMetricAlarmRequest.getStatistic()));
        }
        if (putMetricAlarmRequest.getExtendedStatistic() != null) {
            request.addParameter("ExtendedStatistic", StringUtils.fromString(putMetricAlarmRequest.getExtendedStatistic()));
        }
        if (!putMetricAlarmRequest.getDimensions().isEmpty() || !((SdkInternalList)putMetricAlarmRequest.getDimensions()).isAutoConstruct()) {
            SdkInternalList dimensionsList = (SdkInternalList)putMetricAlarmRequest.getDimensions();
            int dimensionsListIndex = 1;
            for (Dimension dimensionsListValue : dimensionsList) {
                if (dimensionsListValue != null) {
                    if (dimensionsListValue.getName() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString(dimensionsListValue.getName()));
                    }
                    if (dimensionsListValue.getValue() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString(dimensionsListValue.getValue()));
                    }
                }
                ++dimensionsListIndex;
            }
        }
        if (putMetricAlarmRequest.getPeriod() != null) {
            request.addParameter("Period", StringUtils.fromInteger(putMetricAlarmRequest.getPeriod()));
        }
        if (putMetricAlarmRequest.getUnit() != null) {
            request.addParameter("Unit", StringUtils.fromString(putMetricAlarmRequest.getUnit()));
        }
        if (putMetricAlarmRequest.getEvaluationPeriods() != null) {
            request.addParameter("EvaluationPeriods", StringUtils.fromInteger(putMetricAlarmRequest.getEvaluationPeriods()));
        }
        if (putMetricAlarmRequest.getDatapointsToAlarm() != null) {
            request.addParameter("DatapointsToAlarm", StringUtils.fromInteger(putMetricAlarmRequest.getDatapointsToAlarm()));
        }
        if (putMetricAlarmRequest.getThreshold() != null) {
            request.addParameter("Threshold", StringUtils.fromDouble(putMetricAlarmRequest.getThreshold()));
        }
        if (putMetricAlarmRequest.getComparisonOperator() != null) {
            request.addParameter("ComparisonOperator", StringUtils.fromString(putMetricAlarmRequest.getComparisonOperator()));
        }
        if (putMetricAlarmRequest.getTreatMissingData() != null) {
            request.addParameter("TreatMissingData", StringUtils.fromString(putMetricAlarmRequest.getTreatMissingData()));
        }
        if (putMetricAlarmRequest.getEvaluateLowSampleCountPercentile() != null) {
            request.addParameter("EvaluateLowSampleCountPercentile", StringUtils.fromString(putMetricAlarmRequest.getEvaluateLowSampleCountPercentile()));
        }
        if (!putMetricAlarmRequest.getMetrics().isEmpty() || !((SdkInternalList)putMetricAlarmRequest.getMetrics()).isAutoConstruct()) {
            SdkInternalList metricsList = (SdkInternalList)putMetricAlarmRequest.getMetrics();
            int metricsListIndex = 1;
            for (MetricDataQuery metricsListValue : metricsList) {
                if (metricsListValue != null) {
                    MetricStat metricStat;
                    if (metricsListValue.getId() != null) {
                        request.addParameter("Metrics.member." + metricsListIndex + ".Id", StringUtils.fromString(metricsListValue.getId()));
                    }
                    if ((metricStat = metricsListValue.getMetricStat()) != null) {
                        Metric metric = metricStat.getMetric();
                        if (metric != null) {
                            if (metric.getNamespace() != null) {
                                request.addParameter("Metrics.member." + metricsListIndex + ".MetricStat.Metric.Namespace", StringUtils.fromString(metric.getNamespace()));
                            }
                            if (metric.getMetricName() != null) {
                                request.addParameter("Metrics.member." + metricsListIndex + ".MetricStat.Metric.MetricName", StringUtils.fromString(metric.getMetricName()));
                            }
                            if (!metric.getDimensions().isEmpty() || !((SdkInternalList)metric.getDimensions()).isAutoConstruct()) {
                                SdkInternalList dimensionsList = (SdkInternalList)metric.getDimensions();
                                int dimensionsListIndex = 1;
                                for (Dimension dimensionsListValue : dimensionsList) {
                                    if (dimensionsListValue != null) {
                                        if (dimensionsListValue.getName() != null) {
                                            request.addParameter("Metrics.member." + metricsListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString(dimensionsListValue.getName()));
                                        }
                                        if (dimensionsListValue.getValue() != null) {
                                            request.addParameter("Metrics.member." + metricsListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString(dimensionsListValue.getValue()));
                                        }
                                    }
                                    ++dimensionsListIndex;
                                }
                            }
                        }
                        if (metricStat.getPeriod() != null) {
                            request.addParameter("Metrics.member." + metricsListIndex + ".MetricStat.Period", StringUtils.fromInteger(metricStat.getPeriod()));
                        }
                        if (metricStat.getStat() != null) {
                            request.addParameter("Metrics.member." + metricsListIndex + ".MetricStat.Stat", StringUtils.fromString(metricStat.getStat()));
                        }
                        if (metricStat.getUnit() != null) {
                            request.addParameter("Metrics.member." + metricsListIndex + ".MetricStat.Unit", StringUtils.fromString(metricStat.getUnit()));
                        }
                    }
                    if (metricsListValue.getExpression() != null) {
                        request.addParameter("Metrics.member." + metricsListIndex + ".Expression", StringUtils.fromString(metricsListValue.getExpression()));
                    }
                    if (metricsListValue.getLabel() != null) {
                        request.addParameter("Metrics.member." + metricsListIndex + ".Label", StringUtils.fromString(metricsListValue.getLabel()));
                    }
                    if (metricsListValue.getReturnData() != null) {
                        request.addParameter("Metrics.member." + metricsListIndex + ".ReturnData", StringUtils.fromBoolean(metricsListValue.getReturnData()));
                    }
                    if (metricsListValue.getPeriod() != null) {
                        request.addParameter("Metrics.member." + metricsListIndex + ".Period", StringUtils.fromInteger(metricsListValue.getPeriod()));
                    }
                    if (metricsListValue.getAccountId() != null) {
                        request.addParameter("Metrics.member." + metricsListIndex + ".AccountId", StringUtils.fromString(metricsListValue.getAccountId()));
                    }
                }
                ++metricsListIndex;
            }
        }
        if (!putMetricAlarmRequest.getTags().isEmpty() || !((SdkInternalList)putMetricAlarmRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)putMetricAlarmRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (putMetricAlarmRequest.getThresholdMetricId() != null) {
            request.addParameter("ThresholdMetricId", StringUtils.fromString(putMetricAlarmRequest.getThresholdMetricId()));
        }
        return request;
    }
}

