/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.DefaultRequest;
import software.amazon.kinesis.shaded.com.amazonaws.Request;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.http.HttpMethodName;
import software.amazon.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricStreamFilter;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricStreamStatisticsConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricStreamStatisticsMetric;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.PutMetricStreamRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Tag;
import software.amazon.kinesis.shaded.com.amazonaws.transform.Marshaller;
import software.amazon.kinesis.shaded.com.amazonaws.util.StringUtils;

public class PutMetricStreamRequestMarshaller
implements Marshaller<Request<PutMetricStreamRequest>, PutMetricStreamRequest> {
    @Override
    public Request<PutMetricStreamRequest> marshall(PutMetricStreamRequest putMetricStreamRequest) {
        if (putMetricStreamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutMetricStreamRequest> request = new DefaultRequest<PutMetricStreamRequest>(putMetricStreamRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutMetricStream");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putMetricStreamRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(putMetricStreamRequest.getName()));
        }
        if (!putMetricStreamRequest.getIncludeFilters().isEmpty() || !((SdkInternalList)putMetricStreamRequest.getIncludeFilters()).isAutoConstruct()) {
            SdkInternalList includeFiltersList = (SdkInternalList)putMetricStreamRequest.getIncludeFilters();
            int includeFiltersListIndex = 1;
            for (MetricStreamFilter includeFiltersListValue : includeFiltersList) {
                if (includeFiltersListValue != null && includeFiltersListValue.getNamespace() != null) {
                    request.addParameter("IncludeFilters.member." + includeFiltersListIndex + ".Namespace", StringUtils.fromString(includeFiltersListValue.getNamespace()));
                }
                ++includeFiltersListIndex;
            }
        }
        if (!putMetricStreamRequest.getExcludeFilters().isEmpty() || !((SdkInternalList)putMetricStreamRequest.getExcludeFilters()).isAutoConstruct()) {
            SdkInternalList excludeFiltersList = (SdkInternalList)putMetricStreamRequest.getExcludeFilters();
            int excludeFiltersListIndex = 1;
            for (MetricStreamFilter excludeFiltersListValue : excludeFiltersList) {
                if (excludeFiltersListValue != null && excludeFiltersListValue.getNamespace() != null) {
                    request.addParameter("ExcludeFilters.member." + excludeFiltersListIndex + ".Namespace", StringUtils.fromString(excludeFiltersListValue.getNamespace()));
                }
                ++excludeFiltersListIndex;
            }
        }
        if (putMetricStreamRequest.getFirehoseArn() != null) {
            request.addParameter("FirehoseArn", StringUtils.fromString(putMetricStreamRequest.getFirehoseArn()));
        }
        if (putMetricStreamRequest.getRoleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString(putMetricStreamRequest.getRoleArn()));
        }
        if (putMetricStreamRequest.getOutputFormat() != null) {
            request.addParameter("OutputFormat", StringUtils.fromString(putMetricStreamRequest.getOutputFormat()));
        }
        if (!putMetricStreamRequest.getTags().isEmpty() || !((SdkInternalList)putMetricStreamRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)putMetricStreamRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (!putMetricStreamRequest.getStatisticsConfigurations().isEmpty() || !((SdkInternalList)putMetricStreamRequest.getStatisticsConfigurations()).isAutoConstruct()) {
            SdkInternalList statisticsConfigurationsList = (SdkInternalList)putMetricStreamRequest.getStatisticsConfigurations();
            int statisticsConfigurationsListIndex = 1;
            for (MetricStreamStatisticsConfiguration statisticsConfigurationsListValue : statisticsConfigurationsList) {
                if (statisticsConfigurationsListValue != null) {
                    if (!statisticsConfigurationsListValue.getIncludeMetrics().isEmpty() || !((SdkInternalList)statisticsConfigurationsListValue.getIncludeMetrics()).isAutoConstruct()) {
                        SdkInternalList includeMetricsList = (SdkInternalList)statisticsConfigurationsListValue.getIncludeMetrics();
                        int includeMetricsListIndex = 1;
                        for (MetricStreamStatisticsMetric includeMetricsListValue : includeMetricsList) {
                            if (includeMetricsListValue != null) {
                                if (includeMetricsListValue.getNamespace() != null) {
                                    request.addParameter("StatisticsConfigurations.member." + statisticsConfigurationsListIndex + ".IncludeMetrics.member." + includeMetricsListIndex + ".Namespace", StringUtils.fromString(includeMetricsListValue.getNamespace()));
                                }
                                if (includeMetricsListValue.getMetricName() != null) {
                                    request.addParameter("StatisticsConfigurations.member." + statisticsConfigurationsListIndex + ".IncludeMetrics.member." + includeMetricsListIndex + ".MetricName", StringUtils.fromString(includeMetricsListValue.getMetricName()));
                                }
                            }
                            ++includeMetricsListIndex;
                        }
                    }
                    if (!statisticsConfigurationsListValue.getAdditionalStatistics().isEmpty() || !((SdkInternalList)statisticsConfigurationsListValue.getAdditionalStatistics()).isAutoConstruct()) {
                        SdkInternalList additionalStatisticsList = (SdkInternalList)statisticsConfigurationsListValue.getAdditionalStatistics();
                        int additionalStatisticsListIndex = 1;
                        for (String additionalStatisticsListValue : additionalStatisticsList) {
                            if (additionalStatisticsListValue != null) {
                                request.addParameter("StatisticsConfigurations.member." + statisticsConfigurationsListIndex + ".AdditionalStatistics.member." + additionalStatisticsListIndex, StringUtils.fromString(additionalStatisticsListValue));
                            }
                            ++additionalStatisticsListIndex;
                        }
                    }
                }
                ++statisticsConfigurationsListIndex;
            }
        }
        return request;
    }
}

