/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import org.w3c.dom.Node;
import software.amazon.kinesis.shaded.com.amazonaws.AmazonServiceException;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.ResourceNotFoundException;
import software.amazon.kinesis.shaded.com.amazonaws.transform.StandardErrorUnmarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.util.XpathUtils;

public class ResourceNotFoundExceptionUnmarshaller
extends StandardErrorUnmarshaller {
    public ResourceNotFoundExceptionUnmarshaller() {
        super(ResourceNotFoundException.class);
    }

    @Override
    public AmazonServiceException unmarshall(Node node) throws Exception {
        String errorCode = this.parseErrorCode(node);
        if (errorCode == null || !errorCode.equals("ResourceNotFoundException")) {
            return null;
        }
        ResourceNotFoundException e = (ResourceNotFoundException)super.unmarshall(node);
        e.setResourceType(XpathUtils.asString(this.getErrorPropertyPath("ResourceType"), node));
        e.setResourceId(XpathUtils.asString(this.getErrorPropertyPath("ResourceId"), node));
        return e;
    }
}

